/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.scanner.AbstractScanner;
import de.unkrig.commons.text.scanner.ScanException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatefulScanner<TT extends Enum<TT>, S extends Enum<S>>
extends AbstractScanner<TT> {
    private final List<Rule<TT, S>> defaultStateRules = new ArrayList<Rule<TT, S>>();
    private final Map<S, List<Rule<TT, S>>> nonDefaultStateRules = new HashMap<S, List<Rule<TT, S>>>();
    private List<Rule<TT, S>> currentStateRules = this.defaultStateRules;

    public StatefulScanner(Class<S> states) {
        for (Enum state : (Enum[])states.getEnumConstants()) {
            this.nonDefaultStateRules.put(state, new ArrayList());
        }
    }

    public void addRule(String regex, TT tokenType) {
        this.addRule(regex, tokenType, this.defaultStateRules);
    }

    public void addRule(String regex, TT tokenType, S nextState) {
        this.addRule(regex, tokenType, this.nonDefaultStateRules.get(nextState));
    }

    public void addRule(@Nullable S state, String regex, TT tokenType) {
        this.addRule(state, regex, tokenType, this.defaultStateRules);
    }

    public void addRule(@Nullable S state, String regex, TT tokenType, S nextState) {
        this.addRule(state, regex, tokenType, this.nonDefaultStateRules.get(nextState));
    }

    @Override
    @Nullable
    public AbstractScanner.Token<TT> produce() throws ScanException {
        int length = this.cs.length();
        if (this.offset == length) {
            return null;
        }
        for (Rule<TT, S> rule : this.currentStateRules) {
            Matcher matcher = rule.regex.matcher(this.cs);
            matcher.region(this.offset, length);
            if (!matcher.lookingAt()) continue;
            this.currentStateRules = rule.nextStateRules;
            this.previousTokenOffset = this.offset;
            this.offset = matcher.end();
            return new AbstractScanner.Token(rule.tokenType, matcher.group());
        }
        throw new ScanException("Unexpected character '" + this.cs.charAt(this.offset) + "' at offset " + this.offset + " of '" + this.cs + "'");
    }

    private void addRule(String regex, TT tokenType, List<Rule<TT, S>> nextRules) {
        this.defaultStateRules.add(new Rule<TT, S>(regex, tokenType, nextRules));
    }

    private void addRule(@Nullable S state, String regex, TT tokenType, List<Rule<TT, S>> nextRules) {
        Rule<TT, S> rule = new Rule<TT, S>(regex, tokenType, nextRules);
        if (state != null) {
            this.nonDefaultStateRules.get(state).add(rule);
        } else {
            for (List<Rule<TT, S>> rules : this.nonDefaultStateRules.values()) {
                rules.add(rule);
            }
            this.defaultStateRules.add(rule);
        }
    }

    private static class Rule<TT extends Enum<TT>, S extends Enum<S>> {
        final TT tokenType;
        final Pattern regex;
        final List<Rule<TT, S>> nextStateRules;

        Rule(String regex, TT tokenType, List<Rule<TT, S>> nextStateRules) {
            this.regex = Pattern.compile(regex);
            this.tokenType = tokenType;
            this.nextStateRules = nextStateRules;
        }
    }
}

