/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.Readers;
import de.unkrig.commons.lang.protocol.StringTransformers;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;

public class TransformingFilterReader
extends FilterReader {
    private final Transformer<? super CharSequence, ? extends CharSequence> transformer;
    private String buffer = "";
    private static final int MAX_SKIP_BUFFER_SIZE = 8192;
    @Nullable
    private char[] skipBuffer;

    public static Reader create(Reader delegate, Transformer<? super CharSequence, ? extends CharSequence> transformer) {
        if (transformer == TransformerUtil.identity()) {
            return delegate;
        }
        if (transformer == StringTransformers.TO_EMPTY) {
            return Readers.EMPTY_READER;
        }
        return new TransformingFilterReader(delegate, transformer);
    }

    public TransformingFilterReader(Reader delegate, Transformer<? super CharSequence, ? extends CharSequence> transformer) {
        super(delegate);
        this.transformer = transformer;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.isEmpty()) {
            char c = this.buffer.charAt(0);
            this.buffer = this.buffer.substring(1);
            return c;
        }
        int c = this.in.read();
        if (c == -1) {
            CharSequence csq = this.transformer.transform("");
            if (csq.length() == 0) {
                return -1;
            }
            char c2 = csq.charAt(0);
            this.buffer = csq.subSequence(1, csq.length()).toString();
            return c2;
        }
        CharSequence csq = this.transformer.transform(new String(new char[]{(char)c}));
        if (csq.length() == 0) {
            return -1;
        }
        char c2 = csq.charAt(0);
        this.buffer = csq.subSequence(1, csq.length()).toString();
        return c2;
    }

    @Override
    public int read(@Nullable char[] cbuf, int off, int len) throws IOException {
        int bl;
        while (this.buffer.isEmpty()) {
            char[] ca = new char[1024];
            int n = this.in.read(ca);
            if (n < 0) {
                this.buffer = this.transformer.transform("").toString();
                if (!this.buffer.isEmpty()) break;
                return -1;
            }
            if (n == 0) {
                return 0;
            }
            if (n <= 0) continue;
            this.buffer = this.transformer.transform(new Segment(ca, 0, n)).toString();
        }
        if ((bl = this.buffer.length()) < len) {
            System.arraycopy(this.buffer.toCharArray(), 0, cbuf, off, bl);
            this.buffer = "";
            return bl;
        }
        System.arraycopy(this.buffer.toCharArray(), 0, cbuf, off, len);
        this.buffer = this.buffer.substring(len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        int nc;
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int nn = (int)Math.min(n, 8192L);
        char[] skipb = this.skipBuffer;
        if (skipb == null || skipb.length < nn) {
            skipb = this.skipBuffer = new char[nn];
        }
        for (long r = n; r > 0L; r -= (long)nc) {
            nc = this.read(skipb, 0, (int)Math.min(r, (long)nn));
            if (nc != -1) continue;
            return n - r;
        }
        return 0L;
    }

    @Override
    public boolean ready() {
        return !this.buffer.isEmpty();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("mark() not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }
}

