/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import de.unkrig.commons.io.LineUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class Docs {
    public static final Comparator<Type> TYPE_COMPARATOR;
    public static final Comparator<Doc> DOCS_BY_NAME_COMPARATOR;

    private Docs() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Doc findDoc(Doc from, String to, RootDoc rootDoc) throws Longjump {
        ArrayList<Object> parameterTypes;
        String methodName;
        PackageDoc referencedPackage;
        String what;
        String where;
        int hashPos = to.indexOf(35);
        if (hashPos == -1) {
            where = to;
            what = null;
        } else if (hashPos == 0) {
            where = null;
            what = to.substring(1);
        } else {
            where = to.substring(0, hashPos);
            what = to.substring(hashPos + 1);
        }
        Object classScope = from instanceof MemberDoc ? ((MemberDoc)from).containingClass() : (from instanceof ClassDoc ? (ClassDoc)from : null);
        ClassDoc referencedClass = null;
        if (where == null) {
            if (classScope == null) {
                rootDoc.printError(from.position(), "\"" + to + "\": No type declaration in scope");
                throw new Longjump();
            }
            referencedClass = classScope;
        } else if (classScope != null) {
            ClassDoc c;
            referencedClass = classScope.findClass(where);
            int firstDot = where.indexOf(46);
            if (referencedClass == null && firstDot != -1 && (c = classScope.findClass(where.substring(0, firstDot))) != null) {
                referencedClass = c.findClass(where.substring(firstDot + 1));
            }
        } else {
            referencedClass = from instanceof PackageDoc ? ((PackageDoc)from).findClass(where) : rootDoc.classNamed(where);
        }
        if (referencedClass == null && classScope != null) {
            referencedClass = rootDoc.classNamed(classScope.containingPackage().name() + '.' + where);
        }
        if (referencedClass == null && (referencedPackage = rootDoc.packageNamed(where)) != null && what != null) {
            rootDoc.printError(from.position(), "Cannot use '#' on package");
        }
        if (referencedClass == null) {
            return null;
        }
        where = referencedClass.qualifiedName();
        if (what == null) {
            return referencedClass;
        }
        int op = what.indexOf(40);
        if (op == -1) {
            methodName = what;
            parameterTypes = null;
        } else {
            methodName = what.substring(0, op);
            if (what.charAt(what.length() - 1) != ')') {
                what = what + ')';
            }
            parameterTypes = new ArrayList<Object>();
            String parameterTypeSequence = what.substring(op + 1, what.length() - 1);
            if (parameterTypeSequence.length() > 0) {
                void var13_20;
                String[] stringArray = parameterTypeSequence.split("\\s*,\\s*");
                int n = stringArray.length;
                boolean i = false;
                while (var13_20 < n) {
                    String ptn = stringArray[var13_20];
                    ClassDoc parameterTypeDoc = (ClassDoc)Docs.findDoc(from, ptn, rootDoc);
                    parameterTypes.add(parameterTypeDoc == null ? ptn : parameterTypeDoc);
                    ++var13_20;
                }
            }
        }
        if (methodName.equals(referencedClass.simpleTypeName())) {
            for (MethodDoc methodDoc : referencedClass.constructors(false)) {
                if (!Docs.equalParameters(parameterTypes, methodDoc.parameters())) continue;
                return methodDoc;
            }
        } else {
            for (MethodDoc methodDoc : Docs.allMethods(referencedClass)) {
                if (!methodName.equals(methodDoc.name()) || !Docs.equalParameters(parameterTypes, methodDoc.parameters())) continue;
                return methodDoc;
            }
        }
        for (FieldDoc fd : Docs.allFields(referencedClass)) {
            if (!what.equals(fd.name())) continue;
            return fd;
        }
        for (FieldDoc fd : referencedClass.enumConstants()) {
            if (!what.equals(fd.name())) continue;
            return fd;
        }
        rootDoc.printError(from.position(), "Cannot find '" + what + "' in '" + where + "'");
        throw new Longjump();
    }

    private static FieldDoc[] allFields(ClassDoc clasS) {
        ArrayList<FieldDoc> result = new ArrayList<FieldDoc>();
        for (ClassDoc cd : Docs.withSuperclasses(clasS)) {
            result.addAll(Arrays.asList(cd.fields()));
        }
        return result.toArray(new FieldDoc[result.size()]);
    }

    public static ClassDoc[] withSuperclasses(ClassDoc clasS) {
        ArrayList<ClassDoc> result = new ArrayList<ClassDoc>();
        for (ClassDoc c = clasS; c != null; c = c.superclass()) {
            result.add(c);
        }
        return result.toArray(new ClassDoc[result.size()]);
    }

    private static MethodDoc[] allMethods(ClassDoc clasS) {
        ArrayList<MethodDoc> result = new ArrayList<MethodDoc>();
        for (ClassDoc cd : Docs.withSuperclassesAndInterfaces(clasS)) {
            result.addAll(Arrays.asList(cd.methods()));
        }
        return result.toArray(new MethodDoc[result.size()]);
    }

    public static ClassDoc[] withSuperclassesAndInterfaces(ClassDoc clasS) {
        ArrayList<ClassDoc> result = new ArrayList<ClassDoc>();
        Docs.addClassSuperclassesAndInterfaces(clasS, result);
        return result.toArray(new ClassDoc[result.size()]);
    }

    private static void addClassSuperclassesAndInterfaces(ClassDoc clasS, List<ClassDoc> result) {
        result.add(clasS);
        ClassDoc superclass = clasS.superclass();
        if (superclass != null) {
            Docs.addClassSuperclassesAndInterfaces(superclass, result);
        }
        for (ClassDoc interfacE : clasS.interfaces()) {
            Docs.addInterfaceAndExtendedInterfaces(interfacE, result);
        }
    }

    private static void addInterfaceAndExtendedInterfaces(ClassDoc interfacE, List<ClassDoc> result) {
        result.add(interfacE);
        for (ClassDoc extendedInterface : interfacE.interfaces()) {
            if (result.contains(extendedInterface)) continue;
            result.add(extendedInterface);
            Docs.addInterfaceAndExtendedInterfaces(extendedInterface, result);
        }
    }

    private static boolean equalParameters(@Nullable List<Object> expected, Parameter[] actual) {
        if (expected == null) {
            return true;
        }
        if (expected.size() != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.size(); ++i) {
            Object parameterType = expected.get(i);
            Type mdParameterType = actual[i].type();
            ClassDoc mdParameterClassDoc = mdParameterType.asClassDoc();
            if (!(mdParameterClassDoc == null ? !mdParameterType.toString().equals(parameterType) : !mdParameterClassDoc.equals(parameterType))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ClassDoc classScope(Doc doc) {
        return doc instanceof ClassDoc ? (ClassDoc)doc : (doc instanceof MemberDoc ? ((MemberDoc)doc).containingClass() : null);
    }

    @Nullable
    public static PackageDoc packageScope(Doc doc) {
        return doc instanceof PackageDoc ? (PackageDoc)doc : (doc instanceof ProgramElementDoc ? ((ProgramElementDoc)doc).containingPackage() : null);
    }

    public static MethodDoc[] methods(ClassDoc classDoc, boolean filter, boolean includeInherited) {
        if (!includeInherited) {
            return classDoc.methods(filter);
        }
        ArrayList<MethodDoc> result = new ArrayList<MethodDoc>();
        result.addAll(Arrays.asList(classDoc.methods(filter)));
        ClassDoc superclassDoc = classDoc.superclass();
        if (superclassDoc != null && !"org.apache.tools.ant.ProjectComponent".equals(superclassDoc.qualifiedName()) && !"org.apache.tools.ant.Task".equals(superclassDoc.qualifiedName())) {
            result.addAll(Arrays.asList(Docs.methods(superclassDoc, filter, true)));
        }
        for (ClassDoc interfaceDoc : classDoc.interfaces()) {
            result.addAll(Arrays.asList(Docs.methods(interfaceDoc, filter, true)));
        }
        return result.toArray(new MethodDoc[result.size()]);
    }

    public static ClassDoc classNamed(RootDoc rootDoc, String className) throws Longjump {
        ClassDoc result = rootDoc.classNamed(className);
        if (result == null) {
            rootDoc.printError("\"" + className + "\" missing on classpath");
            throw new Longjump();
        }
        return result;
    }

    public static boolean isSubclassOf(ClassDoc a, ClassDoc b) {
        if (a == b) {
            return true;
        }
        for (ClassDoc i : a.interfaces()) {
            if (!Docs.isSubclassOf(i, b)) continue;
            return true;
        }
        ClassDoc s = a.superclass();
        return s != null && Docs.isSubclassOf(s, b);
    }

    public static void readExternalJavadocs(URL targetUrl, URL packageListUrl, Map<String, URL> externalJavadocs, RootDoc rootDoc) throws IOException {
        assert (targetUrl.toString().endsWith("/")) : targetUrl;
        assert (packageListUrl.getPath().endsWith("/")) : packageListUrl;
        List<String> packageNames = LineUtil.readAllLines(new InputStreamReader(new URL(packageListUrl, "package-list").openStream()), true);
        for (String packageName : packageNames) {
            URL prev = externalJavadocs.put(packageName, targetUrl);
            if (prev == null || prev.equals(targetUrl)) continue;
            rootDoc.printError("Inconsistent links: Package \"" + packageName + "\" was first linked to \"" + prev + "\", now to \"" + targetUrl + "\"");
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        TYPE_COMPARATOR = new Comparator<Type>(){

            @Override
            public int compare(@Nullable Type t1, @Nullable Type t2) {
                assert (t1 != null);
                assert (t2 != null);
                return t1.toString().compareTo(t2.toString());
            }
        };
        DOCS_BY_NAME_COMPARATOR = new Comparator<Doc>(){

            @Override
            public int compare(@Nullable Doc d1, @Nullable Doc d2) {
                if (d1 == null) {
                    return d2 == null ? 0 : 1;
                }
                if (d2 == null) {
                    return -1;
                }
                return d1.name().compareToIgnoreCase(d2.name());
            }
        };
    }
}

