/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.main;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import de.unkrig.commons.doclet.Annotations;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class MainDoclet {
    private static File destination;
    private static String method;
    private static Charset docEncoding;
    @Nullable
    private static String charset;
    @Nullable
    private static String doctitle;
    private static boolean quiet;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        destination = new File(".");
        method = "main(String[])";
        docEncoding = Charset.defaultCharset();
    }

    @CommandLineOption(name={"-d", "--destination"})
    public static void setDestination(File destDir) {
        destination = destDir;
    }

    @CommandLineOption
    public static void setMethod(String method) {
        MainDoclet.method = method;
    }

    @CommandLineOption
    public static void setDocencoding(Charset charset) {
        docEncoding = charset;
    }

    @CommandLineOption
    public static void setCharset(String name) {
        charset = name;
    }

    @CommandLineOption
    public static void setDoctitle(String title) {
        doctitle = title;
    }

    @CommandLineOption
    public static void setQuiet() {
        quiet = true;
    }

    @CommandLineOption
    public static void setBottom(String text) {
    }

    @CommandLineOption
    public static void addLinkoffline(String extDocUrl, String packageListLoc) {
    }

    @CommandLineOption
    public static void setWindowtitle(String title) {
    }

    private MainDoclet() {
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) throws IOException {
        if ("-help".equals(option)) {
            CommandLineOptions.printResource(MainDoclet.class, (String)"start(RootDoc).txt", (Charset)Charset.forName("UTF-8"), (PrintStream)System.out);
            return 1;
        }
        Method m = CommandLineOptions.getMethodForOption((String)option, MainDoclet.class);
        return m == null ? 0 : 1 + m.getParameterTypes().length;
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        String[][] stringArray = rootDoc.options();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] option = stringArray[n2];
            Method m = CommandLineOptions.getMethodForOption((String)option[0], MainDoclet.class);
            if (m != null) {
                int res;
                try {
                    res = CommandLineOptions.applyCommandLineOption((String)option[0], (Method)m, (String[])option, (int)1, null);
                }
                catch (Exception e) {
                    throw (IOException)ExceptionUtil.wrap((String)("Parsing command line option \"" + option[0] + "\""), (Throwable)e, IOException.class);
                }
                assert (res == option.length);
            }
            ++n2;
        }
        ArrayList<ClassDoc> allClasses = new ArrayList<ClassDoc>();
        allClasses.addAll(Arrays.asList(rootDoc.specifiedClasses()));
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        int n3 = packageDocArray.length;
        n = 0;
        while (n < n3) {
            PackageDoc pd = packageDocArray[n];
            allClasses.addAll(Arrays.asList(pd.allClasses()));
            ++n;
        }
        if (allClasses.isEmpty()) {
            System.err.println("No classes specified.");
            throw new IOException();
        }
        for (ClassDoc cd : allClasses) {
            MethodDoc[] methodDocArray = cd.methods();
            int n4 = methodDocArray.length;
            int n5 = 0;
            while (n5 < n4) {
                MethodDoc md = methodDocArray[n5];
                String tmp = String.valueOf(md.name()) + md.flatSignature();
                if (method.equals(tmp)) {
                    MainDoclet.convertDoc((Doc)md, destination, docEncoding, rootDoc);
                }
                ++n5;
            }
        }
        return true;
    }

    private static void convertDoc(Doc doc, File destination, Charset charset, RootDoc rootDoc) throws IOException {
        String htmlText;
        final ClassDoc cd = doc.isClass() ? (ClassDoc)doc : (doc instanceof MemberDoc ? ((MemberDoc)doc).containingClass() : (ClassDoc)ExceptionUtil.throW((Throwable)((Object)new AssertionError((Object)String.valueOf(doc)))));
        Html html = new Html(Html.STANDARD_LINK_MAKER){

            /*
             * Unable to fully structure code
             */
            protected String expandTag(Doc ref, RootDoc rootDoc, Tag tag) throws Longjump {
                block9: {
                    tagName = tag.name();
                    if (!"@main.commandLineOptions".equals(tagName) && !"@command-line-options".equals(tagName)) break block9;
                    if ("@command-line-options".equals(tagName)) {
                        rootDoc.printWarning(ref.position(), "\"@command-line-options\" is deprecated; use \"@main.commandLineOptions\" instead");
                    }
                    sb = new StringBuilder();
                    c = cd;
                    while (c != null) {
                        var10_10 = c.methods();
                        var9_9 = var10_10.length;
                        var8_8 = 0;
                        while (var8_8 < var9_9) {
                            block10: {
                                block11: {
                                    md = var10_10[var8_8];
                                    cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                                    if (cload == null || md.inlineTags().length == 0 && Tags.optionalTag((Doc)md, (String)"see", (DocErrorReporter)rootDoc) != null) break block10;
                                    clogts = md.tags("@main.commandLineOptionGroup");
                                    if (clogts.length == 0 && (clogts = md.tags("@command-line-option-group")).length > 0) {
                                        rootDoc.printWarning(ref.position(), "\"@command-line-option-group\" is deprecated; use \"@main.commandLineOptionGroup\" instead");
                                    }
                                    if (tag.inlineTags().length != 0) break block11;
                                    if (clogts.length == 0) ** GOTO lbl30
                                    break block10;
                                }
                                var16_18 = clogts;
                                var15_16 = clogts.length;
                                var14_15 = 0;
                                while (var14_15 < var15_16) {
                                    clogt = var16_18[var14_15];
                                    if (!clogt.text().equals(tag.text())) {
                                        ++var14_15;
                                        continue;
                                    }
lbl30:
                                    // 3 sources

                                    this.attributeTerm(md, sb, rootDoc);
                                    var15_17 = c.methods();
                                    var14_15 = var15_17.length;
                                    var13_14 = 0;
                                    while (var13_14 < var14_15) {
                                        md2 = var15_17[var13_14];
                                        if (Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc) != null && md2.inlineTags().length == 0 && (seeTag = (SeeTag)Tags.optionalTag((Doc)md2, (String)"see", (DocErrorReporter)rootDoc)) != null && Html.targetOfSeeTag((SeeTag)seeTag) == md) {
                                            this.attributeTerm(md2, sb, rootDoc);
                                        }
                                        ++var13_14;
                                    }
                                    sb.append("  <dd>");
                                    deprecatedTag = Tags.optionalTag((Doc)md, (String)"deprecated", (DocErrorReporter)rootDoc);
                                    if (deprecatedTag != null) {
                                        sb.append("<i><b>Deprecated</b> - ");
                                        sb.append(this.fromTags(deprecatedTag.inlineTags(), (Doc)md, rootDoc));
                                        sb.append("</i>");
                                    }
                                    sb.append(this.fromTags(md.inlineTags(), (Doc)md, rootDoc));
                                    sb.append("</dd>\n");
                                    break;
                                }
                            }
                            ++var8_8;
                        }
                        c = c.superclass();
                    }
                    return sb.toString();
                }
                return super.expandTag(ref, rootDoc, tag);
            }

            private void attributeTerm(MethodDoc md, StringBuilder out, RootDoc rootDoc) throws Longjump {
                AnnotationDesc cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                if (cload == null) {
                    return;
                }
                if (!$assertionsDisabled && cload == null) {
                    throw new AssertionError();
                }
                String[] names = (String[])Annotations.getElementValue((AnnotationDesc)cload, (String)"name", String[].class);
                if (names == null) {
                    String n = md.name();
                    if (n.startsWith("set")) {
                        n = n.substring(3);
                    } else if (n.startsWith("add")) {
                        n = n.substring(3);
                    } else if (n.startsWith("is")) {
                        n = n.substring(2);
                    }
                    names = new String[]{Notations.fromCamelCase((String)n).toLowerCaseHyphenated()};
                }
                String suffix = "";
                Object[] objectArray = md.parameters();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block13: {
                        Parameter p = objectArray[n2];
                        Tag[] tagArray = md.tags("@param");
                        int n3 = tagArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Tag paramTag = tagArray[n4];
                            String fs = this.fromTags(paramTag.firstSentenceTags(), (Doc)md, rootDoc);
                            if (paramTag.text().startsWith(String.valueOf(p.name()) + " ")) {
                                suffix = String.valueOf(suffix) + fs.substring(p.name().length());
                                break block13;
                            }
                            ++n4;
                        }
                        suffix = String.valueOf(suffix) + " <var>" + Notations.fromCamelCase((String)p.name()).toLowerCaseHyphenated() + "</var>";
                    }
                    ++n2;
                }
                objectArray = names;
                n = names.length;
                n2 = 0;
                while (n2 < n) {
                    Object name = objectArray[n2];
                    if (!name.startsWith("-")) {
                        name = String.valueOf(name.length() == 1 ? "-" : "--") + (String)name;
                    }
                    out.append("  <dt><code>" + (String)name + "</code>" + suffix + "</dt>\n");
                    ++n2;
                }
            }
        };
        try {
            htmlText = html.fromTags(doc.inlineTags(), doc, rootDoc);
        }
        catch (Longjump e) {
            return;
        }
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("doc", doc);
        dataModel.put("htmlText", htmlText);
        File outputFile = new File(destination, String.valueOf(cd.qualifiedName().replace('.', File.separatorChar)) + "." + doc.name() + (doc instanceof ExecutableMemberDoc ? ((ExecutableMemberDoc)doc).flatSignature() : "") + ".html");
        if (!quiet) {
            System.err.println("Generating \"" + outputFile + "\"...");
        }
        if (destination.exists() && !outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            IoUtil.outputFilePrintWriter((File)outputFile, (Charset)charset, (ConsumerWhichThrows)new ConsumerWhichThrows<PrintWriter, Exception>(){

                public void consume(PrintWriter pw) throws Exception {
                    pw.println("<html>");
                    pw.println("  <head>");
                    if (charset != null) {
                        pw.println("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\" />");
                    }
                    pw.println("  </head>");
                    pw.println("  <body>");
                    if (doctitle != null) {
                        pw.println("    <h1>" + doctitle + "</h1>");
                    }
                    pw.println(htmlText);
                    pw.println("  </body>");
                    pw.println("</html>");
                }
            });
        }
        catch (Exception e) {
            throw new IOException(null, e);
        }
    }
}

