/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.xml;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class XmlUtil {
    private static final ErrorListener SIMPLE_ERROR_LISTENER;
    private static final String LOCATOR_KEY = "locationDataKey";

    static {
        AssertionUtil.enableAssertionsForThisClass();
        SIMPLE_ERROR_LISTENER = new ErrorListener(){

            @Override
            public void warning(@Nullable TransformerException e) throws TransformerException {
                throw e;
            }

            @Override
            public void fatalError(@Nullable TransformerException e) throws TransformerException {
                throw e;
            }

            @Override
            public void error(@Nullable TransformerException e) throws TransformerException {
                throw e;
            }
        };
    }

    private XmlUtil() {
    }

    public static Document parse(DocumentBuilder documentBuilder, File inputFile, @Nullable String encoding) throws ParserConfigurationException, SAXException, TransformerException, IOException {
        InputSource inputSource = new InputSource("file:" + inputFile.getAbsolutePath());
        if (encoding != null) {
            inputSource.setEncoding(encoding);
        }
        inputSource.setPublicId(inputFile.getPath());
        return XmlUtil.parse(documentBuilder, inputSource);
    }

    public static Document parse(DocumentBuilder documentBuilder, InputSource inputSource) throws ParserConfigurationException, SAXException, TransformerException, IOException {
        Transformer nullTransformer = TransformerFactory.newInstance().newTransformer();
        nullTransformer.setErrorListener(SIMPLE_ERROR_LISTENER);
        Document document = documentBuilder.newDocument();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader = XmlUtil.anotateLocations(xmlReader, (EventTarget)((Object)document));
        SAXSource saxSource = new SAXSource(xmlReader, inputSource);
        try {
            nullTransformer.transform(saxSource, new DOMResult(document));
        }
        catch (TransformerException te) {
            Throwable t = te.getException();
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw te;
        }
        return document;
    }

    @Nullable
    public static Locator getLocation(Node node) {
        return (Locator)node.getUserData(LOCATOR_KEY);
    }

    private static XMLReader anotateLocations(XMLReader delegate, EventTarget eventTarget) {
        return new PositionAnnotatingXMLReader(delegate, eventTarget);
    }

    public static String toString(Node node) {
        return node.getNodeType() == 1 ? String.valueOf('<') + node.getNodeName() + '>' : node.toString();
    }

    public static Iterable<Node> iterable(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int idx;

                    @Override
                    public Node next() {
                        if (this.idx >= nodeList.getLength()) {
                            throw new NoSuchElementException();
                        }
                        return nodeList.item(this.idx++);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx < nodeList.getLength();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    static class PositionAnnotatingXMLReader
    extends XMLFilterImpl {
        @Nullable
        private Locator locator;
        private final UserDataHandler dataHandler = new UserDataHandler(){

            @Override
            @NotNullByDefault(value=false)
            public void handle(short operation, String key, Object data, Node src, Node dst) {
                if (src != null && dst != null) {
                    dst.setUserData(XmlUtil.LOCATOR_KEY, src.getUserData(XmlUtil.LOCATOR_KEY), this);
                }
            }
        };

        PositionAnnotatingXMLReader(XMLReader delegate, EventTarget eventTarget) {
            super(delegate);
            eventTarget.addEventListener("DOMNodeInserted", new EventListener(){

                @Override
                public void handleEvent(@Nullable Event event) {
                    MutationEvent mutationEvent;
                    EventTarget target;
                    if (event instanceof MutationEvent && (target = (mutationEvent = (MutationEvent)event).getTarget()) instanceof Node) {
                        Node node = (Node)((Object)target);
                        LocatorImpl l = new LocatorImpl(PositionAnnotatingXMLReader.this.locator);
                        node.setUserData(XmlUtil.LOCATOR_KEY, l, PositionAnnotatingXMLReader.this.dataHandler);
                    }
                }
            }, true);
        }

        @Override
        @NotNullByDefault(value=false)
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }
    }
}

