/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.ByteFilter;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class ByteFilterInputStream
extends FilterInputStream {
    private final Thread worker;
    @Nullable
    private IOException byteFilterIOException;
    @Nullable
    private RuntimeException byteFilterRuntimeException;

    public ByteFilterInputStream(final InputStream in, final ByteFilter<?> byteFilter) {
        super(new PipedInputStream());
        PipedOutputStream pos;
        try {
            pos = new PipedOutputStream((PipedInputStream)this.in);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.worker = new Thread("PipeFilterInputStream"){

            @Override
            public void run() {
                try {
                    byteFilter.run(in, pos);
                }
                catch (IOException ioe) {
                    ByteFilterInputStream.this.byteFilterIOException = ioe;
                }
                catch (RuntimeException re) {
                    ByteFilterInputStream.this.byteFilterRuntimeException = re;
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        };
        this.worker.start();
    }

    @Override
    public int read() throws IOException {
        int n;
        byte[] buffer = new byte[1];
        do {
            if ((n = this.read(buffer, 0, 1)) == -1) {
                return -1;
            }
            if (n != 1) continue;
            return 0xFF & buffer[0];
        } while (n == 0);
        throw new IllegalStateException();
    }

    @Override
    @NotNullByDefault(value=false)
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (this.byteFilterIOException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterIOException);
        }
        if (this.byteFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterRuntimeException);
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        if (this.byteFilterIOException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterIOException);
        }
        if (this.byteFilterRuntimeException != null) {
            throw ExceptionUtil.wrap("ByteFilterInputStream", this.byteFilterRuntimeException);
        }
    }
}

