/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.main;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import de.unkrig.commons.doclet.Annotations;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.annotation.CommandLineOption;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public final class MainDoclet {
    private static File destination;
    private static String method;
    private static Charset docEncoding;
    @Nullable
    private static String charset;
    @Nullable
    private static String doctitle;
    private static boolean quiet;

    @CommandLineOption(name={"-d", "--destination"})
    public static void setDestination(File destDir) {
        destination = destDir;
    }

    @CommandLineOption
    public static void setMethod(String method) {
        MainDoclet.method = method;
    }

    @CommandLineOption
    public static void setDocencoding(Charset charset) {
        docEncoding = charset;
    }

    @CommandLineOption
    public static void setCharset(String name) {
        charset = name;
    }

    @CommandLineOption
    public static void setDoctitle(String title) {
        doctitle = title;
    }

    @CommandLineOption
    public static void setQuiet() {
        quiet = true;
    }

    @CommandLineOption
    public static void setBottom(String text) {
    }

    @CommandLineOption
    public static void addLinkoffline(String extDocUrl, String packageListLoc) {
    }

    @CommandLineOption
    public static void setWindowtitle(String title) {
    }

    private MainDoclet() {
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) throws IOException {
        if ("-help".equals(option)) {
            CommandLineOptions.printResource(MainDoclet.class, (String)"start(RootDoc).txt", (Charset)Charset.forName("UTF-8"), (PrintStream)System.out);
            return 1;
        }
        Method m = CommandLineOptions.getMethodForOption((String)option, MainDoclet.class);
        return m == null ? 0 : 1 + m.getParameterTypes().length;
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        for (String[] option : rootDoc.options()) {
            int res;
            Method m = CommandLineOptions.getMethodForOption((String)option[0], MainDoclet.class);
            if (m == null) continue;
            try {
                res = CommandLineOptions.applyCommandLineOption((String)option[0], (Method)m, (String[])option, (int)1, null);
            }
            catch (Exception e) {
                throw (IOException)ExceptionUtil.wrap((String)("Parsing command line option \"" + option[0] + "\""), (Throwable)e, IOException.class);
            }
            assert (res == option.length);
        }
        ArrayList<ClassDoc> allClasses = new ArrayList<ClassDoc>();
        allClasses.addAll(Arrays.asList(rootDoc.specifiedClasses()));
        for (PackageDoc pd : rootDoc.specifiedPackages()) {
            allClasses.addAll(Arrays.asList(pd.allClasses()));
        }
        if (allClasses.isEmpty()) {
            System.err.println("No classes specified.");
            throw new IOException();
        }
        for (ClassDoc cd : allClasses) {
            MethodDoc md2;
            block9: {
                for (MethodDoc md2 : cd.methods()) {
                    String tmp = md2.name() + md2.flatSignature();
                    if (!method.equals(tmp)) {
                        continue;
                    }
                    break block9;
                }
                if (cd.containingClass() != null) continue;
                rootDoc.printWarning(cd.position(), "Class \"" + cd.qualifiedTypeName() + "\" has no \"" + method + "\" method");
                continue;
            }
            MethodDoc doc = md2;
            MainDoclet.convertDoc((Doc)doc, destination, docEncoding, rootDoc);
        }
        return true;
    }

    private static void convertDoc(Doc doc, File destination, Charset charset, RootDoc rootDoc) throws IOException {
        String htmlText;
        final ClassDoc cd = doc.isClass() ? (ClassDoc)doc : (doc instanceof MemberDoc ? ((MemberDoc)doc).containingClass() : (ClassDoc)ExceptionUtil.throW((Throwable)((Object)new AssertionError((Object)String.valueOf(doc)))));
        Html html = new Html(Html.STANDARD_LINK_MAKER){

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            protected String expandTag(Doc ref, RootDoc rootDoc, Tag tag) throws Longjump {
                block9: {
                    tagName = tag.name();
                    if (!"@main.commandLineOptions".equals(tagName) && !"@command-line-options".equals(tagName)) break block9;
                    if ("@command-line-options".equals(tagName)) {
                        rootDoc.printWarning(ref.position(), "\"@command-line-options\" is deprecated; use \"@main.commandLineOptions\" instead");
                    }
                    sb = new StringBuilder();
                    for (c = cd; c != null; c = c.superclass()) {
                        block1: for (MethodDoc md : c.methods()) {
                            block10: {
                                cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                                if (cload == null || md.inlineTags().length == 0 && Tags.optionalTag((Doc)md, (String)"see", (DocErrorReporter)rootDoc) != null) continue;
                                clogts = md.tags("@main.commandLineOptionGroup");
                                if (clogts.length == 0 && (clogts = md.tags("@command-line-option-group")).length > 0) {
                                    rootDoc.printWarning(ref.position(), "\"@command-line-option-group\" is deprecated; use \"@main.commandLineOptionGroup\" instead");
                                }
                                if (tag.inlineTags().length != 0) break block10;
                                if (clogts.length != 0) {
                                    continue;
                                }
                                ** GOTO lbl24
                            }
                            var13_13 = clogts;
                            var14_15 = var13_13.length;
                            for (var15_16 = 0; var15_16 < var14_15; ++var15_16) {
                                clogt = var13_13[var15_16];
                                if (!clogt.text().equals(tag.text())) {
                                    continue;
                                }
lbl24:
                                // 3 sources

                                this.attributeTerm(md, sb, rootDoc);
                                for (Tag md2 : c.methods()) {
                                    if (Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc) == null || md2.inlineTags().length != 0 || (seeTag = (SeeTag)Tags.optionalTag((Doc)md2, (String)"see", (DocErrorReporter)rootDoc)) == null || Html.targetOfSeeTag((SeeTag)seeTag) != md) continue;
                                    this.attributeTerm((MethodDoc)md2, sb, rootDoc);
                                }
                                sb.append("  <dd>");
                                deprecatedTag = Tags.optionalTag((Doc)md, (String)"deprecated", (DocErrorReporter)rootDoc);
                                if (deprecatedTag != null) {
                                    sb.append("<i><b>Deprecated</b> - ");
                                    sb.append(this.fromTags(deprecatedTag.inlineTags(), (Doc)md, rootDoc));
                                    sb.append("</i>");
                                }
                                sb.append(this.fromTags(md.inlineTags(), (Doc)md, rootDoc));
                                sb.append("</dd>\n");
                                continue block1;
                            }
                        }
                    }
                    return sb.toString();
                }
                return super.expandTag(ref, rootDoc, tag);
            }

            /*
             * WARNING - void declaration
             */
            private void attributeTerm(MethodDoc md, StringBuilder out, RootDoc rootDoc) throws Longjump {
                AnnotationDesc cload = Annotations.get((ProgramElementDoc)md, CommandLineOption.class, (RootDoc)rootDoc);
                if (cload == null) {
                    return;
                }
                assert (cload != null);
                String[] names = (String[])Annotations.getElementValue((AnnotationDesc)cload, (String)"name", String[].class);
                if (names == null) {
                    String n = md.name();
                    if (n.startsWith("set")) {
                        n = n.substring(3);
                    } else if (n.startsWith("add")) {
                        n = n.substring(3);
                    } else if (n.startsWith("is")) {
                        n = n.substring(2);
                    }
                    names = new String[]{Notations.fromCamelCase((String)n).toLowerCaseHyphenated()};
                }
                String suffix = "";
                block0: for (Parameter parameter : md.parameters()) {
                    for (Tag paramTag : md.tags("@param")) {
                        String fs = this.fromTags(paramTag.firstSentenceTags(), (Doc)md, rootDoc);
                        if (!paramTag.text().startsWith(parameter.name() + " ")) continue;
                        suffix = suffix + fs.substring(parameter.name().length());
                        continue block0;
                    }
                    suffix = suffix + " <var>" + Notations.fromCamelCase((String)parameter.name()).toLowerCaseHyphenated() + "</var>";
                }
                for (String string : names) {
                    void var10_15;
                    if (!string.startsWith("-")) {
                        String string2 = (string.length() == 1 ? "-" : "--") + string;
                    }
                    out.append("  <dt><code>" + (String)var10_15 + "</code>" + suffix + "</dt>\n");
                }
            }
        };
        try {
            htmlText = html.fromTags(doc.inlineTags(), doc, rootDoc);
        }
        catch (Longjump e) {
            return;
        }
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("doc", doc);
        dataModel.put("htmlText", htmlText);
        File outputFile = new File(destination, cd.qualifiedName().replace('.', File.separatorChar) + "." + doc.name() + (doc instanceof ExecutableMemberDoc ? ((ExecutableMemberDoc)doc).flatSignature() : "") + ".html");
        if (!quiet) {
            System.err.println("Generating \"" + outputFile + "\"...");
        }
        if (destination.exists() && !outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().mkdirs();
        }
        try {
            IoUtil.outputFilePrintWriter((File)outputFile, (Charset)charset, (ConsumerWhichThrows)new ConsumerWhichThrows<PrintWriter, Exception>(){

                public void consume(PrintWriter pw) throws Exception {
                    pw.println("<html>");
                    pw.println("  <head>");
                    if (charset != null) {
                        pw.println("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charset + "\" />");
                    }
                    pw.println("  </head>");
                    pw.println("  <body>");
                    if (doctitle != null) {
                        pw.println("    <h1>" + doctitle + "</h1>");
                    }
                    pw.println(htmlText);
                    pw.println("  </body>");
                    pw.println("</html>");
                }
            });
        }
        catch (Exception e) {
            throw new IOException(null, e);
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        destination = new File(".");
        method = "main(String[])";
        docEncoding = Charset.defaultCharset();
    }
}

