/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.cs;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import de.unkrig.commons.doclet.Annotations;
import de.unkrig.commons.doclet.Docs;
import de.unkrig.commons.doclet.Types;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.Comparators;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.util.CommandLineOptions;
import de.unkrig.commons.util.collections.ElementWithContext;
import de.unkrig.commons.util.collections.IterableUtil;
import de.unkrig.csdoclet.annotation.BooleanRuleProperty;
import de.unkrig.csdoclet.annotation.FileRuleProperty;
import de.unkrig.csdoclet.annotation.HiddenRuleProperty;
import de.unkrig.csdoclet.annotation.IntegerRuleProperty;
import de.unkrig.csdoclet.annotation.MultiCheckRuleProperty;
import de.unkrig.csdoclet.annotation.RegexRuleProperty;
import de.unkrig.csdoclet.annotation.SingleSelectRuleProperty;
import de.unkrig.csdoclet.annotation.StringRuleProperty;
import de.unkrig.doclet.cs.CheckstyleMetadataDotPropertiesGenerator;
import de.unkrig.doclet.cs.CheckstyleMetadataDotXmlGenerator;
import de.unkrig.doclet.cs.MessagesDotPropertiesGenerator;
import de.unkrig.doclet.cs.html.templates.AllRulesFrameHtml;
import de.unkrig.doclet.cs.html.templates.IndexHtml;
import de.unkrig.doclet.cs.html.templates.OptionProviderDetailHtml;
import de.unkrig.doclet.cs.html.templates.OverviewSummaryHtml;
import de.unkrig.doclet.cs.html.templates.QuickfixDetailHtml;
import de.unkrig.doclet.cs.html.templates.RuleDetailHtml;
import de.unkrig.notemplate.NoTemplate;
import de.unkrig.notemplate.javadocish.IndexPages;
import de.unkrig.notemplate.javadocish.Options;
import de.unkrig.notemplate.javadocish.templates.AbstractRightFrameHtml;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CsDoclet {
    private static final Pattern SETTER;
    private static final Pattern CONTAINS_HTML_MARKUP;
    private static final Pattern CODE_BLOCK;

    private CsDoclet() {
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) throws IOException {
        if ("-help".equals(option)) {
            CommandLineOptions.printResource(CsDoclet.class, (String)"start(RootDoc).txt", (Charset)Charset.forName("UTF-8"), (OutputStream)System.out);
            return 1;
        }
        if ("-d".equals(option)) {
            return 2;
        }
        if ("-windowtitle".equals(option)) {
            return 2;
        }
        if ("-doctitle".equals(option)) {
            return 2;
        }
        if ("-header".equals(option)) {
            return 2;
        }
        if ("-footer".equals(option)) {
            return 2;
        }
        if ("-top".equals(option)) {
            return 2;
        }
        if ("-bottom".equals(option)) {
            return 2;
        }
        if ("-notimestamp".equals(option)) {
            return 1;
        }
        if ("-checkstyle-metadata.properties-dir".equals(option)) {
            return 2;
        }
        if ("-checkstyle-metadata.xml-dir".equals(option)) {
            return 2;
        }
        if ("-messages.properties-dir".equals(option)) {
            return 2;
        }
        if ("-link".equals(option)) {
            return 2;
        }
        if ("-linkoffline".equals(option)) {
            return 3;
        }
        if ("-splitindex".equals(option)) {
            return 1;
        }
        return 0;
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        Locale.setDefault(Locale.ENGLISH);
        boolean generateHtml = false;
        Options options = new Options();
        File checkstyleMetadataDotPropertiesDir = null;
        File checkstyleMetadataDotXmlDir = null;
        File messagesDotPropertiesDir = null;
        HashMap externalJavadocs = new HashMap();
        for (String[] option : rootDoc.options()) {
            URL targetUrl;
            if ("-d".equals(option[0])) {
                options.destination = new File(option[1]);
                generateHtml = true;
                continue;
            }
            if ("-windowtitle".equals(option[0])) {
                options.windowTitle = option[1];
                continue;
            }
            if ("-doctitle".equals(option[0])) {
                options.docTitle = option[1];
                continue;
            }
            if ("-header".equals(option[0])) {
                options.header = option[1];
                continue;
            }
            if ("-footer".equals(option[0])) {
                options.footer = option[1];
                continue;
            }
            if ("-top".equals(option[0])) {
                options.top = option[1];
                continue;
            }
            if ("-bottom".equals(option[0])) {
                options.bottom = option[1];
                continue;
            }
            if ("-notimestamp".equals(option[0])) {
                options.noTimestamp = Boolean.parseBoolean(option[1]);
                continue;
            }
            if ("-checkstyle-metadata.properties-dir".equals(option[0])) {
                checkstyleMetadataDotPropertiesDir = new File(option[1]);
                continue;
            }
            if ("-checkstyle-metadata.xml-dir".equals(option[0])) {
                checkstyleMetadataDotXmlDir = new File(option[1]);
                continue;
            }
            if ("-messages.properties-dir".equals(option[0])) {
                messagesDotPropertiesDir = new File(option[1]);
                continue;
            }
            if ("-link".equals(option[0])) {
                targetUrl = new URL(option[1] + '/');
                Docs.readExternalJavadocs((URL)targetUrl, (URL)targetUrl, externalJavadocs, (RootDoc)rootDoc);
                continue;
            }
            if ("-linkoffline".equals(option[0])) {
                targetUrl = new URL(option[1] + '/');
                URL packageListUrl = new URL(option[2] + '/');
                Docs.readExternalJavadocs((URL)targetUrl, (URL)packageListUrl, externalJavadocs, (RootDoc)rootDoc);
                continue;
            }
            if (!"-splitindex".equals(option[0])) continue;
            options.splitIndex = true;
        }
        if (!generateHtml && checkstyleMetadataDotPropertiesDir == null && checkstyleMetadataDotXmlDir == null && messagesDotPropertiesDir == null) {
            rootDoc.printWarning("None of \"-d\", \"-checkstyle-metadata.properties-dir\", \"-checkstyle-metadata.xml-dir\" and \"-messages.properties-dir\" specified - nothing to be done.");
        }
        final ClassDoc[] checkClasses = CsDoclet.getCheckClasses(rootDoc);
        final ClassDoc[] filterClasses = CsDoclet.getFilterClasses(rootDoc);
        final ClassDoc[] quickfixClasses = CsDoclet.getQuickfixClasses(rootDoc);
        Html html = new Html((Html.LinkMaker)new Html.ExternalJavadocsLinkMaker(externalJavadocs, new Html.LinkMaker(){

            public Html.Link makeLink(Doc from, Doc to, RootDoc rootDoc) {
                ClassDoc cd;
                String href = !(to instanceof ClassDoc) ? null : (CsDoclet.isSubclassOfAnyOf(cd = (ClassDoc)to, checkClasses) ? "checks/" + cd.simpleTypeName() + ".html" : (CsDoclet.isSubclassOfAnyOf(cd, filterClasses) ? "filters/" + cd.simpleTypeName() + ".html" : (CsDoclet.isSubclassOfAnyOf(cd, quickfixClasses) ? "quickfixes/" + cd.simpleTypeName() + ".html" : null)));
                if (href != null && from instanceof ClassDoc) {
                    href = "../" + href;
                }
                return new Html.Link(href, to.name());
            }
        }));
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        HashMap<String, Quickfix> allQuickfixes = new HashMap<String, Quickfix>();
        TreeSet<OptionProvider> allOptionProviders = new TreeSet<OptionProvider>(new Comparator<OptionProvider>(){

            @Override
            public int compare(@Nullable OptionProvider op1, @Nullable OptionProvider op2) {
                return op1.className().compareTo(op2.className());
            }
        });
        for (PackageDoc pd : rootDoc.specifiedPackages()) {
            String checkstylePackage = pd.name();
            TreeMap<String, ClassDoc> classDocs = new TreeMap<String, ClassDoc>();
            for (ClassDoc classDoc : rootDoc.classes()) {
                String packageName = classDoc.containingPackage().name();
                if (!packageName.equals(checkstylePackage)) continue;
                classDocs.put(classDoc.name(), classDoc);
            }
            Collection<Rule> rulesInPackage = CsDoclet.rules(classDocs.values(), rootDoc, allQuickfixes, (Consumer<? super OptionProvider>)ConsumerUtil.addToCollection(allOptionProviders), html);
            if (!rulesInPackage.isEmpty()) {
                allRules.addAll(rulesInPackage);
                if (checkstyleMetadataDotPropertiesDir != null) {
                    CsDoclet.printToFile(new File(new File(checkstyleMetadataDotPropertiesDir, checkstylePackage.replace('.', File.separatorChar)), "checkstyle-metadata.properties"), Charset.forName("ISO-8859-1"), pw -> CheckstyleMetadataDotPropertiesGenerator.generate(rulesInPackage, pw, rootDoc));
                }
                if (checkstyleMetadataDotPropertiesDir != null) {
                    CsDoclet.printToFile(new File(new File(checkstyleMetadataDotPropertiesDir, checkstylePackage.replace('.', File.separatorChar)), "checkstyle-metadata.xml"), Charset.forName("UTF-8"), pw -> CheckstyleMetadataDotXmlGenerator.generate(rulesInPackage, pw, rootDoc));
                }
                if (messagesDotPropertiesDir != null) {
                    CsDoclet.printToFile(new File(new File(messagesDotPropertiesDir, checkstylePackage.replace('.', File.separatorChar)), "messages.properties"), Charset.forName("ISO-8859-1"), pw -> MessagesDotPropertiesGenerator.generate(rulesInPackage, pw, rootDoc));
                }
            }
            for (Quickfix qf : CsDoclet.quickfixes(classDocs.values(), allRules, rootDoc, html)) {
                allQuickfixes.put(qf.className(), qf);
            }
        }
        if (generateHtml) {
            ArrayList<Quickfix> qfs = new ArrayList<Quickfix>(allQuickfixes.values());
            qfs.sort(new Comparator<Quickfix>(){

                @Override
                @NotNullByDefault(value=false)
                public int compare(Quickfix qf1, Quickfix qf2) {
                    return Comparators.compareNullSafe((Comparable)((Object)qf1.label()), (Comparable)((Object)qf2.label()));
                }
            });
            CsDoclet.generateHtml(allRules, qfs, allOptionProviders, options, rootDoc, html);
        }
        return true;
    }

    protected static boolean isSubclassOfAnyOf(ClassDoc subject, ClassDoc[] baseClasses) {
        for (ClassDoc bc : baseClasses) {
            if (!Docs.isSubclassOf((ClassDoc)subject, (ClassDoc)bc)) continue;
            return true;
        }
        return false;
    }

    private static void generateHtml(Collection<Rule> allRules, Collection<Quickfix> allQuickfixes, Collection<OptionProvider> allOptionProviders, Options options, RootDoc rootDoc, Html html) throws IOException {
        String resourceNamePrefix = "de/unkrig/doclet/cs/html/templates/";
        for (String resourceNameSuffix : new String[]{"stylesheet.css", "stylesheet2.css"}) {
            IoUtil.copyResource((ClassLoader)CsDoclet.class.getClassLoader(), (String)(resourceNamePrefix + resourceNameSuffix), (File)new File(options.destination, resourceNameSuffix), (boolean)true);
        }
        ArrayList indexEntries = new ArrayList();
        Consumer indexEntryConsumer = ConsumerUtil.addToCollection(indexEntries);
        NoTemplate.render(IndexHtml.class, (File)new File(options.destination, "index.html"), indexHtml -> indexHtml.render(options));
        for (ElementWithContext rule : IterableUtil.iterableWithContext(allRules)) {
            NoTemplate.render(RuleDetailHtml.class, (File)new File(options.destination, ((Rule)rule.current()).familyPlural() + '/' + ((ClassDoc)((Rule)rule.current()).ref()).simpleTypeName() + ".html"), ruleHtml -> ruleHtml.render((ElementWithContext<Rule>)rule, html, rootDoc, options, (Consumer<? super IndexPages.IndexEntry>)indexEntryConsumer));
        }
        for (ElementWithContext quickfix : IterableUtil.iterableWithContext(allQuickfixes)) {
            NoTemplate.render(QuickfixDetailHtml.class, (File)new File(options.destination, "quickfixes/" + ((ClassDoc)((Quickfix)quickfix.current()).ref()).simpleTypeName() + ".html"), quickfixHtml -> quickfixHtml.render((ElementWithContext<Quickfix>)quickfix, html, rootDoc, options, (Consumer<? super IndexPages.IndexEntry>)indexEntryConsumer));
        }
        for (ElementWithContext optionProvider : IterableUtil.iterableWithContext(allOptionProviders)) {
            NoTemplate.render(OptionProviderDetailHtml.class, (File)new File(options.destination, "option-providers/" + ((OptionProvider)optionProvider.current()).className() + ".html"), optionProviderHtml -> optionProviderHtml.render((ElementWithContext<OptionProvider>)optionProvider, html, rootDoc, options, (Consumer<? super IndexPages.IndexEntry>)indexEntryConsumer));
        }
        NoTemplate.render(AllRulesFrameHtml.class, (File)new File(options.destination, "allrules-frame.html"), allRulesFrameHtml -> allRulesFrameHtml.render(allRules, allQuickfixes, rootDoc, options, html));
        NoTemplate.render(OverviewSummaryHtml.class, (File)new File(options.destination, "overview-summary.html"), overviewSummaryHtml -> overviewSummaryHtml.render(allRules, allQuickfixes, rootDoc, options, html));
        IndexPages.createIndex((File)options.destination, indexEntries, (Options)options, (String[])new String[]{"Overview", "overview-summary.html", "Rule", AbstractRightFrameHtml.DISABLED, "Deprecated", "deprecated-list.html", "Index", AbstractRightFrameHtml.HIGHLIT, "Help", "help-doc.html"});
    }

    public static <EX extends Throwable> void printToFile(File file, Charset charset, ConsumerWhichThrows<? super PrintWriter, EX> printer) throws IOException, EX {
        File directory = file.getParentFile();
        directory.mkdirs();
        File newFile = new File(directory, "." + file.getName() + ".new");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), charset));
        try {
            printer.consume((Object)pw);
            pw.close();
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete existing file '" + file + "'");
            }
            if (!newFile.renameTo(file)) {
                throw new IOException("Could not rename '" + newFile + "' to '" + file + "'");
            }
        }
        catch (RuntimeException re) {
            try {
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFile.delete();
            throw re;
        }
        catch (Error e) {
            try {
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFile.delete();
            throw e;
        }
        catch (Throwable t) {
            try {
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            newFile.delete();
            Throwable tmp = t;
            throw tmp;
        }
    }

    public static String htmlToPlainText(String s, SourcePosition position, RootDoc rootDoc) {
        Matcher matcher;
        while ((matcher = CODE_BLOCK.matcher(s)).find()) {
            s = matcher.group(1) + matcher.group(2) + s.substring(matcher.end());
        }
        matcher = CONTAINS_HTML_MARKUP.matcher(s);
        if (matcher.find()) {
            rootDoc.printWarning(position, "'" + matcher.group() + "' cannot be reasonably converted to plain text");
        }
        return s;
    }

    public static Type guessDatatype(MethodDoc methodDoc, RootDoc rootDoc) throws Longjump {
        Parameter[] parameters = methodDoc.parameters();
        if (parameters.length != 1) {
            rootDoc.printError(methodDoc.position(), "Cannot guess the property type because the number of parameters is not one");
            throw new Longjump();
        }
        return parameters[0].type();
    }

    public static Collection<Rule> rules(Collection<ClassDoc> classDocs, RootDoc rootDoc, Map<String, Quickfix> allQuickfixes, Consumer<? super OptionProvider> usedOptionProviders, Html html) {
        ClassDoc[] checkClasses = CsDoclet.getCheckClasses(rootDoc);
        ClassDoc[] filterClasses = CsDoclet.getFilterClasses(rootDoc);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (ClassDoc classDoc : classDocs) {
            String familyPlural;
            String familySingular;
            AnnotationDesc ra = Annotations.get((ProgramElementDoc)classDoc, (String)"Rule");
            if (ra == null) continue;
            if (CsDoclet.isSubclassOfAnyOf(classDoc, checkClasses)) {
                familySingular = "check";
                familyPlural = "checks";
            } else if (CsDoclet.isSubclassOfAnyOf(classDoc, filterClasses)) {
                familySingular = "filter";
                familyPlural = "filters";
            } else {
                rootDoc.printError(classDoc.position(), "Rule \"" + classDoc.qualifiedTypeName() + "\" cannot be identified as a check or a filter");
                continue;
            }
            try {
                rules.add(CsDoclet.rule(ra, classDoc, rootDoc, familySingular, familyPlural, allQuickfixes, usedOptionProviders, html));
            }
            catch (Longjump longjump) {}
        }
        return rules;
    }

    private static ClassDoc[] getCheckClasses(RootDoc rootDoc) {
        return CsDoclet.classesNamed(rootDoc, "com.puppycrawl.tools.checkstyle.api.AbstractCheck", "com.puppycrawl.tools.checkstyle.api.Check");
    }

    private static ClassDoc[] getFilterClasses(RootDoc rootDoc) {
        return CsDoclet.classesNamed(rootDoc, "com.puppycrawl.tools.checkstyle.TreeWalkerFilter", "com.puppycrawl.tools.checkstyle.api.Filter");
    }

    private static ClassDoc[] getQuickfixClasses(RootDoc rootDoc) {
        return CsDoclet.classesNamed(rootDoc, "net.sf.eclipsecs.ui.quickfixes.ICheckstyleMarkerResolution");
    }

    private static ClassDoc getIOptionProviderClass(RootDoc rootDoc) throws Longjump {
        return Docs.classNamed((RootDoc)rootDoc, (String)"net.sf.eclipsecs.core.config.meta.IOptionProvider");
    }

    private static ClassDoc[] classesNamed(RootDoc rootDoc, String ... classNames) {
        ArrayList<ClassDoc> result = new ArrayList<ClassDoc>();
        for (String cn : classNames) {
            ClassDoc cd = rootDoc.classNamed(cn);
            if (cd == null) continue;
            result.add(cd);
        }
        return result.toArray(new ClassDoc[result.size()]);
    }

    public static Collection<Quickfix> quickfixes(Collection<ClassDoc> classDocs, final Collection<Rule> allRules, RootDoc rootDoc, Html html) {
        ClassDoc[] quickfixInterfaces = CsDoclet.getQuickfixClasses(rootDoc);
        ArrayList<Quickfix> quickfixes = new ArrayList<Quickfix>();
        for (final ClassDoc classDoc : classDocs) {
            if (!CsDoclet.isSubclassOfAnyOf(classDoc, quickfixInterfaces) || classDoc.isAbstract()) continue;
            try {
                String s = html.optionalTag((Doc)classDoc, "@cs-label", rootDoc);
                final String className = classDoc.qualifiedTypeName();
                final String quickfixLabel = s != null ? s : classDoc.qualifiedTypeName();
                final String simpleName = classDoc.simpleTypeName();
                final String quickfixShortDescription = html.fromTags(classDoc.firstSentenceTags(), (Doc)classDoc, rootDoc);
                final String quickfixLongDescription = html.fromTags(classDoc.inlineTags(), (Doc)classDoc, rootDoc);
                quickfixes.add(new Quickfix(){

                    @Override
                    public Doc ref() {
                        return classDoc;
                    }

                    @Override
                    @Nullable
                    public String className() {
                        return className;
                    }

                    @Override
                    public String label() {
                        return quickfixLabel;
                    }

                    @Override
                    public String simpleName() {
                        return simpleName;
                    }

                    @Override
                    public String shortDescription() {
                        return quickfixShortDescription;
                    }

                    @Override
                    public String longDescription() {
                        return quickfixLongDescription;
                    }

                    @Override
                    @Nullable
                    public Rule[] rules() {
                        ArrayList<Rule> tmp = new ArrayList<Rule>();
                        for (Rule rule : allRules) {
                            Quickfix[] qfs = rule.quickfixes();
                            if (qfs == null || !CsDoclet.arrayContains(qfs, this)) continue;
                            tmp.add(rule);
                        }
                        return tmp.toArray(new Rule[tmp.size()]);
                    }
                });
            }
            catch (Longjump longjump) {}
        }
        return quickfixes;
    }

    public static <T> boolean arrayContains(T[] haystack, T needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!ObjectUtil.equals(haystack[i], needle)) continue;
            return true;
        }
        return false;
    }

    private static Rule rule(AnnotationDesc ruleAnnotation, final ClassDoc classDoc, final RootDoc rootDoc, final String familySingular, final String familyPlural, final Map<String, Quickfix> allQuickfixes, Consumer<? super OptionProvider> usedOptionProviders, Html html) throws Longjump {
        final String group = (String)Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"group", String.class);
        final String groupName = (String)Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"groupName", String.class);
        final String simpleName = classDoc.simpleTypeName();
        final String name = (String)Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"name", String.class);
        final String internalName = classDoc.qualifiedTypeName();
        final String parent = (String)Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"parent", String.class);
        final String shortDescription = html.fromTags(classDoc.firstSentenceTags(), (Doc)classDoc, rootDoc);
        final String longDescription = html.fromTags(classDoc.inlineTags(), (Doc)classDoc, rootDoc);
        final String[] quickfixClassNames = (String[])Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"quickfixes", String[].class);
        final Boolean hasSeverity = (Boolean)Annotations.getElementValue((AnnotationDesc)ruleAnnotation, (String)"hasSeverity", Boolean.class);
        assert (group != null);
        assert (groupName != null);
        assert (name != null);
        assert (parent != null);
        final Collection<RuleProperty> properties = CsDoclet.properties(classDoc, rootDoc, html, usedOptionProviders);
        final TreeMap<String, String> messages = new TreeMap<String, String>();
        for (ClassDoc cd = classDoc; cd != null; cd = cd.superclass()) {
            for (FieldDoc fd : cd.fields(false)) {
                AnnotationDesc a = Annotations.get((ProgramElementDoc)fd, (String)"Message");
                if (a == null) continue;
                Object o = fd.constantValue();
                if (o == null) {
                    rootDoc.printError(fd.position(), "Field '" + fd.name() + "' has a '@Message' annotation, but not a constant value");
                    continue;
                }
                if (!(o instanceof String)) {
                    rootDoc.printError(fd.position(), "Constant '" + fd.name() + "' must have type 'String'");
                    continue;
                }
                String messageKey = (String)o;
                String message = (String)Annotations.getElementValue((AnnotationDesc)a, (String)"value", String.class);
                if (message == null) {
                    rootDoc.printError(fd.position(), "Message lacks a default text");
                    continue;
                }
                String orig = messages.put(messageKey, message);
                if (orig == null || message.equals(orig)) continue;
                rootDoc.printError(fd.position(), "Inconsistent redefinition of message \"" + messageKey + "\": Previously \"" + orig + "\", now \"" + message + "\"");
            }
        }
        return new Rule(){

            @Override
            public Doc ref() {
                return classDoc;
            }

            @Override
            public String familySingular() {
                return familySingular;
            }

            @Override
            public String familyPlural() {
                return familyPlural;
            }

            @Override
            public String group() {
                return group;
            }

            @Override
            public String groupName() {
                return groupName;
            }

            @Override
            public String simpleName() {
                return simpleName;
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public String internalName() {
                return internalName;
            }

            @Override
            public String parent() {
                return parent;
            }

            @Override
            public String shortDescription() {
                return shortDescription;
            }

            @Override
            public String longDescription() {
                return longDescription;
            }

            @Override
            public Collection<RuleProperty> properties() {
                return properties;
            }

            @Override
            @Nullable
            public Boolean hasSeverity() {
                return hasSeverity;
            }

            @Override
            public SortedMap<String, String> messages() {
                return messages;
            }

            @Override
            @Nullable
            public Quickfix[] quickfixes() {
                if (quickfixClassNames == null) {
                    return null;
                }
                ArrayList<Quickfix> tmp = new ArrayList<Quickfix>();
                for (String qfcn : quickfixClassNames) {
                    Quickfix qf = (Quickfix)allQuickfixes.get(qfcn);
                    if (qf == null) {
                        rootDoc.printWarning(familySingular + " \"" + name + "\" refers to no-existent quickfix class \"" + qfcn + "\"");
                    }
                    tmp.add(qf);
                }
                return tmp.toArray(new Quickfix[tmp.size()]);
            }
        };
    }

    public static Collection<RuleProperty> properties(ClassDoc classDoc, RootDoc rootDoc, Html html, Consumer<? super OptionProvider> usedOptionProviders) throws Longjump {
        ArrayList<RuleProperty> properties = new ArrayList<RuleProperty>();
        for (MethodDoc methodDoc : classDoc.methods(false)) {
            AnnotationDesc rpa = null;
            SourcePosition pos = methodDoc.position();
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, BooleanRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, FileRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, HiddenRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, IntegerRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, MultiCheckRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, RegexRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, SingleSelectRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc);
            if ((rpa = CsDoclet.xor(rpa, Annotations.get((ProgramElementDoc)methodDoc, StringRuleProperty.class, (RootDoc)rootDoc), pos, (DocErrorReporter)rootDoc)) == null) continue;
            try {
                properties.add(CsDoclet.property(methodDoc, rpa, rootDoc, usedOptionProviders, html));
            }
            catch (Longjump longjump) {
                // empty catch block
            }
        }
        return properties;
    }

    private static RuleProperty property(final MethodDoc methodDoc, AnnotationDesc rpa, final RootDoc rootDoc, Consumer<? super OptionProvider> usedOptionProvider, final Html html) throws Longjump {
        OptionProvider optionProvider;
        String atsn = rpa.annotationType().simpleTypeName();
        int idx = atsn.indexOf("RuleProperty");
        assert (idx != -1) : atsn;
        final RuleProperty.Datatype datatype = RuleProperty.Datatype.valueOf(Notations.fromCamelCase((String)atsn.substring(0, idx)).toUpperCaseUnderscored());
        String n = (String)Annotations.getElementValue((AnnotationDesc)rpa, (String)"name", String.class);
        if (n == null) {
            String methodName = methodDoc.name();
            if (!SETTER.matcher(methodName).matches()) {
                rootDoc.printError(methodDoc.position(), "Cannot determine property name");
                throw new Longjump();
            }
            n = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        final String propertyName = n;
        final String ruleShortDescription = html.fromTags(methodDoc.firstSentenceTags(), (Doc)methodDoc, rootDoc);
        final String ruleLongDescription = html.fromTags(methodDoc.inlineTags(), (Doc)methodDoc, rootDoc);
        Type tmp = (Type)Annotations.getElementValue((AnnotationDesc)rpa, (String)"optionProvider", Type.class);
        final ClassDoc opc = tmp == null ? null : tmp.asClassDoc();
        String[] valueOptions = (String[])Annotations.getElementValue((AnnotationDesc)rpa, (String)"valueOptions", String[].class);
        if (opc == null) {
            if (valueOptions == null) {
                optionProvider = null;
            } else {
                ArrayList<6> tmp2 = new ArrayList<6>();
                for (final String ev : valueOptions) {
                    tmp2.add(new ValueOption(){

                        @Override
                        public String name() {
                            return ev;
                        }

                        @Override
                        @Nullable
                        public String shortDescription() {
                            return null;
                        }

                        @Override
                        @Nullable
                        public String longDescription() {
                            return null;
                        }
                    });
                }
                final ValueOption[] valueOptions2 = tmp2.toArray(new ValueOption[tmp2.size()]);
                optionProvider = new OptionProvider(){

                    @Override
                    @Nullable
                    public String name() {
                        return null;
                    }

                    @Override
                    @Nullable
                    public String className() {
                        return null;
                    }

                    @Override
                    public ValueOption[] valueOptions() {
                        return valueOptions2;
                    }

                    @Override
                    @Nullable
                    public String shortDescription() {
                        return null;
                    }

                    @Override
                    @Nullable
                    public String longDescription() {
                        return null;
                    }
                };
            }
        } else {
            ValueOption[] valueOptions2;
            final String optionProviderShortDescription = html.fromTags(opc.firstSentenceTags(), (Doc)opc, rootDoc);
            final String optionProviderLongDescription = html.fromTags(opc.inlineTags(), (Doc)opc, rootDoc);
            if (opc.isEnum()) {
                ArrayList<8> tmp2 = new ArrayList<8>();
                for (final FieldDoc fieldDoc : opc.enumConstants()) {
                    final String valueOptionShortDescription = html.fromTags(fieldDoc.firstSentenceTags(), (Doc)rootDoc, rootDoc);
                    final String valueOptionLongDescription = html.fromTags(fieldDoc.inlineTags(), (Doc)rootDoc, rootDoc);
                    tmp2.add(new ValueOption(){

                        @Override
                        public String name() {
                            return fieldDoc.name().toLowerCase();
                        }

                        @Override
                        public String shortDescription() {
                            return valueOptionShortDescription;
                        }

                        @Override
                        public String longDescription() {
                            return valueOptionLongDescription;
                        }
                    });
                }
                valueOptions2 = tmp2.toArray(new ValueOption[0]);
            } else if (opc.subclassOf(CsDoclet.getIOptionProviderClass(rootDoc))) {
                ArrayList<9> tmp2;
                ArrayList<9> tmp3;
                Class opc2 = Types.loadType((SourcePosition)methodDoc.position(), (Type)opc, (DocErrorReporter)rootDoc);
                try {
                    tmp2 = tmp3 = (ArrayList<9>)opc2.getDeclaredMethod("getOptions", new Class[0]).invoke(opc2.newInstance(), new Object[0]);
                }
                catch (Exception e) {
                    rootDoc.printError(methodDoc.position(), e.getMessage());
                    throw new Longjump();
                }
                tmp3 = new ArrayList<9>();
                for (final String string : tmp2) {
                    tmp3.add(new ValueOption(){

                        @Override
                        public String name() {
                            return string;
                        }

                        @Override
                        @Nullable
                        public String shortDescription() {
                            return null;
                        }

                        @Override
                        @Nullable
                        public String longDescription() {
                            return null;
                        }
                    });
                }
                valueOptions2 = tmp3.toArray(new ValueOption[0]);
            } else {
                rootDoc.printError(methodDoc.position(), "Option provider class '" + opc + "' must either extend 'Enum' or implement \"net.sf.eclipsecs.core.config.meta.IOptionProvider\"");
                throw new Longjump();
            }
            ClassDoc containingClass = opc.containingClass();
            final String qualifiedClassName = containingClass == null ? opc.qualifiedName() : opc.containingPackage().name() + '.' + opc.name().replace('.', '$');
            optionProvider = new OptionProvider(){

                @Override
                public String name() {
                    String result;
                    try {
                        result = html.optionalTag((Doc)opc, "@cs-name", rootDoc);
                    }
                    catch (Longjump e) {
                        result = "???";
                    }
                    if (result == null) {
                        result = opc.qualifiedName();
                    }
                    return result;
                }

                @Override
                public String className() {
                    return qualifiedClassName;
                }

                @Override
                public String shortDescription() {
                    return optionProviderShortDescription;
                }

                @Override
                public String longDescription() {
                    return optionProviderLongDescription;
                }

                @Override
                public ValueOption[] valueOptions() {
                    return valueOptions2;
                }
            };
            usedOptionProvider.consume((Object)optionProvider);
        }
        final Object defaultValue = Annotations.getElementValue((AnnotationDesc)rpa, (String)"defaultValue", String.class);
        final String overrideDefaultValue = (String)Annotations.getElementValue((AnnotationDesc)rpa, (String)"overrideDefaultValue", String.class);
        return new RuleProperty(){

            @Override
            public Doc ref() {
                return methodDoc;
            }

            @Override
            public String name() {
                return propertyName;
            }

            @Override
            public String shortDescription() {
                return ruleShortDescription;
            }

            @Override
            public String longDescription() {
                return ruleLongDescription;
            }

            @Override
            public RuleProperty.Datatype datatype() {
                return datatype;
            }

            @Override
            @Nullable
            public OptionProvider optionProvider() {
                return optionProvider;
            }

            @Override
            @Nullable
            public Object defaultValue() {
                return defaultValue;
            }

            @Override
            @Nullable
            public Object overrideDefaultValue() {
                return overrideDefaultValue;
            }
        };
    }

    @Nullable
    private static AnnotationDesc xor(@Nullable AnnotationDesc rpa1, @Nullable AnnotationDesc rpa2, SourcePosition position, DocErrorReporter errorReporter) {
        if (rpa1 == null) {
            return rpa2;
        }
        if (rpa2 == null) {
            return rpa1;
        }
        errorReporter.printError(position, "\"" + rpa1 + "\" and \"" + rpa2 + "\" are mutually exclusive");
        return rpa1;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        SETTER = Pattern.compile("set[A-Z].*");
        CONTAINS_HTML_MARKUP = Pattern.compile("<\\s*\\w.*>", 2);
        CODE_BLOCK = Pattern.compile("(.*)<code>(.*?)</code>", 2);
    }

    public static interface ValueOption {
        public String name();

        @Nullable
        public String shortDescription();

        @Nullable
        public String longDescription();
    }

    public static interface OptionProvider {
        @Nullable
        public String name();

        @Nullable
        public String className();

        @Nullable
        public String shortDescription();

        @Nullable
        public String longDescription();

        public ValueOption[] valueOptions();
    }

    public static interface Quickfix {
        public Doc ref();

        @Nullable
        public String className();

        public String label();

        public String simpleName();

        public String shortDescription();

        public String longDescription();

        @Nullable
        public Rule[] rules();
    }

    public static interface RuleProperty {
        public Doc ref();

        public String name();

        public String shortDescription();

        public String longDescription();

        public Datatype datatype();

        @Nullable
        public OptionProvider optionProvider();

        @Nullable
        public Object defaultValue();

        @Nullable
        public Object overrideDefaultValue();

        public static enum Datatype {
            BOOLEAN,
            FILE,
            HIDDEN,
            INTEGER,
            MULTI_CHECK,
            REGEX,
            SINGLE_SELECT,
            STRING;

        }
    }

    public static interface Rule {
        public Doc ref();

        public String familySingular();

        public String familyPlural();

        public String group();

        public String groupName();

        public String name();

        public String internalName();

        public String simpleName();

        public String parent();

        public String shortDescription();

        public String longDescription();

        public Collection<RuleProperty> properties();

        @Nullable
        public Quickfix[] quickfixes();

        @Nullable
        public Boolean hasSeverity();

        public SortedMap<String, String> messages();
    }
}

