/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.cs;

import com.sun.javadoc.RootDoc;
import de.unkrig.commons.text.Notations;
import de.unkrig.doclet.cs.CsDoclet;
import java.io.PrintWriter;
import java.util.Collection;

public final class CheckstyleMetadataDotXmlGenerator {
    private CheckstyleMetadataDotXmlGenerator() {
    }

    public static void generate(Collection<CsDoclet.Rule> rules, PrintWriter pw, RootDoc rootDoc) {
        pw.printf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n<!DOCTYPE checkstyle-metadata PUBLIC%n\"-//eclipse-cs//DTD Check Metadata 1.1//EN\"%n\"http://eclipse-cs.sourceforge.net/dtds/checkstyle-metadata_1_1.dtd\">%n<checkstyle-metadata>%n%n    <!-- This file was generated by the CheckStyle doclet; see http://cs-doclet.unkrig.de -->%n", new Object[0]);
        for (CsDoclet.Rule rule : rules) {
            pw.printf("%n    <!-- %1$s -->%n%n    <rule-group-metadata name=\"%3$s\" priority=\"999\">%n        <rule-metadata%n            internal-name=\"%2$s\"%n            parent=\"%4$s\"%n" + (rule.hasSeverity() == null ? "" : "            hasSeverity=\"%5$s\"%n") + "            name=\"%%%1$s.name\"%n        >%n            <alternative-name internal-name=\"%2$s\" />%n            <description>%%%1$s.desc</description>%n", rule.simpleName(), rule.internalName(), rule.group(), rule.parent(), rule.hasSeverity());
            boolean isFirstProperty = true;
            for (CsDoclet.RuleProperty property : rule.properties()) {
                if (isFirstProperty) {
                    pw.printf("%n", new Object[0]);
                    isFirstProperty = false;
                }
                pw.printf("            <property-metadata%n                name=\"%2$s\"%n                datatype=\"%3$s\"%n" + (property.defaultValue() == null ? "" : "                default-value=\"%4$s\"%n") + (property.overrideDefaultValue() == null ? "" : "                override-default-value=\"%5$s\"%n") + "            >%n                <description>%%%1$s.%2$s</description>%n", rule.simpleName(), property.name(), Notations.fromUnderscored((String)property.datatype().toString()).toUpperCamelCase(), property.defaultValue(), property.overrideDefaultValue());
                CsDoclet.OptionProvider optionProvider = property.optionProvider();
                if (optionProvider != null) {
                    if (optionProvider.className() != null) {
                        pw.printf("                <enumeration option-provider=\"%s\" />%n", optionProvider.className());
                    } else {
                        CsDoclet.ValueOption[] valueOptions = optionProvider.valueOptions();
                        pw.printf("                <enumeration>%n", new Object[0]);
                        for (CsDoclet.ValueOption valueOption : valueOptions) {
                            pw.printf("                    <property-value-option value=\"%s\" />%n", valueOption.name());
                        }
                        pw.printf("                </enumeration>%n", new Object[0]);
                    }
                }
                pw.printf("            </property-metadata>%n", new Object[0]);
            }
            CsDoclet.Quickfix[] qfs = rule.quickfixes();
            if (qfs != null && qfs.length > 0) {
                pw.printf("%n", new Object[0]);
                for (CsDoclet.Quickfix qf : qfs) {
                    pw.printf("            <quickfix classname=\"%s\" />%n", qf.className());
                }
            }
            for (String messageKey : rule.messages().keySet()) {
                pw.printf("            <message-key key=\"%s\" />%n", messageKey);
            }
            pw.printf("        </rule-metadata>%n    </rule-group-metadata>%n", new Object[0]);
        }
        pw.printf("</checkstyle-metadata>%n", new Object[0]);
    }
}

