/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.cs.html.templates;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.RootDoc;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.doclet.cs.CsDoclet;
import de.unkrig.notemplate.javadocish.Options;
import de.unkrig.notemplate.javadocish.templates.AbstractRightFrameHtml;
import de.unkrig.notemplate.javadocish.templates.AbstractSummaryHtml;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class OverviewSummaryHtml
extends AbstractSummaryHtml {
    /*
     * WARNING - void declaration
     */
    public void render(Collection<CsDoclet.Rule> rules, Collection<CsDoclet.Quickfix> quickfixes, RootDoc rootDoc, Options options, Html html) {
        String overviewFirstSentenceHtml = (String)AssertionUtil.notNull((Object)Longjump.catchLongjump(() -> html.fromTags(rootDoc.firstSentenceTags(), (Doc)rootDoc, rootDoc), (Object)""));
        String overviewHtml = (String)AssertionUtil.notNull((Object)Longjump.catchLongjump(() -> html.fromTags(rootDoc.inlineTags(), (Doc)rootDoc, rootDoc), (Object)""));
        TreeMap<String, TreeSet<CsDoclet.Rule>> rulesByFamily = new TreeMap<String, TreeSet<CsDoclet.Rule>>();
        for (CsDoclet.Rule rule : rules) {
            void var11_13;
            Collection collection = (Collection)rulesByFamily.get(rule.familyPlural());
            if (collection == null) {
                TreeSet<CsDoclet.Rule> treeSet = new TreeSet<CsDoclet.Rule>(new Comparator<CsDoclet.Rule>(){

                    @Override
                    public int compare(@Nullable CsDoclet.Rule r1, @Nullable CsDoclet.Rule r2) {
                        assert (r1 != null);
                        assert (r2 != null);
                        return r1.name().compareTo(r2.name());
                    }
                });
                rulesByFamily.put(rule.familyPlural(), treeSet);
            }
            var11_13.add(rule);
        }
        ArrayList<AbstractSummaryHtml.Section> sections = new ArrayList<AbstractSummaryHtml.Section>();
        for (Map.Entry entry : rulesByFamily.entrySet()) {
            String familyPlural = (String)entry.getKey();
            Collection rulesOfFamily = (Collection)entry.getValue();
            AbstractSummaryHtml.Section section = new AbstractSummaryHtml.Section(familyPlural, StringUtil.firstLetterToUpperCase((String)familyPlural), familyPlural, "Name");
            for (CsDoclet.Rule rule : rulesOfFamily) {
                section.items.add(new AbstractSummaryHtml.SectionItem(familyPlural + '/' + ((ClassDoc)rule.ref()).simpleTypeName() + ".html", rule.name(), rule.shortDescription()));
            }
            sections.add(section);
        }
        AbstractSummaryHtml.Section section = new AbstractSummaryHtml.Section("quickfixes", "Quickfixes", "Quickfixes for the checks.", "Name");
        for (CsDoclet.Quickfix quickfix : quickfixes) {
            section.items.add(new AbstractSummaryHtml.SectionItem("quickfixes/" + quickfix.label() + ".html", quickfix.label(), quickfix.shortDescription()));
        }
        sections.add(section);
        this.rSummary("Overview", options, new String[]{"stylesheet.css"}, new String[]{"Overview", AbstractRightFrameHtml.HIGHLIT, "Check", AbstractRightFrameHtml.DISABLED, "Deprecated", "deprecated-list.html", "Index", options.splitIndex ? "index-files/index-1.html" : "index-all.html", "Help", "help-doc.html"}, new String[]{"Prev", "Next"}, new String[]{"Frames", "index.html?overview-summary.html", "No Frames", "overview-summary.html"}, new String[]{"All Rules", "allclasses-noframe.html"}, new Runnable[]{options.docTitle == null ? null : () -> this.l("      <h1 class=\"title\">" + options.docTitle + "</h1>"), overviewFirstSentenceHtml.isEmpty() ? null : () -> {
            this.l(new String[]{"      <div class=\"docSummary\">", "        <div class=\"subTitle\">", "          <div class=\"block\">" + overviewFirstSentenceHtml + "</div>", "        </div>"});
            if (!overviewHtml.isEmpty()) {
                this.l("        <p>See: <a href=\"#description\">Description</a></p>");
            }
            this.l("      </div>");
        }}, () -> {
            this.l("      <a name=\"description\" />");
            if (!overviewHtml.isEmpty()) {
                this.l("      " + overviewHtml);
            }
        }, sections);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

