/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.cs;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.RootDoc;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.doclet.cs.CsDoclet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public final class CheckstyleMetadataDotPropertiesGenerator {
    private static Html html = new Html(Html.STANDARD_LINK_MAKER);

    private CheckstyleMetadataDotPropertiesGenerator() {
    }

    public static void generate(Collection<CsDoclet.Rule> rules, PrintWriter pw, RootDoc rootDoc) {
        pw.printf("%n# This file was generated by the CS doclet; see http://cs-contrib.unkrig.de.%n%n# Rule groups:%n", new Object[0]);
        TreeMap<String, String> groups = new TreeMap<String, String>();
        for (CsDoclet.Rule rule : rules) {
            String ruleGroup = rule.group();
            if (!ruleGroup.startsWith("%")) continue;
            String ruleGroupName = rule.groupName();
            String originalRuleGroupName = groups.put(ruleGroup = ruleGroup.substring(1), ruleGroupName);
            if (originalRuleGroupName == null || originalRuleGroupName.equals(ruleGroupName)) continue;
            rootDoc.printError(rule.ref().position(), "Non-equal redefinition of name of group '" + ruleGroup + "': Previously '" + originalRuleGroupName + "', now '" + ruleGroupName + "'");
        }
        for (Map.Entry entry : groups.entrySet()) {
            pw.printf("%-16s = %s%n", entry.getKey(), entry.getValue());
        }
        pw.printf("%n# Custom checks, in alphabetical order.%n", new Object[0]);
        for (CsDoclet.Rule rule : rules) {
            try {
                pw.printf("%n# --------------- %2$s ---------------%n%n%1$s.name = %2$s%n%1$s.desc =\\%n", rule.simpleName(), rule.name());
                String description = rule.longDescription();
                ClassDoc[] quickfixClasses = rule.quickfixClasses();
                if (quickfixClasses != null && quickfixClasses.length > 0) {
                    description = String.valueOf(description) + String.format("%n%n<h4>Quickfixes:</h4>%n<dl>%n", new Object[0]);
                    ClassDoc[] classDocArray = quickfixClasses;
                    int n = quickfixClasses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ClassDoc quickfixClass = classDocArray[n2];
                        String quickfixLabel = html.optionalTag((Doc)quickfixClass, "@cs-label", rootDoc);
                        if (quickfixLabel == null) {
                            quickfixLabel = quickfixClass.qualifiedTypeName();
                        }
                        String quickfixShortDescription = html.fromTags(quickfixClass.firstSentenceTags(), (Doc)quickfixClass, rootDoc);
                        description = String.valueOf(description) + String.format("  <dt>%1$s%n  <dd>%2$s%n", quickfixLabel, quickfixShortDescription);
                        ++n2;
                    }
                    description = String.valueOf(description) + String.format("</dl>", new Object[0]);
                }
                CheckstyleMetadataDotPropertiesGenerator.printPropertyValue(description, pw);
                for (CsDoclet.RuleProperty property : rule.properties()) {
                    String shortDescription = CsDoclet.htmlToPlainText(property.shortDescription(), property.ref().position(), rootDoc);
                    shortDescription = shortDescription.replaceAll("\\s+", " ");
                    pw.printf("%1$-40s = %2$s%n", String.valueOf(rule.simpleName()) + '.' + property.name(), shortDescription);
                }
            }
            catch (Longjump longjump) {
                // empty catch block
            }
        }
    }

    private static void printPropertyValue(String text, PrintWriter pw) {
        boolean isFirst = true;
        BufferedReader br = new BufferedReader(new StringReader(text));
        while (true) {
            String line;
            try {
                line = br.readLine();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            if (line == null) break;
            if (isFirst) {
                isFirst = false;
            } else {
                pw.println("\\n\\");
            }
            pw.print('\t');
            if (line.startsWith(" ")) {
                pw.print('\\');
            }
            pw.print(line);
        }
        pw.println();
    }
}

