/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.IteratorUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class IterableUtil {
    public static final Iterable<Integer> NATURALS = IterableUtil.foR(1, Integer.MAX_VALUE);
    public static final Iterable<Integer> NATURALS0 = IterableUtil.foR(0, Integer.MAX_VALUE);

    private IterableUtil() {
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<? extends T> i) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = i.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> repeat(final T subject, final int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final AtomicInteger index = new AtomicInteger();

                    @Override
                    public boolean hasNext() {
                        return this.index.intValue() < n;
                    }

                    @Override
                    public T next() {
                        if (this.index.getAndIncrement() >= n) {
                            throw new NoSuchElementException();
                        }
                        return subject;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static <E> Iterable<E> reverseList(final List<E> list) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return IteratorUtil.reverse(list.listIterator(list.size()));
            }
        };
    }

    public static <T> Iterable<T> concat(T element1, Iterable<? extends T> element2) {
        return IterableUtil.concat(Collections.singletonList(element1), element2);
    }

    public static <T> Iterable<T> concat(T element1, T element2, Iterable<? extends T> element3) {
        return IterableUtil.concat(Collections.singletonList(element1), Collections.singletonList(element2), element3);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> element1, T ... element2) {
        return IterableUtil.concat(element1, Arrays.asList(element2));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> element1, Iterable<? extends T> element2) {
        ArrayList<Iterable<? extends T>> l = new ArrayList<Iterable<? extends T>>(2);
        l.add(element1);
        l.add(element2);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> element1, Iterable<? extends T> element2, Iterable<? extends T> element3) {
        ArrayList<Iterable<? extends T>> l = new ArrayList<Iterable<? extends T>>(3);
        l.add(element1);
        l.add(element2);
        l.add(element3);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> element1, Iterable<? extends T> element2, Iterable<? extends T> element3, Iterable<? extends T> element4) {
        ArrayList<Iterable<? extends T>> l = new ArrayList<Iterable<? extends T>>(4);
        l.add(element1);
        l.add(element2);
        l.add(element3);
        l.add(element4);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(final Iterable<? extends Iterable<? extends T>> elements) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<? extends Iterable<? extends T>> outer;
                    Iterator<? extends T> inner;
                    {
                        this.outer = elements.iterator();
                        this.inner = IteratorUtil.atEnd();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.inner.hasNext()) {
                            if (!this.outer.hasNext()) {
                                return false;
                            }
                            this.inner = this.outer.next().iterator();
                        }
                        return true;
                    }

                    @Override
                    public T next() throws NoSuchElementException {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.inner.next();
                    }

                    @Override
                    public void remove() {
                        this.inner.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<? extends T> delegate, final Predicate<? super T> qualifies) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtil.filter(delegate.iterator(), qualifies);
            }
        };
    }

    public static <I, O> Iterable<O> transform(final Iterable<? extends I> delegate, final Transformer<? super I, ? extends O> transform) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return IteratorUtil.transform(delegate.iterator(), transform);
            }
        };
    }

    public static <T> Collection<T> asCollection(final Iterable<T> delegate) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return delegate.iterator();
            }

            @Override
            public int size() {
                int result = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++result;
                    it.next();
                }
                return result;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean addAll(@Nullable Collection<? extends T> c) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<de.unkrig.commons.util.collections.ElementWithContext<T>> iterableWithContext(final Iterable<? extends T> delegate) {
        return new Iterable<de.unkrig.commons.util.collections.ElementWithContext<T>>(){

            @Override
            public Iterator<de.unkrig.commons.util.collections.ElementWithContext<T>> iterator() {
                return IteratorUtil.iteratorWithContext(delegate.iterator());
            }
        };
    }

    @Deprecated
    public static <T> Iterator<de.unkrig.commons.util.collections.ElementWithContext<T>> iteratorWithContext(Iterator<? extends T> delegate) {
        return IteratorUtil.iteratorWithContext(delegate);
    }

    public static Iterable<Integer> foR(int start, int end) {
        return IterableUtil.foR(start, end, 1);
    }

    public static Iterable<Integer> foR(final int start, final int end, final int step) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return IteratorUtil.foR(start, end, step);
            }
        };
    }

    @Deprecated
    public static interface ElementWithContext<T> {
    }
}

