/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.text.StringStream;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.Pattern2;
import de.unkrig.commons.text.pattern.PatternUtil;
import de.unkrig.commons.util.CommandLineOptionException;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.CommandLineOptionGroup;
import de.unkrig.commons.util.annotation.RegexFlags;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public final class CommandLineOptions {
    private static final Pattern REGEX_OPTION;
    private static final Pattern REGEX_COMPACT_OPTIONS;

    private CommandLineOptions() {
    }

    public static String[] parse(String[] args, Object target) throws CommandLineOptionException {
        StringStream ss = new StringStream(ProducerUtil.fromArray(args));
        Parser p = new Parser(target.getClass());
        p.parseOptions(ss, target);
        if (!ss.peekRead("--") && ss.peek(REGEX_OPTION)) {
            throw new CommandLineOptionException.UnrecognizedOption(AssertionUtil.notNull(ss.group(0)));
        }
        return ss.readRest();
    }

    private static int getRegexFlags(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (a.annotationType() != RegexFlags.class) continue;
            return ((RegexFlags)a).value();
        }
        return 0;
    }

    @Nullable
    public static Method getMethodForOption(String optionName, Class<?> targetClass) {
        return new Parser(targetClass).getOptionByName(optionName);
    }

    public static int applyCommandLineOption(String optionName, Method option, String[] args, int optionArgumentIndex, @Nullable Object target) throws CommandLineOptionException {
        Class<?> targetClass = target != null ? target.getClass() : option.getDeclaringClass();
        ProducerUtil.FromArrayProducer<String> fap = ProducerUtil.fromArray(args, optionArgumentIndex, args.length);
        new Parser(targetClass).applyCommandLineOption(optionName, option, new StringStream(fap), target);
        return fap.index();
    }

    public static void printResource(Class<?> baseClass, String relativeResourceName, @Nullable Charset resourceCharset, OutputStream outputStream) throws IOException {
        String resourceName = baseClass.getSimpleName() + "." + relativeResourceName;
        InputStream is = baseClass.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        CommandLineOptions.replaceSystemProperties(is, resourceCharset, true, outputStream, null, false);
    }

    public static void printResource(ClassLoader classLoader, String resourceName, @Nullable Charset resourceCharset, OutputStream outputStream) throws IOException {
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        CommandLineOptions.replaceSystemProperties(is, resourceCharset, true, outputStream, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void replaceSystemProperties(InputStream inputStream, @Nullable Charset inputCharset, boolean closeInputStream, OutputStream outputStream, @Nullable Charset outputCharset, boolean closeOutputStream) throws IOException {
        try {
            if (outputCharset == null) {
                outputCharset = Charset.defaultCharset();
            }
            OutputStreamWriter w = new OutputStreamWriter(outputStream, outputCharset);
            if (inputCharset == null) {
                inputCharset = Charset.defaultCharset();
            }
            InputStreamReader r = new InputStreamReader(inputStream, inputCharset);
            PatternUtil.replaceSystemProperties(r, w);
            ((Writer)w).flush();
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        REGEX_OPTION = Pattern.compile("-.+");
        REGEX_COMPACT_OPTIONS = Pattern.compile("-([^\\-])(.*)");
    }

    private static class Parser<EX extends Throwable> {
        private final Map<String, Method> allOptions = new LinkedHashMap<String, Method>();
        private final Set<Method> singularOptions = new HashSet<Method>();
        private final List<Method> requiredOptions = new ArrayList<Method>();
        private final Set<Class<?>> singularOptionGroups = new HashSet();
        private final List<Class<?>> requiredOptionGroups = new ArrayList();
        private final Map<Method, Set<Class<?>>> optionToOptionGroups = new HashMap();
        private final Set<Method> actualOptions = new HashSet<Method>();
        private final Set<Class<?>> actualOptionGroups = new HashSet();

        Parser(Class<?> targetClass) {
            Method[] methods = targetClass.getMethods();
            Arrays.sort(methods, new Comparator<Method>(){

                @Override
                @NotNullByDefault(value=false)
                public int compare(Method m1, Method m2) {
                    return m1.toString().compareTo(m2.toString());
                }
            });
            for (Method m : methods) {
                CommandLineOption clo = m.getAnnotation(CommandLineOption.class);
                if (clo == null) continue;
                String[] names = clo.name();
                if (names.length == 0) {
                    Object n = m.getName();
                    if (((String)n).startsWith("set")) {
                        n = ((String)n).substring(3);
                    } else if (((String)n).startsWith("add")) {
                        n = ((String)n).substring(3);
                    }
                    names = new String[]{Notations.fromCamelCase((String)n).toLowerCaseHyphenated()};
                }
                for (String name : names) {
                    String[] stringArray;
                    if (name.startsWith("-")) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = name;
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = "-" + (String)name;
                        stringArray = stringArray3;
                        stringArray3[1] = "--" + (String)name;
                    }
                    for (String name2 : stringArray) {
                        Method prev = this.allOptions.put(name2, m);
                        assert (prev == null) : "Two methods map to option \"" + name2 + "\": \"" + prev + "\" and \"" + m + "\"";
                    }
                }
                CommandLineOption.Cardinality c = clo.cardinality();
                if (c == CommandLineOption.Cardinality.MANDATORY || c == CommandLineOption.Cardinality.OPTIONAL) {
                    this.singularOptions.add(m);
                }
                if (c == CommandLineOption.Cardinality.MANDATORY || c == CommandLineOption.Cardinality.ONCE_OR_MORE) {
                    this.requiredOptions.add(m);
                }
                for (Class<?> optionGroup : clo.group()) {
                    CommandLineOptionGroup clog = optionGroup.getAnnotation(CommandLineOptionGroup.class);
                    if (clog == null) {
                        throw new AssertionError((Object)("Option group class \"" + optionGroup + "\" lacks the \"@CommandLineOptionGroup\" annotation"));
                    }
                    Set<Class<?>> optionGroups = this.optionToOptionGroups.get(m);
                    if (optionGroups == null) {
                        optionGroups = new HashSet();
                        this.optionToOptionGroups.put(m, optionGroups);
                    }
                    optionGroups.add(optionGroup);
                    CommandLineOptionGroup.Cardinality c2 = clog.cardinality();
                    if (c2 == CommandLineOptionGroup.Cardinality.EXACTLY_ONE || c2 == CommandLineOptionGroup.Cardinality.ZERO_OR_ONE) {
                        this.singularOptionGroups.add(optionGroup);
                    }
                    if (c2 != CommandLineOptionGroup.Cardinality.EXACTLY_ONE && c2 != CommandLineOptionGroup.Cardinality.ONE_OR_MORE) continue;
                    this.requiredOptionGroups.add(optionGroup);
                }
            }
        }

        private void parseOptions(StringStream<EX> ss, Object target) throws EX, CommandLineOptionException {
            while (this.parseNextOption(ss, target)) {
            }
            for (Method method : this.requiredOptions) {
                if (this.actualOptions.contains(method)) continue;
                throw new CommandLineOptionException.RequiredOptionMissing(method, this.optionNames(method));
            }
            for (Class clazz : this.requiredOptionGroups) {
                if (this.actualOptionGroups.contains(clazz)) continue;
                throw new CommandLineOptionException.RequiredOptionGroupMissing(clazz, this.optionNames(clazz));
            }
        }

        private String[] optionNames(Method option) {
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<String, Method> e : this.allOptions.entrySet()) {
                String optionName = e.getKey();
                Method o = e.getValue();
                if (o != option) continue;
                result.add(optionName);
            }
            return result.toArray(new String[result.size()]);
        }

        private String[] optionNames(Class<?> optionGroup) {
            ArrayList<String> result = new ArrayList<String>();
            block0: for (Map.Entry<String, Method> e : this.allOptions.entrySet()) {
                String optionName = e.getKey();
                Method option = e.getValue();
                for (Class<?> g : option.getAnnotation(CommandLineOption.class).group()) {
                    if (g != optionGroup) continue;
                    result.add(optionName);
                    continue block0;
                }
            }
            return result.toArray(new String[result.size()]);
        }

        private boolean parseNextOption(StringStream<EX> ss, Object target) throws CommandLineOptionException, EX {
            if (ss.atEnd()) {
                return false;
            }
            if (ss.peek("--")) {
                return false;
            }
            if (ss.peek("-")) {
                return false;
            }
            if (this.parseNextVerboseOption(ss, target)) {
                return true;
            }
            if (ss.peek(REGEX_COMPACT_OPTIONS)) {
                char firstOptionLetter = AssertionUtil.notNull(ss.group(1)).charAt(0);
                String followingOptionLetters = AssertionUtil.notNull(ss.group(2));
                String firstOptionName = "-" + firstOptionLetter;
                Method firstOption = this.getOptionByName(firstOptionName);
                if (firstOption != null) {
                    try {
                        ss.read();
                    }
                    catch (StringStream.UnexpectedElementException e) {
                        throw new AssertionError();
                    }
                    this.applyCommandLineOption(firstOptionName, firstOption, ss, target);
                    for (int i = 0; i < followingOptionLetters.length(); ++i) {
                        String optionName = "-" + followingOptionLetters.charAt(i);
                        Method optionMethod = this.getOptionByName(optionName);
                        if (optionMethod == null) {
                            throw new CommandLineOptionException.UnrecognizedOption(optionName);
                        }
                        this.applyCommandLineOption(optionName, optionMethod, ss, target);
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean parseNextVerboseOption(StringStream<EX> ss, Object target) throws CommandLineOptionException, EX {
            String optionName;
            if (ss.atEnd()) {
                return false;
            }
            try {
                optionName = ss.peek();
            }
            catch (StringStream.UnexpectedElementException uee) {
                throw new AssertionError((Object)uee);
            }
            Method option = this.getOptionByName(optionName);
            if (option == null) {
                return false;
            }
            try {
                ss.read();
            }
            catch (StringStream.UnexpectedElementException uee) {
                throw new AssertionError((Object)uee);
            }
            this.applyCommandLineOption(optionName, option, ss, target);
            return true;
        }

        @Nullable
        public Method getOptionByName(String optionName) {
            return this.allOptions.get(optionName);
        }

        public void applyCommandLineOption(String optionName, Method option, StringStream<EX> stringStream, @Nullable Object target) throws CommandLineOptionException, EX {
            if (this.singularOptions.contains(option) && this.actualOptions.contains(option)) {
                throw new CommandLineOptionException.DuplicateOption(option, optionName, this.optionNames(option));
            }
            Set<Class<?>> optionGroups = this.optionToOptionGroups.get(option);
            if (optionGroups != null) {
                for (Class<?> optionGroup : optionGroups) {
                    if (!this.singularOptionGroups.contains(optionGroup) || !this.actualOptionGroups.contains(optionGroup)) continue;
                    throw new CommandLineOptionException.ConflictingOptions(optionGroup, option, optionName);
                }
            }
            Class<?>[] methodParametersTypes = option.getParameterTypes();
            Annotation[][] methodParametersAnnotations = option.getParameterAnnotations();
            assert (methodParametersTypes.length == methodParametersAnnotations.length);
            Object[] methodArgs = new Object[methodParametersTypes.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                try {
                    methodArgs[i] = this.getArgument(stringStream, methodParametersAnnotations[i], methodParametersTypes[i]);
                    continue;
                }
                catch (StringStream.UnexpectedElementException uee) {
                    throw new CommandLineOptionException.OptionArgumentMissing(option, optionName, i);
                }
            }
            try {
                option.invoke(target, methodArgs);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            this.actualOptions.add(option);
            if (optionGroups != null) {
                for (Class<?> optionGroup : optionGroups) {
                    this.actualOptionGroups.add(optionGroup);
                }
            }
        }

        private Object getArgument(StringStream<EX> ss, Annotation[] annotations, Class<?> targetType) throws CommandLineOptionException, StringStream.UnexpectedElementException, EX {
            if (targetType.isArray()) {
                Class<?> componentType = targetType.getComponentType();
                ArrayList<Object> elements = new ArrayList<Object>();
                while (!ss.atEnd()) {
                    elements.add(this.getArgument(ss, annotations, componentType));
                }
                int size = elements.size();
                Object result = Array.newInstance(componentType, size);
                if (componentType.isPrimitive()) {
                    for (int i = 0; i < size; ++i) {
                        Array.set(result, i, elements.get(i));
                    }
                } else {
                    System.arraycopy(elements.toArray(), 0, result, 0, size);
                }
                return result;
            }
            if (targetType == Pattern.class) {
                return Pattern2.compile(ss.read(), CommandLineOptions.getRegexFlags(annotations));
            }
            if (targetType == Glob.class) {
                return Glob.compile(ss.read(), CommandLineOptions.getRegexFlags(annotations));
            }
            Constructor<?>[] cs = targetType.getConstructors();
            if (cs.length == 1 && cs[0].getParameterTypes().length == 0) {
                Object bean;
                try {
                    bean = cs[0].newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
                super.parseOptions(ss, bean);
                return bean;
            }
            String arg = ss.read();
            try {
                return ObjectUtil.fromString(arg, targetType);
            }
            catch (IllegalArgumentException iae) {
                throw new CommandLineOptionException.ArgumentConversionFailed(arg, targetType, iae);
            }
        }
    }
}

