/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.scanner;

import de.unkrig.commons.text.scanner.StatefulScanner;
import de.unkrig.commons.text.scanner.StringScanner;

public final class XmlScanner {
    private XmlScanner() {
    }

    public static StringScanner<TokenType> stringScanner() {
        StatefulScanner<TokenType, State> scanner = new StatefulScanner<TokenType, State>(State.class);
        String s = "(?:[ \\t\\r\\n]+)";
        String eq = "(?:" + s + "?=" + s + "?)";
        String nameStartChar = "[:A-Z_a-z\u00c0-\u00d6\u00d8-\u00f6\u00f8-\u02ff\u0370-\u037d\u037f-\u1fff\u200c-\u200d\u2070-\u218f\u2c00-\u2fef\u3001-\ud7ff\uf900-\ufdcf\ufdf0-\ufffd]";
        String nameChar = "(?:" + nameStartChar + "|[\\-.0-9\u00b7\u0300-\u036f\u203f-\u2040])";
        String name = "(?:" + nameStartChar + nameChar + "*)";
        String entityReference = "(?:&" + name + ";)";
        String characterReference = "(?:&#[0-9]+|&#x[0-9a-zA-Z]+;)";
        String reference = "(?:" + entityReference + "|" + characterReference + ")";
        String attributeValue = "(?:'(?:[^<&\"]|" + reference + ")*'|\"(?:[^<&\"]|" + reference + ")*\")";
        scanner.addRule("<!--(.*?)-->", TokenType.COMMENT);
        scanner.addRule(("<\\?xml(?:@S@version@Eq@(" + XmlScanner.quoted("1\\.[0-9]+") + "))" + "(?:@S@encoding@Eq@(" + XmlScanner.quoted("[A-Za-z][A-Za-z0-9._\\-]*") + "))?" + "(?:@S@standalone@Eq@(" + XmlScanner.quoted("yes|no") + "))?" + "\\?>").replace("@S@", s).replace("@Eq@", eq), TokenType.XML_DECLARATION);
        scanner.addRule("<\\?(@Name@)(@S@.*?)?\\?>".replace("@Name@", name).replace("@S@", s), TokenType.PROCESSING_INSTRUCTION);
        scanner.addRule("<!DOCTYPE.*?>", TokenType.DOCUMENT_TYPE_DECLARATION);
        scanner.addRule("<(@Name@)".replace("@Name@", name), TokenType.BEGIN_TAG, State.TAG);
        scanner.addRule(State.TAG, s + "(" + name + ")", TokenType.ATTRIBUTE_NAME, State.TAG);
        scanner.addRule(State.TAG, eq + "(" + attributeValue + ")", TokenType.ATTRIBUTE_VALUE, State.TAG);
        scanner.addRule(State.TAG, "@S@?>".replace("@S@", s), TokenType.END_START_TAG);
        scanner.addRule(State.TAG, "@S@?/>".replace("@S@", s), TokenType.END_EMPTY_ELEMENT_TAG);
        scanner.addRule("</(@Name@)@S@?>".replace("@Name@", name).replace("@S@", s), TokenType.END_TAG);
        scanner.addRule("(?:[^<&](?!-->))+", TokenType.CHAR_DATA);
        scanner.addRule(entityReference, TokenType.ENTITY_REFERENCE);
        scanner.addRule(characterReference, TokenType.CHARACTER_REFERENCE);
        scanner.addRule("(?:<!\\[CDATA\\[(.*?)]]>)", TokenType.CDATA_SECTION);
        return scanner;
    }

    private static String quoted(String subpattern) {
        return "(?:'(?:" + subpattern + ")*'" + "|" + "\"(?:" + subpattern + ")*\"" + ")";
    }

    public static enum TokenType {
        XML_DECLARATION,
        COMMENT,
        PROCESSING_INSTRUCTION,
        DOCUMENT_TYPE_DECLARATION,
        BEGIN_TAG,
        ATTRIBUTE_NAME,
        ATTRIBUTE_VALUE,
        END_START_TAG,
        END_EMPTY_ELEMENT_TAG,
        END_TAG,
        CHAR_DATA,
        ENTITY_REFERENCE,
        CHARACTER_REFERENCE,
        CDATA_SECTION;

    }

    public static enum State {
        TAG;

    }
}

