/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Characters {
    public static final Predicate<Integer> IS_POSIX_LOWER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 97 && c <= 122;
        }
    };
    public static final Predicate<Integer> IS_POSIX_UPPER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 65 && c <= 90;
        }
    };
    public static final Predicate<Integer> IS_POSIX_ASCII = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return subject <= 127;
        }
    };
    public static final Predicate<Integer> IS_POSIX_ALPHA = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }
    };
    public static final Predicate<Integer> IS_POSIX_DIGIT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 48 && c <= 57;
        }
    };
    public static final Predicate<Integer> IS_POSIX_ALNUM = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57;
        }
    };
    public static final Predicate<Integer> IS_POSIX_PUNCT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 33 && c <= 47 || c >= 58 && c <= 64 || c >= 91 && c <= 96 || c >= 123 && c <= 126;
        }
    };
    public static final Predicate<Integer> IS_POSIX_GRAPH = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return IS_POSIX_ALNUM.evaluate(subject) || IS_POSIX_PUNCT.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_POSIX_PRINT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return subject == 32 || IS_POSIX_ALNUM.evaluate(subject) || IS_POSIX_PUNCT.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_POSIX_BLANK = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c == 32 || c == 9;
        }
    };
    public static final Predicate<Integer> IS_POSIX_CNTRL = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c <= 31 || c == 127;
        }
    };
    public static final Predicate<Integer> IS_POSIX_XDIGIT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
        }
    };
    public static final Predicate<Integer> IS_POSIX_SPACE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int c = subject;
            return c >= 9 && c <= 13 || c == 32;
        }
    };
    public static final Predicate<Integer> IS_LOWER_CASE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLowerCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UPPER_CASE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isUpperCase(subject);
        }
    };
    public static final Predicate<Integer> IS_WHITESPACE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isWhitespace(subject);
        }
    };
    public static final Predicate<Integer> IS_MIRRORED = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isMirrored(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_LOWER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLowerCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_UPPER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isUpperCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_TITLE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isTitleCase(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_LETTER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isLetter(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_ALPHA = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int type = Character.getType(subject);
            return type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 10;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_DIGIT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isDigit(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_ALNUM = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return IS_UNICODE_ALPHA.evaluate(subject) || IS_UNICODE_DIGIT.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_PUNCT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int type = Character.getType(subject);
            return type == 23 || type == 20 || type == 21 || type == 22 || type == 24 || type == 29 || type == 30;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_GRAPH = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int type = Character.getType(subject);
            return type == 12 || type == 13 || type == 14 || type == 15 || type == 19 || type == 0;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_PRINT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return (IS_UNICODE_GRAPH.evaluate(subject) || IS_UNICODE_BLANK.evaluate(subject)) && !IS_UNICODE_CNTRL.evaluate(subject);
        }
    };
    public static final Predicate<Integer> IS_UNICODE_BLANK = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.getType(subject) == 12 || subject == 9;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_CNTRL = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.getType(subject) == 15;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_HEX_DIGIT = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.isDigit(subject) || subject >= 48 && subject <= 57 || subject >= 65 && subject <= 70 || subject >= 97 && subject <= 102 || subject >= 65296 && subject <= 65305 || subject >= 65313 && subject <= 65318 || subject >= 65345 && subject <= 65350;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_ASSIGNED = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return Character.getType(subject) != 0;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_NONCHARACTER = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return (subject & 0xFFFE) == 65534 || subject >= 64976 && subject <= 65007;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_WHITE_SPACE = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            int type = Character.getType(subject);
            return type == 12 || type == 13 || type == 14 || subject >= 9 && subject <= 13 || subject == 133;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_WORD = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            if (IS_UNICODE_ALPHA.evaluate(subject) || IS_UNICODE_JOIN_CONTROL.evaluate(subject)) {
                return true;
            }
            int type = Character.getType(subject);
            return type == 6 || type == 7 || type == 8 || type == 9 || type == 23;
        }
    };
    public static final Predicate<Integer> IS_UNICODE_JOIN_CONTROL = new Predicate<Integer>(){

        @Override
        public boolean evaluate(Integer subject) {
            return subject == 8204 || subject == 8205;
        }
    };
    private static final Map<String, Predicate<Integer>> UNICODE_PROPERTIES;
    private static final Map<String, Predicate<Integer>> UNICODE_PROPERTIES2;

    private Characters() {
    }

    @Nullable
    public static Predicate<Integer> unicodePropertyFromName(String name) {
        return UNICODE_PROPERTIES.get(name.toUpperCase(Locale.US));
    }

    @Nullable
    public static Predicate<Integer> unicodePropertyFromPosixName(String name) {
        return UNICODE_PROPERTIES2.get(name.toUpperCase(Locale.US));
    }

    static {
        HashMap<String, Predicate<Integer>> m = new HashMap<String, Predicate<Integer>>();
        m.put("ALPHABETIC", IS_UNICODE_ALPHA);
        m.put("LETTER", IS_UNICODE_LETTER);
        m.put("LOWERCASE", IS_UNICODE_LOWER);
        m.put("UPPERCASE", IS_UNICODE_UPPER);
        m.put("TITLECASE", IS_UNICODE_TITLE);
        m.put("WHITE_SPACE", IS_UNICODE_WHITE_SPACE);
        m.put("CONTROL", IS_UNICODE_CNTRL);
        m.put("PUNCTUATION", IS_UNICODE_PUNCT);
        m.put("HEX_DIGIT", IS_UNICODE_HEX_DIGIT);
        m.put("ASSIGNED", IS_UNICODE_ASSIGNED);
        m.put("NONCHARACTER_CODE_POINT", IS_UNICODE_NONCHARACTER);
        m.put("DIGIT", IS_UNICODE_DIGIT);
        m.put("ALNUM", IS_UNICODE_ALNUM);
        m.put("BLANK", IS_UNICODE_BLANK);
        m.put("GRAPH", IS_UNICODE_GRAPH);
        m.put("PRINT", IS_UNICODE_PRINT);
        m.put("WORD", IS_UNICODE_WORD);
        m.put("JOIN_CONTROL", IS_UNICODE_JOIN_CONTROL);
        m.put("WHITESPACE", (Predicate<Integer>)m.get("WHITE_SPACE"));
        m.put("HEXDIGIT", (Predicate<Integer>)m.get("HEX_DIGIT"));
        m.put("NONCHARACTERCODEPOINT", (Predicate<Integer>)m.get("NONCHARACTER_CODE_POINT"));
        m.put("JOINCONTROL", (Predicate<Integer>)m.get("JOIN_CONTROL"));
        UNICODE_PROPERTIES = Collections.unmodifiableMap(m);
        m = new HashMap();
        m.put("ALPHA", IS_UNICODE_ALPHA);
        m.put("LOWER", IS_UNICODE_LOWER);
        m.put("UPPER", IS_UNICODE_UPPER);
        m.put("SPACE", IS_UNICODE_WHITE_SPACE);
        m.put("PUNCT", IS_UNICODE_PUNCT);
        m.put("XDIGIT", IS_UNICODE_HEX_DIGIT);
        m.put("ALNUM", IS_UNICODE_ALNUM);
        m.put("CNTRL", IS_UNICODE_CNTRL);
        m.put("DIGIT", IS_UNICODE_DIGIT);
        m.put("BLANK", IS_UNICODE_BLANK);
        m.put("GRAPH", IS_UNICODE_GRAPH);
        m.put("PRINT", IS_UNICODE_PRINT);
        UNICODE_PROPERTIES2 = Collections.unmodifiableMap(m);
    }
}

