/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.io.Readers;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ClassLoaders;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;

public final class IoUtil {
    private static final Logger LOGGER;
    private static final ExecutorService EXECUTOR_SERVICE;
    @Deprecated
    public static final InputStream EMPTY_INPUT_STREAM;
    @Deprecated
    public static final OutputStream NULL_OUTPUT_STREAM;
    @Deprecated
    public static final InputStream ZERO_INPUT_STREAM;

    private IoUtil() {
    }

    @Nullable
    public static URL findOnPath(@Nullable File[] path, String resourceName) throws IOException {
        if (path == null) {
            return null;
        }
        for (File directoryOrArchiveFile : path) {
            if (directoryOrArchiveFile.isDirectory()) {
                File file = new File(directoryOrArchiveFile, resourceName);
                if (!file.isFile()) continue;
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException mue) {
                    AssertionError ae = new AssertionError((Object)resourceName);
                    ((Throwable)((Object)ae)).initCause(mue);
                    throw ae;
                }
            }
            if (!directoryOrArchiveFile.isFile()) continue;
            URL url = new URL("jar", null, directoryOrArchiveFile.toURI() + "!/" + resourceName);
            try {
                url.openConnection().connect();
                return url;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                if (inputStream.available() == 0) {
                    outputStream.flush();
                }
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap(count + " bytes copied so far", ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        try {
            long count = IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
            if (closeInputStream) {
                inputStream.close();
            }
            if (closeOutputStream) {
                outputStream.close();
            }
            return count;
        }
        catch (IOException ioe) {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public static RunnableWhichThrows<IOException> copyRunnable(final InputStream in, final OutputStream out) {
        return new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                IoUtil.copy(in, out);
            }
        };
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, false, writer, false);
    }

    public static long copy(Reader reader, boolean closeReader, Writer writer, boolean closeWriter) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        try {
            while (true) {
                LOGGER.log(Level.FINEST, "About to ''read(char[{0}])''", buffer.length);
                int n = reader.read(buffer);
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", n);
                if (n == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(char[{0}])''", n);
                writer.write(buffer, 0, n);
                LOGGER.log(Level.FINEST, "'write()' returned");
            }
            writer.flush();
            if (closeReader) {
                reader.close();
            }
            if (closeWriter) {
                writer.close();
            }
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ExceptionUtil.wrap(count + " characters copied so far", ioe);
        }
    }

    public static long copy(Reader reader, OutputStream outputStream, Charset charset) throws IOException {
        return IoUtil.copy(reader, new OutputStreamWriter(outputStream, charset));
    }

    public static long copy(Readable r, Appendable a) throws IOException {
        int n;
        CharBuffer cb = CharBuffer.allocate(4096);
        long count = 0L;
        while ((n = r.read(cb)) != -1) {
            cb.flip();
            a.append(cb);
            count += (long)n;
            cb.clear();
        }
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile, boolean append) throws IOException {
        try {
            return IoUtil.copy(inputStream, closeInputStream, new FileOutputStream(outputFile, append), true);
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static long copy(Reader reader, boolean closeReader, File outputFile, boolean append, Charset outputCharset) throws IOException {
        try {
            long count = IoUtil.copy(reader, closeReader, new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, append), outputCharset), true);
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static void copyAndTransform(Reader in, Transformer<? super CharSequence, ? extends CharSequence> transformer, Appendable out, int bufferCapacity) throws IOException {
        int n;
        char[] buffer = new char[bufferCapacity];
        while ((n = in.read(buffer)) != -1) {
            out.append((CharSequence)transformer.transform(new Segment(buffer, 0, n)));
        }
        out.append((CharSequence)transformer.transform(""));
    }

    public static long copy(File inputFile, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        FileInputStream is;
        try {
            is = new FileInputStream(inputFile);
        }
        catch (IOException ioe) {
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        return IoUtil.copy((InputStream)is, true, outputStream, closeOutputStream);
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            return IoUtil.copy(inputStream, closeInputStream, os, true);
        }
        catch (IOException ioe) {
            if (!outputFile.delete()) {
                throw new IOException("Cannot delete '" + outputFile + "'");
            }
            throw ioe;
        }
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile, CollisionStrategy collisionStrategy) throws IOException {
        if (!outputFile.exists()) {
            return IoUtil.copy(inputStream, closeInputStream, outputFile);
        }
        switch (collisionStrategy) {
            case LEAVE_OLD: {
                if (closeInputStream) {
                    inputStream.close();
                }
                return -1L;
            }
            case OVERWRITE: {
                return IoUtil.copy(inputStream, closeInputStream, outputFile);
            }
            case IO_EXCEPTION: {
                throw new IOException("File \"" + outputFile + "\" already exists");
            }
            case IO_EXCEPTION_IF_DIFFERENT: {
                if (!IoUtil.isContentIdentical(inputStream, outputFile)) {
                    throw new IOException("File \"" + outputFile + "\" already exists with non-identical content");
                }
                if (closeInputStream) {
                    inputStream.close();
                }
                return -1L;
            }
        }
        throw new AssertionError((Object)collisionStrategy);
    }

    public static long copy(File inputFile, File outputFile) throws IOException {
        return IoUtil.copy((InputStream)new FileInputStream(inputFile), true, outputFile);
    }

    public static long copy(File inputFile, File outputFile, CollisionStrategy collisionStrategy) throws IOException {
        if (!outputFile.exists()) {
            return IoUtil.copy(inputFile, outputFile);
        }
        switch (collisionStrategy) {
            case LEAVE_OLD: {
                return -1L;
            }
            case OVERWRITE: {
                return IoUtil.copy(inputFile, outputFile);
            }
            case IO_EXCEPTION: {
                throw new IOException("File \"" + outputFile + "\" already exists");
            }
            case IO_EXCEPTION_IF_DIFFERENT: {
                if (!IoUtil.isContentIdentical(inputFile, outputFile)) {
                    throw new IOException("File \"" + outputFile + "\" already exists with non-identical content");
                }
                return -1L;
            }
        }
        throw new AssertionError((Object)collisionStrategy);
    }

    public static void copyTree(File source, File destination, CollisionStrategy collisionStrategy) throws IOException {
        if (source.isFile()) {
            IoUtil.copy(source, destination, collisionStrategy);
            return;
        }
        boolean destinationDirectoryAlreadyExisted = destination.exists();
        if (!destinationDirectoryAlreadyExisted && !destination.mkdir()) {
            throw new IOException(destination.toString());
        }
        try {
            String[] memberNames = source.list();
            if (memberNames == null) {
                throw new IOException(source + ": Permission denied");
            }
            for (String memberName : memberNames) {
                IoUtil.copyTree(new File(source, memberName), new File(destination, memberName), collisionStrategy);
            }
        }
        catch (IOException ioe) {
            if (!destinationDirectoryAlreadyExisted) {
                destination.delete();
            }
            throw ioe;
        }
        catch (RuntimeException re) {
            if (!destinationDirectoryAlreadyExisted) {
                destination.delete();
            }
            throw re;
        }
    }

    public static void copyTree(URL source, File destination, CollisionStrategy collisionStrategy) throws IOException {
        Map<String, URL> rs = ClassLoaders.getSubresourcesOf(source, "", true);
        if (rs.isEmpty()) {
            return;
        }
        if (rs.size() == 1) {
            IoUtil.copy(rs.values().iterator().next().openStream(), true, destination, collisionStrategy);
            return;
        }
        IoUtil.copySubtree(rs, "", destination, collisionStrategy);
    }

    private static void copySubtree(Map<String, URL> rs, String namePrefix, File destinationDirectory, CollisionStrategy collisionStrategy) throws IOException {
        assert (rs.get(namePrefix) != null);
        if (!destinationDirectory.mkdir()) {
            throw new IOException("Could not create destination directory \"" + destinationDirectory + "\"");
        }
        for (Map.Entry<String, URL> e : rs.entrySet()) {
            String name = e.getKey();
            URL location = e.getValue();
            if (!name.startsWith(namePrefix)) continue;
            int npl = namePrefix.length();
            if (name.length() == npl) continue;
            int idx = name.indexOf(47, npl);
            if (idx == -1) {
                IoUtil.copy(location.openStream(), true, new File(destinationDirectory, name.substring(npl)));
                continue;
            }
            if (idx != name.length() - 1) continue;
            IoUtil.copySubtree(rs, name, new File(destinationDirectory, name.substring(npl)), collisionStrategy);
        }
    }

    public static ConsumerWhichThrows<OutputStream, IOException> copyFrom(final InputStream inputStream) {
        return new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream os) throws IOException {
                IoUtil.copy(inputStream, os);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isContentIdentical(File file1, File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fis1 = new FileInputStream(file1);
        try {
            boolean result = IoUtil.isContentIdentical((InputStream)fis1, file2);
            ((InputStream)fis1).close();
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                ((InputStream)fis1).close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isContentIdentical(InputStream stream, File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            boolean result = IoUtil.isContentIdentical(stream, fis);
            ((InputStream)fis).close();
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                ((InputStream)fis).close();
            }
            catch (Exception exception) {}
        }
    }

    private static boolean isContentIdentical(InputStream stream1, InputStream stream2) throws IOException {
        int n1;
        byte[] buffer1 = new byte[4096];
        byte[] buffer2 = new byte[4096];
        while ((n1 = stream1.read(buffer1)) != -1) {
            int off = 0;
            while (off < n1) {
                int n2 = stream2.read(buffer2, off, n1 - off);
                if (n2 == -1) {
                    return false;
                }
                while (n2 > 0) {
                    if (buffer2[off] != buffer1[off]) {
                        return false;
                    }
                    --n2;
                    ++off;
                }
            }
        }
        return true;
    }

    @Deprecated
    @NotNullByDefault(value=false)
    public static OutputStream tee(OutputStream ... delegates) {
        return OutputStreams.tee(delegates);
    }

    @Deprecated
    public static InputStream wye(InputStream in, OutputStream out) {
        return InputStreams.wye(in, out);
    }

    @Deprecated
    public static long writeAndCount(ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents, OutputStream outputStream) throws IOException {
        return OutputStreams.writeAndCount(writeContents, outputStream);
    }

    public static void parallel(WritingRunnable[] writingRunnables, Writer writer) {
        List<Callable<Void>> callables = IoUtil.toCallables(writingRunnables, writer);
        try {
            EXECUTOR_SERVICE.invokeAll(callables);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private static List<Callable<Void>> toCallables(WritingRunnable[] writingRunnables, final Writer writer) {
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(writingRunnables.length + 1);
        final ArrayList<PipedReader> readers = new ArrayList<PipedReader>(writingRunnables.length);
        callables.add(new Callable<Void>(){

            @Override
            @Nullable
            public Void call() throws Exception {
                for (Reader reader : readers) {
                    IoUtil.copy(reader, writer);
                }
                return null;
            }
        });
        for (final WritingRunnable wr : writingRunnables) {
            final PipedWriter pw = new PipedWriter();
            try {
                readers.add(new PipedReader(pw));
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Should never throw an IOException if the argument is a 'fresh' PipedWriter", ioe, AssertionError.class);
            }
            callables.add(new Callable<Void>(){

                @Override
                @Nullable
                public Void call() throws Exception {
                    try {
                        wr.run(pw);
                        Void void_ = null;
                        return void_;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, null, e);
                        throw e;
                    }
                    catch (Error e) {
                        LOGGER.log(Level.SEVERE, null, e);
                        throw e;
                    }
                    finally {
                        try {
                            pw.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
        return callables;
    }

    @Deprecated
    public static byte[] readAll(InputStream is) throws IOException {
        return InputStreams.readAll(is);
    }

    @Deprecated
    public static String readAll(InputStream inputStream, Charset charset, boolean closeInputStream) throws IOException {
        return InputStreams.readAll(inputStream, charset, closeInputStream);
    }

    @Deprecated
    public static long skip(InputStream inputStream, long n) throws IOException {
        return InputStreams.skip(inputStream, n);
    }

    @Deprecated
    public static long skipAll(InputStream inputStream) throws IOException {
        return InputStreams.skipAll(inputStream);
    }

    @Deprecated
    public static OutputStream split(ProducerWhichThrows<? extends OutputStream, ? extends IOException> delegates, Producer<? extends Long> byteCountLimits) throws IOException {
        return OutputStreams.split(delegates, byteCountLimits);
    }

    @Deprecated
    public static InputStream constantInputStream(byte b) {
        return InputStreams.constantInputStream(b);
    }

    @Deprecated
    public static InputStream unclosableInputStream(InputStream delegate) {
        return InputStreams.unclosable(delegate);
    }

    @Deprecated
    public static OutputStream unclosableOutputStream(OutputStream delegate) {
        return OutputStreams.unclosable(delegate);
    }

    @Deprecated
    public static void fill(OutputStream outputStream, byte b, long count) throws IOException {
        OutputStreams.fill(outputStream, b, count);
    }

    @Deprecated
    public static InputStream byteProducerInputStream(ProducerWhichThrows<? extends Byte, ? extends IOException> delegate) {
        return InputStreams.byteProducerInputStream(delegate);
    }

    @Deprecated
    public static InputStream byteProducerInputStream(Producer<? extends Byte> delegate) {
        return InputStreams.byteProducerInputStream(delegate);
    }

    @Deprecated
    public static InputStream randomInputStream(long seed) {
        return InputStreams.randomInputStream(seed);
    }

    @Deprecated
    public static OutputStream byteConsumerOutputStream(ConsumerWhichThrows<? super Byte, ? extends IOException> delegate) {
        return OutputStreams.byteConsumerOutputStream(delegate);
    }

    @Deprecated
    public static String readAll(Reader reader) throws IOException {
        return Readers.readAll(reader);
    }

    @Deprecated
    public static String readAll(Reader reader, boolean closeReader) throws IOException {
        return Readers.readAll(reader, closeReader);
    }

    @Deprecated
    protected static InputStream deleteOnClose(InputStream delegate, File file) {
        return InputStreams.deleteOnClose(delegate, file);
    }

    @Deprecated
    public static OutputStream[] compareOutput(int n, Runnable whenIdentical, Runnable whenNotIdentical) {
        return OutputStreams.compareOutput(n, whenIdentical, whenNotIdentical);
    }

    @Deprecated
    public static OutputStream lengthWritten(Consumer<? super Integer> delegate) {
        return OutputStreams.lengthWritten(delegate);
    }

    @Deprecated
    public static Reader asReader(CharSequence cs) {
        return Readers.asReader(cs);
    }

    public static void copyResource(ClassLoader classLoader, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(Class<?> clasS, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = clasS.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(final ClassLoader classLoader, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(classLoader, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    public static void copyResource(final Class<?> clasS, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(clasS, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <EX extends Throwable> void asFile(InputStream inputStream, boolean closeInputStream, @Nullable String prefix, @Nullable String suffix, @Nullable File directory, ConsumerWhichThrows<? super File, ? extends EX> delegate) throws IOException, EX {
        File temporaryFile = File.createTempFile(prefix, suffix, directory);
        try {
            temporaryFile.deleteOnExit();
            IoUtil.copy(inputStream, closeInputStream, temporaryFile);
            delegate.consume(temporaryFile);
            temporaryFile.delete();
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            temporaryFile.delete();
        }
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, Charset charset, ConsumerWhichThrows<? super PrintWriter, ? extends EX> printer) throws IOException, EX {
        IoUtil.outputFilePrintWriter(file, charset, printer, false);
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, final Charset charset, final ConsumerWhichThrows<? super PrintWriter, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        final boolean[] hasError = new boolean[1];
        IoUtil.outputFileOutputStream(file, new ConsumerWhichThrows<OutputStream, EX>(){

            @Override
            public void consume(OutputStream os) throws Throwable {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, charset));
                delegate.consume(pw);
                hasError[0] = pw.checkError();
            }
        }, createMissingParentDirectories);
        if (hasError[0]) {
            throw new IOException();
        }
    }

    public static <EX extends Throwable> void outputFileOutputStream(File file, final ConsumerWhichThrows<? super OutputStream, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        class IORuntimeException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IOException ioe;

            IORuntimeException(IOException ioe) {
                this.ioe = ioe;
            }
        }
        try {
            IoUtil.outputFile(file, new ConsumerWhichThrows<File, EX>(){

                @Override
                public void consume(File file) throws Throwable {
                    try {
                        FileOutputStream os = new FileOutputStream(file);
                        try {
                            delegate.consume(os);
                        }
                        catch (RuntimeException re) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw re;
                        }
                        catch (Error e) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw e;
                        }
                        catch (Throwable t) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Throwable tmp = t;
                            throw tmp;
                        }
                        ((OutputStream)os).close();
                    }
                    catch (IOException ioe) {
                        throw new IORuntimeException(ioe);
                    }
                }
            }, createMissingParentDirectories);
        }
        catch (IORuntimeException iore) {
            throw iore.ioe;
        }
    }

    public static <EX extends Throwable> void outputFile(File file, ConsumerWhichThrows<? super File, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        if (createMissingParentDirectories) {
            IoUtil.createMissingParentDirectoriesFor(file);
        }
        File newFile = new File(file.getParentFile(), "." + file.getName() + ".new");
        try {
            delegate.consume(newFile);
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete existing file \"" + file + "\"");
            }
            if (!newFile.renameTo(file)) {
                throw new IOException("Could not rename \"" + newFile + "\" to \"" + file + "\"");
            }
        }
        catch (RuntimeException re) {
            newFile.delete();
            throw re;
        }
        catch (Error e) {
            newFile.delete();
            throw e;
        }
        catch (Throwable t) {
            newFile.delete();
            Throwable tmp = t;
            throw tmp;
        }
    }

    public static void createMissingParentDirectoriesFor(File file) throws IOException {
        File parentDirectory = file.getParentFile();
        if (parentDirectory == null) {
            return;
        }
        if (!parentDirectory.isDirectory() && !parentDirectory.mkdirs()) {
            throw new IOException("Cannot create directory \"" + parentDirectory + "\"");
        }
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copyAvailable(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L && inputStream.available() > 0) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) {
                    throw new IllegalStateException("EOI despite available()");
                }
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap(count + " bytes copied so far", ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    @Deprecated
    public static InputStream onEndOfInput(InputStream delegate, Runnable runnable) {
        return InputStreams.onEndOfInput(delegate, runnable);
    }

    @Deprecated
    public static Reader singlingFilterReader(Reader delegate) {
        return Readers.singlingFilterReader(delegate);
    }

    @Deprecated
    public static InputStream singlingFilterInputStream(InputStream delegate) {
        return InputStreams.singlingFilterInputStream(delegate);
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(IoUtil.class.getName());
        EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(3 * Runtime.getRuntime().availableProcessors(), ThreadUtil.DAEMON_THREAD_FACTORY);
        EMPTY_INPUT_STREAM = InputStreams.EMPTY;
        NULL_OUTPUT_STREAM = OutputStreams.DISCARD;
        ZERO_INPUT_STREAM = InputStreams.ZERO;
    }

    public static interface WritingRunnable {
        public void run(Writer var1) throws Exception;
    }

    public static enum CollisionStrategy {
        LEAVE_OLD,
        OVERWRITE,
        IO_EXCEPTION,
        IO_EXCEPTION_IF_DIFFERENT;

    }
}

