/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.notemplate.util;

import de.unkrig.commons.lang.AssertionUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class Entities {
    private static final Map<Character, String> HTML_CHARACTER_ENTITIES;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        try {
            InputStream is = Entities.class.getResourceAsStream("html-character-entities.properties");
            assert (is != null) : "Resource \"html-character-entities.properties\" not found";
            Properties p = new Properties();
            p.load(is);
            is.close();
            HashMap<Character, String> m = new HashMap<Character, String>();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                assert (key.length() == 1);
                m.put(Character.valueOf(key.charAt(0)), value);
            }
            HTML_CHARACTER_ENTITIES = m;
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private Entities() {
    }

    public static String replaceXmlSpecialCharactersWithPredefinedEntities(String s) {
        int idx;
        int len;
        block10: {
            len = s.length();
            idx = 0;
            while (idx < len) {
                char c = s.charAt(idx);
                if (c != '\"' && c != '&' && c != '\'' && c != '<' && c != '>') {
                    ++idx;
                    continue;
                }
                break block10;
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, idx));
        while (idx < len) {
            char c = s.charAt(idx);
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++idx;
        }
        return sb.toString();
    }

    public static String replaceNonAsciiCharactersWithHtmlCharacterReferences(String s) {
        int idx;
        int len;
        block7: {
            len = s.length();
            idx = 0;
            while (idx < len) {
                if (s.charAt(idx) < '\u0080') {
                    ++idx;
                    continue;
                }
                break block7;
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, idx));
        while (idx < len) {
            char c = s.charAt(idx);
            if (c <= '\u007f') {
                sb.append(c);
            } else {
                String entity = HTML_CHARACTER_ENTITIES.get(Character.valueOf(c));
                if (entity != null) {
                    sb.append('&').append(entity).append(';');
                } else {
                    sb.append("&#").append((int)c).append(';');
                }
            }
            ++idx;
        }
        return sb.toString();
    }

    public static String replaceNonAsciiCharactersWithNumericCharacterReferences(String s) {
        int idx;
        int len;
        block5: {
            len = s.length();
            idx = 0;
            while (idx < len) {
                if (s.charAt(idx) < '\u0080') {
                    ++idx;
                    continue;
                }
                break block5;
            }
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, idx));
        while (idx < len) {
            char c = s.charAt(idx);
            if (c <= '\u007f') {
                sb.append(c);
            } else {
                sb.append("&#").append((int)c).append(';');
            }
            ++idx;
        }
        return sb.toString();
    }
}

