/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.notemplate.javadocish;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.IterableUtil;
import de.unkrig.notemplate.NoTemplate;
import de.unkrig.notemplate.javadocish.Options;
import de.unkrig.notemplate.javadocish.templates.AbstractRightFrameHtml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class IndexPages {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private IndexPages() {
    }

    public static IndexEntry indexEntry(final String key, final String link, final String explanation, final String shortDescription) {
        return new IndexEntry(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getLink() {
                return link;
            }

            @Override
            public String getExplanation() {
                return explanation;
            }

            @Override
            public String getShortDescription() {
                return shortDescription;
            }
        };
    }

    public static void createIndex(File outputFile, Collection<IndexEntry> indexEntries, Options options, String[] nav1) throws IOException {
        if (options.splitIndex) {
            nav1 = Arrays.copyOf(nav1, nav1.length);
            int i = 1;
            while (i < nav1.length) {
                String href = nav1[i];
                if (href != AbstractRightFrameHtml.DISABLED && href != AbstractRightFrameHtml.HIGHLIT) {
                    nav1[i] = "../" + href;
                }
                i += 2;
            }
            IndexPages.createSplitIndex(new File(options.destination, "index-files"), indexEntries, options, nav1);
        } else {
            IndexPages.createSingleIndex(new File(options.destination, "index-all.html"), indexEntries, options, nav1);
        }
    }

    public static void createSingleIndex(File outputFile, Collection<IndexEntry> indexEntries, Options options, @Nullable String[] nav1) throws IOException {
        TreeMap<Character, Collection<IndexEntry>> entriesByInitial = new TreeMap<Character, Collection<IndexEntry>>();
        for (IndexEntry entry : indexEntries) {
            char initial = Character.toUpperCase(entry.getKey().charAt(0));
            ArrayList<IndexEntry> entriesOfInitial = (ArrayList<IndexEntry>)entriesByInitial.get(Character.valueOf(initial));
            if (entriesOfInitial == null) {
                entriesOfInitial = new ArrayList<IndexEntry>();
                entriesByInitial.put(Character.valueOf(initial), entriesOfInitial);
            }
            entriesOfInitial.add(entry);
        }
        String[] stringArray = new String[4];
        stringArray[0] = "Prev Letter";
        stringArray[2] = "Next Letter";
        IndexPages.createIndexFile(outputFile, "Index", options, new String[]{"stylesheet.css"}, nav1, stringArray, noTemplate -> {
            for (Character initial : entriesByInitial.keySet()) {
                noTemplate.l("      <a href=\"#" + initial.charValue() + "\">" + initial + "</a>");
            }
        }, entriesByInitial);
    }

    public static void createSplitIndex(File baseDirectory, Collection<IndexEntry> indexEntries, Options options, @Nullable String[] nav1) throws IOException {
        TreeMap<Character, ArrayList<IndexEntry>> entriesByInitial = new TreeMap<Character, ArrayList<IndexEntry>>();
        for (IndexEntry entry : indexEntries) {
            char initial = Character.toUpperCase(entry.getKey().charAt(0));
            ArrayList<IndexEntry> entriesOfInitial = (ArrayList<IndexEntry>)entriesByInitial.get(Character.valueOf(initial));
            if (entriesOfInitial == null) {
                entriesOfInitial = new ArrayList<IndexEntry>();
                entriesByInitial.put(Character.valueOf(initial), entriesOfInitial);
            }
            entriesOfInitial.add(entry);
        }
        int idx = 1;
        for (IterableUtil.ElementWithContext e : IterableUtil.iterableWithContext(entriesByInitial.entrySet())) {
            Map.Entry previousIndexPage = e.previous();
            Map.Entry indexEntry = e.current();
            Map.Entry nextIndexPage = e.next();
            Character initial = (Character)indexEntry.getKey();
            Collection entriesOfInitial = (Collection)indexEntry.getValue();
            IndexPages.createIndexFile(new File(baseDirectory, "index-" + idx + ".html"), initial + "-Index", options, new String[]{"../stylesheet.css"}, nav1, new String[]{"Prev Letter", previousIndexPage == null ? null : "index-" + (idx - 1) + ".html", "Next Letter", nextIndexPage == null ? null : "index-" + (idx + 1) + ".html"}, noTemplate -> {
                int idx2 = 1;
                for (Character initial2 : entriesByInitial.keySet()) {
                    noTemplate.l("      <a href=\"index-" + idx2++ + ".html\">" + initial2 + "</a>");
                }
            }, Collections.singletonMap(initial, entriesOfInitial));
            ++idx;
        }
    }

    private static void createIndexFile(final File outputFile, String windowTitle, final Options options, final String[] stylesheetLinks, final @Nullable String[] nav1, final @Nullable String[] nav2, final Consumer<? super NoTemplate> indexNavigation, final Map<Character, Collection<IndexEntry>> entriesByInitial) throws IOException {
        final String windowTitle2 = options.windowTitle == null ? windowTitle : String.valueOf(windowTitle) + " (" + options.windowTitle + ")";
        NoTemplate.render(AbstractRightFrameHtml.class, outputFile, new ConsumerWhichThrows<AbstractRightFrameHtml, RuntimeException>(){

            @Override
            public void consume(AbstractRightFrameHtml arfh) {
                arfh.rRightFrameHtml(windowTitle2, options, stylesheetLinks, nav1, nav2, new String[]{"Frames", String.valueOf(options.splitIndex ? "../index.html?index-files/" : "index.html?") + outputFile.getName(), "No Frames", outputFile.getName()}, new String[]{"All Classes", "allclasses-noframe.html"}, null, null, () -> {
                    arfh.l("    <div class=\"contentContainer\">");
                    indexNavigation.consume(arfh);
                    for (Map.Entry e : entriesByInitial.entrySet()) {
                        Character initial = (Character)e.getKey();
                        Collection entriesOfInitial = (Collection)e.getValue();
                        arfh.l("      <a name=\"" + initial.charValue() + "\" />", "      <h2 class=\"title\">" + initial + "</h2>", "      <dl>");
                        for (IndexEntry entry : entriesOfInitial) {
                            arfh.l("        <dt><span class=\"strong\"><a href=\"" + entry.getLink() + "\">" + entry.getKey() + "</a></span> - " + entry.getExplanation() + "</dt>", "        <dd><div class=\"block\">" + entry.getShortDescription() + "</div></dd>");
                        }
                        arfh.l("      </dl>");
                    }
                    indexNavigation.consume(arfh);
                    arfh.l("    </div");
                });
            }
        });
    }

    public static interface IndexEntry {
        public String getKey();

        public String getLink();

        public String getExplanation();

        public String getShortDescription();
    }
}

