/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.notemplate;

import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public abstract class NoTemplate {
    @Nullable
    private PrintWriter pw;

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    public static final <T extends NoTemplate, EX extends Exception> void render(Class<T> templateClass, File outputFile, ConsumerWhichThrows<? super T, EX> renderer) throws IOException, EX {
        NoTemplate.render(templateClass, outputFile, renderer, true);
    }

    public static final <T extends NoTemplate, EX extends Exception> void render(Class<T> templateClass, File outputFile, ConsumerWhichThrows<? super T, EX> renderer, boolean createMissingParentDirectories) throws IOException, EX {
        NoTemplate.render(templateClass, outputFile, renderer, createMissingParentDirectories, Charset.forName("UTF-8"));
    }

    public static final <T extends NoTemplate, EX extends Exception> void render(Class<T> templateClass, File outputFile, ConsumerWhichThrows<? super T, EX> renderer, boolean createMissingParentDirectories, Charset charset) throws IOException, EX {
        NoTemplate.render(templateClass, outputFile, renderer, createMissingParentDirectories, charset, false);
    }

    public static final <T extends NoTemplate, EX extends Exception> void render(final Class<T> templateClass, File outputFile, final ConsumerWhichThrows<? super T, EX> renderer, boolean createMissingParentDirectories, Charset charset, boolean quiet) throws IOException, EX {
        if (!quiet) {
            System.out.println("Generating " + outputFile + "...");
        }
        IoUtil.outputFilePrintWriter(outputFile, charset, new ConsumerWhichThrows<PrintWriter, EX>(){

            @Override
            public void consume(PrintWriter pw) throws Exception {
                renderer.consume(NoTemplate.newTemplate(templateClass, pw));
            }
        }, createMissingParentDirectories);
    }

    public static final <T extends NoTemplate> T newTemplate(Class<T> templateClass, Writer out) {
        NoTemplate template;
        try {
            template = (NoTemplate)templateClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (SecurityException se) {
            throw new IllegalArgumentException("Template class \"" + templateClass.getName() + "\" has no accessible zero-parameter constructor", se);
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Template class \"" + templateClass.getName() + "\" is abstract", ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Template class \"" + templateClass.getName() + "\" enforces Java language access control and the underlying constructor is inaccessible", iae);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("The zero-parameter constructor of template class \"" + templateClass.getName() + "\" threw an exception", ite);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Template class \"" + templateClass.getName() + "\" lacks the zero-parameter constructor", nsme);
        }
        if (!(out instanceof PrintWriter)) {
            out = new PrintWriter(out, true);
        }
        try {
            NoTemplate.class.getDeclaredField("pw").set(template, out);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return (T)template;
    }

    public static final <T extends NoTemplate> T newTemplate(Class<T> templateClass, OutputStream os) {
        return NoTemplate.newTemplate(templateClass, new OutputStreamWriter(os));
    }

    public static final <T extends NoTemplate> T newTemplate(Class<T> templateClass, OutputStream os, Charset cs) {
        return NoTemplate.newTemplate(templateClass, new OutputStreamWriter(os, cs));
    }

    public <C extends NoTemplate> C include(Class<C> templateClass) {
        assert (this.pw != null);
        return NoTemplate.newTemplate(templateClass, this.pw);
    }

    public static String html(String s) {
        s = s.replace("&", "&amp;");
        s = s.replace("<", "&lt;");
        s = s.replace(">", "&gt;");
        s = s.replace("\"", "&quot;");
        s = s.replace("'", "&apos;");
        return s;
    }

    public void l() {
        assert (this.pw != null);
        this.pw.println();
    }

    public void l(String line) {
        assert (this.pw != null);
        this.pw.println(line);
    }

    public void l(String ... lines) {
        assert (this.pw != null);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.pw.println(line);
            ++n2;
        }
    }

    public void p(String text) {
        assert (this.pw != null);
        this.pw.print(text);
    }

    public static Once once() {
        return new Once(){
            boolean done;

            @Override
            public boolean once() {
                if (!this.done) {
                    this.done = true;
                    return true;
                }
                return false;
            }
        };
    }

    public static interface Once {
        public boolean once();
    }
}

