/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.doclet.ant;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import de.unkrig.commons.doclet.Docs;
import de.unkrig.commons.doclet.Tags;
import de.unkrig.commons.doclet.html.Html;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.StringUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Longjump;
import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.text.xml.XmlUtil;
import de.unkrig.commons.util.collections.IterableUtil;
import de.unkrig.doclet.ant.templates.AllDefinitionsHtml;
import de.unkrig.doclet.ant.templates.IndexHtml;
import de.unkrig.doclet.ant.templates.OverviewSummaryHtml;
import de.unkrig.doclet.ant.templates.TypeHtml;
import de.unkrig.notemplate.NoTemplate;
import de.unkrig.notemplate.javadocish.Options;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AntDoclet {
    private static final String DEFAULTS_PROPERTIES_RESOURCE_NAME = "org/apache/tools/ant/taskdefs/defaults.properties";
    private static final Pattern ADD_TEXT_METHOD_NAME;
    private static final Pattern SET_ATTRIBUTE_METHOD_NAME;
    private static final Pattern ADD_METHOD_NAME;
    private static final Pattern ADD_SUBELEMENT_METHOD_NAME;
    private static final Pattern CREATE_SUBELEMENT_METHOD_NAME;
    private RootDoc rootDoc;
    private final Options options;
    private final Collection<String> antlibResources;
    private final Collection<File> antlibFiles;
    private final Map<String, URL> externalJavadocs;
    private final Theme theme;
    private final File[] sourcePath;
    private final File[] classPath;
    private final Mapping<ClassDoc, Html.Link> externalAntdocs;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        ADD_TEXT_METHOD_NAME = Pattern.compile("addText");
        SET_ATTRIBUTE_METHOD_NAME = Pattern.compile("set(?<attributeName>[A-Z]\\w*)");
        ADD_METHOD_NAME = Pattern.compile("add(?:Configured)?");
        ADD_SUBELEMENT_METHOD_NAME = Pattern.compile("add(?:Configured)?(?<subelementName>[A-Z]\\w*)");
        CREATE_SUBELEMENT_METHOD_NAME = Pattern.compile("create(?<subelementName>[A-Z]\\w*)");
    }

    public AntDoclet(RootDoc rootDoc, Options options, Collection<String> antlibResources, Collection<File> antlibFiles, Map<String, URL> externalJavadocs, Theme theme, File[] sourcePath, File[] classPath) throws IOException {
        ClassDoc cd;
        String qualifiedClassName;
        Properties properties;
        this.rootDoc = rootDoc;
        this.options = options;
        this.antlibResources = antlibResources;
        this.antlibFiles = antlibFiles;
        this.externalJavadocs = externalJavadocs;
        this.theme = theme;
        this.sourcePath = sourcePath;
        this.classPath = classPath;
        HashMap<ClassDoc, Html.Link> m = new HashMap<ClassDoc, Html.Link>();
        try {
            properties = this.loadPropertiesFromResource(String.valueOf(this.getClass().getPackage().getName().replace('.', '/')) + "/external-antdocs.properties");
        }
        catch (IOException ioe) {
            throw new AssertionError(null, ioe);
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String qualifiedClassName2 = (String)e.getKey();
            String tmp = (String)e.getValue();
            String label = tmp.substring(0, tmp.lastIndexOf(32)).trim();
            String href = tmp.substring(tmp.lastIndexOf(32) + 1).trim();
            ClassDoc cd2 = rootDoc.classNamed(qualifiedClassName2);
            if (cd2 == null) continue;
            m.put(cd2, new Html.Link(href, label));
        }
        try {
            properties = this.loadPropertiesFromResource(DEFAULTS_PROPERTIES_RESOURCE_NAME);
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Could not open resource \"org/apache/tools/ant/taskdefs/defaults.properties\"; make sure that \"ant.jar\" is on the doclet's classpath", ioe);
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String taskName = (String)e.getKey();
            qualifiedClassName = (String)e.getValue();
            cd = rootDoc.classNamed(qualifiedClassName);
            if (cd == null) continue;
            m.put(cd, new Html.Link("<code>&lt;" + taskName + "&gt;</code>", "http://ant.apache.org/manual/Tasks/" + taskName + ".html"));
        }
        try {
            properties = this.loadPropertiesFromResource("org/apache/tools/ant/types/defaults.properties");
        }
        catch (IOException ioe) {
            throw ExceptionUtil.wrap("Make sure that \"ant.jar\" is on the doclet's classpath", ioe);
        }
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            String typeName = (String)e.getKey();
            qualifiedClassName = (String)e.getValue();
            cd = rootDoc.classNamed(qualifiedClassName);
            if (cd == null) continue;
            m.put(cd, new Html.Link("<code>&lt;" + typeName + "&gt;</code>", "http://ant.apache.org/manual/Types/" + typeName + ".html"));
        }
        this.externalAntdocs = Mappings.fromMap(m);
    }

    private Properties loadPropertiesFromResource(String resourceName) throws IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        try {
            Properties properties = new Properties();
            properties.load(is);
            is.close();
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        if ("-d".equals(option)) {
            return 2;
        }
        if ("-splitindex".equals(option)) {
            return 2;
        }
        if ("-windowtitle".equals(option)) {
            return 2;
        }
        if ("-doctitle".equals(option)) {
            return 2;
        }
        if ("-header".equals(option)) {
            return 2;
        }
        if ("-footer".equals(option)) {
            return 2;
        }
        if ("-top".equals(option)) {
            return 2;
        }
        if ("-bottom".equals(option)) {
            return 2;
        }
        if ("-quiet".equals(option)) {
            return 1;
        }
        if ("-notimestamp".equals(option)) {
            return 1;
        }
        if ("-charset".equals(option)) {
            return 2;
        }
        if ("-docencoding".equals(option)) {
            return 2;
        }
        if ("-antlib-file".equals(option)) {
            return 2;
        }
        if ("-antlib-resource".equals(option)) {
            return 2;
        }
        if ("-link".equals(option)) {
            return 2;
        }
        if ("-linkoffline".equals(option)) {
            return 3;
        }
        if ("-theme".equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean start(RootDoc rootDoc) throws Exception {
        ArrayList<File> antlibFiles = new ArrayList<File>();
        ArrayList<String> antlibResources = new ArrayList<String>();
        HashMap<String, URL> externalJavadocs = new HashMap<String, URL>();
        Theme theme = Theme.JAVA8;
        File[] sourcePath = new File[]{new File(".")};
        File[] classPath = new File[]{};
        Options options = new Options();
        options.generator = "the ANT doclet http://doclet.unkrig.de";
        String[][] stringArray = rootDoc.options();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String externalDocumentationUrl;
            String[] option = stringArray[n2];
            if ("-d".equals(option[0])) {
                options.destination = new File(option[1]);
            } else if ("-splitindex".equals(option[0])) {
                options.splitIndex = true;
            } else if ("-windowtitle".equals(option[0])) {
                options.windowTitle = option[1];
            } else if ("-doctitle".equals(option[0])) {
                options.docTitle = option[1];
            } else if ("-header".equals(option[0])) {
                options.header = option[1];
            } else if ("-footer".equals(option[0])) {
                options.footer = option[1];
            } else if ("-top".equals(option[0])) {
                options.top = option[1];
            } else if ("-bottom".equals(option[0])) {
                options.bottom = option[1];
            } else if ("-quiet".equals(option[0])) {
                options.quiet = true;
            } else if ("-notimestamp".equals(option[0])) {
                options.noTimestamp = true;
            } else if ("-charset".equals(option[0])) {
                options.htmlCharset = option[1];
            } else if ("-docencoding".equals(option[0])) {
                options.documentCharset = Charset.forName(option[1]);
            } else if ("-antlib-file".equals(option[0])) {
                antlibFiles.add(new File(option[1]));
            } else if ("-antlib-resource".equals(option[0])) {
                antlibResources.add(option[1]);
            } else if ("-link".equals(option[0])) {
                externalDocumentationUrl = option[1];
                if (!externalDocumentationUrl.endsWith("/")) {
                    externalDocumentationUrl = String.valueOf(externalDocumentationUrl) + "/";
                }
                URL externalDocumentationUrl2 = new URL(new URL("file", null, -1, options.destination.toString()), externalDocumentationUrl);
                Docs.readExternalJavadocs(externalDocumentationUrl2, externalDocumentationUrl2, externalJavadocs, rootDoc);
            } else if ("-linkoffline".equals(option[0])) {
                externalDocumentationUrl = option[1];
                String packageListLocation = option[2];
                if (!externalDocumentationUrl.endsWith("/")) {
                    externalDocumentationUrl = String.valueOf(externalDocumentationUrl) + "/";
                }
                if (!packageListLocation.endsWith("/")) {
                    packageListLocation = String.valueOf(packageListLocation) + "/";
                }
                URL externalDocumentationUrl2 = new URL(new URL("file", null, -1, options.destination.toString()), externalDocumentationUrl);
                URL packageListUrl = packageListLocation.startsWith("http:") || packageListLocation.startsWith("file:") ? new URL(new URL("file", null, -1, System.getProperty("user.dir")), packageListLocation) : new URL("file", null, String.valueOf(new File(packageListLocation).getAbsolutePath()) + '/');
                Docs.readExternalJavadocs(externalDocumentationUrl2, packageListUrl, externalJavadocs, rootDoc);
            } else if ("-theme".equals(option[0])) {
                theme = Theme.valueOf(option[1]);
            } else if ("-sourcepath".equals(option[0]) && option.length == 2) {
                sourcePath = AntDoclet.parsePath(option[1]);
            } else if ("-classpath".equals(option[0]) && option.length == 2) {
                classPath = AntDoclet.parsePath(option[1]);
            }
            ++n2;
        }
        if (antlibResources.isEmpty() && antlibFiles.isEmpty()) {
            rootDoc.printWarning("Neither \"-antlib-resource\" nor \"-antlib-file\" option given");
        }
        new AntDoclet(rootDoc, options, antlibResources, antlibFiles, externalJavadocs, theme, sourcePath, classPath).start2();
        return true;
    }

    private static File[] parsePath(String s) {
        String[] sa = s.split(Pattern.quote(File.pathSeparator));
        File[] result = new File[sa.length];
        int i = 0;
        while (i < sa.length) {
            result[i] = new File(sa[i]);
            ++i;
        }
        return result;
    }

    void start2() throws Exception {
        switch (this.theme) {
            case JAVA7: {
                String resourceNamePrefix = "de/unkrig/doclet/ant/theme/java7/";
                String[] stringArray = new String[]{"stylesheet.css", "resources/background.gif", "resources/tab.gif", "resources/titlebar_end.gif", "resources/titlebar.gif"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String resourceNameSuffix = stringArray[n2];
                    File file = new File(this.options.destination, resourceNameSuffix);
                    IoUtil.copyResource(AntDoclet.class.getClassLoader(), String.valueOf(resourceNamePrefix) + resourceNameSuffix, file, true);
                    ++n2;
                }
                break;
            }
            case JAVA8: {
                IoUtil.copyResource(AntDoclet.class.getClassLoader(), "de/unkrig/doclet/ant/theme/java8/stylesheet.css", new File(this.options.destination, "stylesheet.css"), true);
            }
        }
        IoUtil.copyResource(AntDoclet.class.getClassLoader(), "de/unkrig/doclet/ant/templates/stylesheet2.css", new File(this.options.destination, "stylesheet2.css"), true);
        NoTemplate.render(IndexHtml.class, new File(this.options.destination, "index.html"), indexHtml -> indexHtml.render(this.options), true, this.options.documentCharset, this.options.quiet);
        final LinkedHashMap<ClassDoc, AntTypeGroup> antTypeGroups = new LinkedHashMap<ClassDoc, AntTypeGroup>();
        antTypeGroups.put(this.rootDoc.classNamed("org.apache.tools.ant.Task"), new AntTypeGroup("tasks", "Task", "Tasks", "Task \"&lt;{0}&gt;\"", "<code>&lt;{0}&gt;</code>"));
        antTypeGroups.put(this.rootDoc.classNamed("org.apache.tools.ant.types.ResourceCollection"), new AntTypeGroup("resourceCollections", "Resource collection", "Resource collections", "Resource collection \"&lt;{0}&gt;\"", "<code>&lt;{0}&gt;</code>"));
        antTypeGroups.put(this.rootDoc.classNamed("org.apache.tools.ant.filters.ChainableReader"), new AntTypeGroup("chainableReaders", "Chainable reader", "Chainable readers", "Chainable reader \"&lt;{0}&gt;\"", "<code>&lt;{0}&gt;</code>"));
        antTypeGroups.put(this.rootDoc.classNamed("org.apache.tools.ant.taskdefs.condition.Condition"), new AntTypeGroup("conditions", "Condition", "Conditions", "Condition \"&lt;{0}&gt;\"", "<code>&lt;{0}&gt;</code>"));
        antTypeGroups.put(null, new AntTypeGroup("otherTypes", "Other type", "Other types", "Type \"&lt;{0}&gt;\"", "<code>&lt;{0}&gt;</code>"));
        for (String antlibResource : this.antlibResources) {
            try {
                this.parseAntlibResource(antlibResource, antTypeGroups);
            }
            catch (Longjump longjump) {
                // empty catch block
            }
        }
        for (File antlibFile : this.antlibFiles) {
            this.parseAntlibFile(antlibFile, antTypeGroups);
        }
        for (final AntTypeGroup typeGroup : antTypeGroups.values()) {
            for (final IterableUtil.ElementWithContext elementWithContext : IterableUtil.iterableWithContext(typeGroup.types)) {
                AntType antType = (AntType)elementWithContext.current();
                URL docFilesLocation = IoUtil.findOnPath(this.sourcePath, String.valueOf(antType.classDoc.containingPackage().name().replace('.', '/')) + "/doc-files");
                if (docFilesLocation != null) {
                    File destinationFolder = new File(this.options.destination, String.valueOf(typeGroup.subdir) + "/doc-files");
                    IoUtil.createMissingParentDirectoriesFor(destinationFolder);
                    IoUtil.copyTree(docFilesLocation, destinationFolder, IoUtil.CollisionStrategy.IO_EXCEPTION_IF_DIFFERENT);
                }
                final Html html = new Html(new Html.ExternalJavadocsLinkMaker(this.externalJavadocs, this.linkMaker(antType, typeGroup, antTypeGroups, this.rootDoc)));
                NoTemplate.render(TypeHtml.class, new File(this.options.destination, String.valueOf(typeGroup.subdir) + '/' + antType.name + ".html"), new ConsumerWhichThrows<TypeHtml, RuntimeException>(){

                    @Override
                    public void consume(TypeHtml typeHtml) throws RuntimeException {
                        typeHtml.render(typeGroup, antTypeGroups.values(), elementWithContext, html, AntDoclet.this.rootDoc, AntDoclet.this.options);
                    }
                }, true, this.options.documentCharset, this.options.quiet);
            }
        }
        Html.LinkMaker linkMaker = this.linkMaker(null, null, antTypeGroups, this.rootDoc);
        Html html = new Html(new Html.ExternalJavadocsLinkMaker(this.externalJavadocs, linkMaker));
        NoTemplate.render(AllDefinitionsHtml.class, new File(this.options.destination, "alldefinitions-frame.html"), allDefinitionsHtml -> allDefinitionsHtml.render(antTypeGroups.values(), this.rootDoc, this.options, html, "classFrame"), true, this.options.documentCharset, this.options.quiet);
        NoTemplate.render(AllDefinitionsHtml.class, new File(this.options.destination, "alldefinitions-noframe.html"), allDefinitionsHtml -> allDefinitionsHtml.render(antTypeGroups.values(), this.rootDoc, this.options, html, null), true, this.options.documentCharset, this.options.quiet);
        NoTemplate.render(OverviewSummaryHtml.class, new File(this.options.destination, "overview-summary.html"), overviewSummaryHtml -> overviewSummaryHtml.render(antTypeGroups.values(), this.rootDoc, this.options, html), true, this.options.documentCharset, this.options.quiet);
        IoUtil.outputFile(new File(this.options.destination, "package-list"), f -> {
            boolean bl = f.createNewFile();
        }, true);
    }

    private void parseAntlibResource(String antlibResourceName, Map<ClassDoc, AntTypeGroup> result) throws Exception, Longjump {
        URL antlibLocation = IoUtil.findOnPath(this.sourcePath, antlibResourceName);
        if (antlibLocation == null && (antlibLocation = IoUtil.findOnPath(this.classPath, antlibResourceName)) == null) {
            this.rootDoc.printError("Antlib resource \"" + antlibResourceName + "\" not found on the source path (" + Arrays.toString(this.sourcePath) + ") and the class path (" + Arrays.toString(this.classPath) + ")");
            throw new Longjump();
        }
        this.parseAntlibStream(antlibLocation.openStream(), antlibLocation.toString(), result);
    }

    private void parseAntlibFile(File antlibFile, Map<ClassDoc, AntTypeGroup> result) throws Exception {
        Document document = XmlUtil.parse(DocumentBuilderFactory.newInstance().newDocumentBuilder(), antlibFile, null);
        this.parseAntlibDocument(document, result);
    }

    private void parseAntlibStream(InputStream antlibStream, @Nullable String publicId, Map<ClassDoc, AntTypeGroup> result) throws Exception {
        InputSource inputSource = new InputSource(antlibStream);
        inputSource.setPublicId(publicId);
        Document document = XmlUtil.parse(DocumentBuilderFactory.newInstance().newDocumentBuilder(), inputSource);
        this.parseAntlibDocument(document, result);
    }

    private void parseAntlibDocument(Document document, Map<ClassDoc, AntTypeGroup> result) throws Exception {
        document.getDocumentElement().normalize();
        for (Element typedefElement : IterableUtil.concat(AntDoclet.nl2i(document.getElementsByTagName("taskdef")), AntDoclet.nl2i(document.getElementsByTagName("typedef")), AntDoclet.nl2i(document.getElementsByTagName("componentdef")))) {
            try {
                this.parseTypedef(typedefElement, this.sourcePath, this.classPath, this.rootDoc, result);
            }
            catch (Longjump longjump) {
                // empty catch block
            }
        }
        if (document.getElementsByTagName("macrodef").getLength() > 0) {
            this.rootDoc.printWarning("<macrodef>s are not yet supported");
        }
        if (document.getElementsByTagName("presetdef").getLength() > 0) {
            this.rootDoc.printWarning("<presetdef>s are not yet supported");
        }
        if (document.getElementsByTagName("scriptdef").getLength() > 0) {
            this.rootDoc.printWarning("<scriptdef>s are not yet supported");
        }
    }

    private void parseTypedef(Element typedefElement, @Nullable File[] sourcePath, @Nullable File[] classPath, RootDoc rootDoc, Map<ClassDoc, AntTypeGroup> result) throws Exception, Longjump {
        block11: {
            block13: {
                AntType antType;
                block14: {
                    ClassDoc adaptTo;
                    String fileAttribute;
                    String resourceAttribute;
                    String adaptToAttribute;
                    String classnameAttribute;
                    String nameAttribute;
                    block12: {
                        block10: {
                            nameAttribute = AntDoclet.getOptionalAttribute(typedefElement, "name");
                            classnameAttribute = AntDoclet.getOptionalAttribute(typedefElement, "classname");
                            adaptToAttribute = AntDoclet.getOptionalAttribute(typedefElement, "adaptTo");
                            resourceAttribute = AntDoclet.getOptionalAttribute(typedefElement, "resource");
                            fileAttribute = AntDoclet.getOptionalAttribute(typedefElement, "file");
                            if (nameAttribute != null || classnameAttribute != null || adaptToAttribute != null || resourceAttribute == null || fileAttribute != null) break block10;
                            this.parseAntlibResource(resourceAttribute, result);
                            break block11;
                        }
                        if (nameAttribute != null || classnameAttribute != null || adaptToAttribute != null || resourceAttribute != null || fileAttribute == null) break block12;
                        this.parseAntlibFile(new File(fileAttribute), result);
                        break block11;
                    }
                    if (nameAttribute == null || classnameAttribute == null || resourceAttribute != null || fileAttribute != null) break block13;
                    ClassDoc classDoc = rootDoc.classNamed(classnameAttribute);
                    if (classDoc == null) {
                        rootDoc.printError("Class '" + classnameAttribute + "' not found for  <" + nameAttribute + ">");
                        throw new Longjump();
                    }
                    if (adaptToAttribute == null) {
                        adaptTo = null;
                    } else {
                        adaptTo = rootDoc.classNamed(adaptToAttribute);
                        if (adaptTo == null) {
                            rootDoc.printError("Class '" + adaptToAttribute + "' not found for <" + nameAttribute + ">");
                            throw new Longjump();
                        }
                    }
                    antType = new AntType(nameAttribute, classDoc, adaptTo, AntDoclet.characterDataOf(classDoc), AntDoclet.attributesOf(classDoc, rootDoc), AntDoclet.subelementsOf(classDoc, rootDoc));
                    if (!typedefElement.getTagName().equals("taskdef")) break block14;
                    result.get((Object)rootDoc.classNamed((String)"org.apache.tools.ant.Task")).types.add(antType);
                    break block11;
                }
                boolean hadOneTypeGroup = false;
                ClassDoc[] classDocArray = Docs.withSuperclassesAndInterfaces(antType.classDoc);
                int n = classDocArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block16: {
                        AntTypeGroup atg;
                        block15: {
                            ClassDoc cd = classDocArray[n2];
                            atg = result.get(cd);
                            if (atg != null) break block15;
                            Tag typeGroupSubdirTag = Tags.optionalTag((Doc)cd, "@ant.typeGroupSubdir", (DocErrorReporter)rootDoc);
                            if (typeGroupSubdirTag == null) break block16;
                            String typeGroupSubdir = typeGroupSubdirTag.text();
                            String typeGroupName = Tags.requiredTag((Doc)cd, "@ant.typeGroupName", (DocErrorReporter)rootDoc).text();
                            String typeGroupHeading = Tags.requiredTag((Doc)cd, "@ant.typeGroupHeading", (DocErrorReporter)rootDoc).text();
                            String typeTitleMf = Tags.requiredTag((Doc)cd, "@ant.typeTitleMf", (DocErrorReporter)rootDoc).text();
                            String typeHeadingMf = Tags.requiredTag((Doc)cd, "@ant.typeHeadingMf", (DocErrorReporter)rootDoc).text();
                            atg = new AntTypeGroup(typeGroupSubdir, typeGroupName, typeGroupHeading, typeTitleMf, typeHeadingMf);
                            result.put(cd, atg);
                        }
                        atg.types.add(antType);
                        hadOneTypeGroup = true;
                    }
                    ++n2;
                }
                if (!hadOneTypeGroup) {
                    result.get(null).types.add(antType);
                }
                break block11;
            }
            rootDoc.printError("Invalid combination of attributes");
            throw new Longjump();
        }
    }

    @Nullable
    private static String getOptionalAttribute(Element element, String attributeName) {
        String result = element.getAttribute(attributeName);
        return result.length() == 0 ? null : result;
    }

    private Html.LinkMaker linkMaker(final @Nullable AntType antType, final @Nullable AntTypeGroup typeGroup, final Map<ClassDoc, AntTypeGroup> antTypeGroups, RootDoc rootDoc) {
        return new Html.LinkMaker(){

            @Override
            public Html.Link makeLink(Doc from, Doc to, RootDoc rootDoc) throws Longjump {
                if (to instanceof ClassDoc) {
                    AntTypeGroup atg2;
                    ClassDoc toClass = (ClassDoc)to;
                    for (AntTypeGroup atg2 : antTypeGroups.values()) {
                        for (AntType t : atg2.types) {
                            if (toClass != t.classDoc) continue;
                            return new Html.Link(antType == null ? String.valueOf(atg2.subdir) + '/' + t.name + ".html" : (atg2 == typeGroup ? String.valueOf(t.name) + ".html" : "../" + atg2.subdir + '/' + t.name + ".html"), "&lt;" + t.name + "&gt;");
                        }
                    }
                    Html.Link link = (Html.Link)AntDoclet.this.externalAntdocs.get(to);
                    if (link != null) {
                        return new Html.Link(link.href, StringUtil.firstLetterToUpperCase(link.defaultLabelHtml));
                    }
                    if (antType != null) {
                        for (AntSubelement se : antType.subelements) {
                            if (toClass != se.type) continue;
                            if (se.name != null) {
                                return new Html.Link("#" + toClass.qualifiedName() + "_subelement_detail", "<code>&lt;" + se.name + "&gt;</code>");
                            }
                            AntTypeGroup atg3 = (AntTypeGroup)antTypeGroups.get(toClass);
                            if (atg3 == null) continue;
                            return new Html.Link("../overview-summary.html#" + atg3.subdir, "Any " + atg3.name);
                        }
                    }
                    if ((atg2 = (AntTypeGroup)antTypeGroups.get(toClass)) != null) {
                        return new Html.Link("../overview-summary.html#" + atg2.subdir, "Any " + atg2.name);
                    }
                    rootDoc.printError(from.position(), "'" + to + "' does not designate a type");
                    throw new Longjump();
                }
                if (to instanceof MethodDoc) {
                    MethodDoc toMethod = (MethodDoc)to;
                    ClassDoc toClass = toMethod.containingClass();
                    if (antType != null) {
                        for (AntAttribute a : antType.attributes) {
                            if (a.methodDoc != toMethod) continue;
                            return new Html.Link(String.valueOf('#') + a.name + "_attribute_detail", String.valueOf(a.name) + "=\"...\"");
                        }
                    }
                    for (AntTypeGroup tg : antTypeGroups.values()) {
                        for (AntType t : tg.types) {
                            String fragment;
                            if (toMethod == t.characterData) {
                                String fragment2 = "#text_summary";
                                return new Html.Link(antType == null ? String.valueOf(tg.subdir) + '/' + t.name + fragment2 : (toClass == antType.classDoc ? fragment2 : (typeGroup == tg ? String.valueOf(t.name) + fragment2 : "../" + tg.subdir + '/' + t.name + fragment2)), "(text between start and end tag)");
                            }
                            for (AntAttribute a : t.attributes) {
                                if (a.methodDoc != toMethod) continue;
                                fragment = String.valueOf('#') + a.name + "_attribute_detail";
                                return new Html.Link(antType == null ? String.valueOf(tg.subdir) + '/' + t.name + ".html" + fragment : (toClass == antType.classDoc ? fragment : (typeGroup == tg ? String.valueOf(t.name) + ".html" + fragment : "../" + tg.subdir + '/' + t.name + ".html" + fragment)), String.valueOf(a.name) + "=\"...\"");
                            }
                            for (AntSubelement se : t.subelements) {
                                if (se.methodDoc != toMethod) continue;
                                fragment = String.valueOf('#') + (se.name != null ? se.name : se.type.asClassDoc().qualifiedName()) + "_subelement_detail";
                                String label = se.name;
                                if (label != null) {
                                    label = "&lt;" + se.name + "&gt;";
                                } else {
                                    AntTypeGroup atg = (AntTypeGroup)antTypeGroups.get(se.type.asClassDoc());
                                    String string = label = atg != null ? "Any " + atg.name : "???";
                                }
                                return new Html.Link(antType == null ? String.valueOf(tg.subdir) + '/' + t.name + ".html" + fragment : (toMethod.containingClass() == antType.classDoc ? fragment : (typeGroup == tg ? String.valueOf(antType.name) + ".html" + fragment : "../" + tg.subdir + '/' + antType.name + ".html" + fragment)), label);
                            }
                            for (AntSubelement se : t.subelements) {
                                Parameter[] params = se.methodDoc.parameters();
                                if (params.length != 1) continue;
                                MethodDoc[] methodDocArray = Docs.methods(params[0].type().asClassDoc(), false, true);
                                int n = methodDocArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MethodDoc md = methodDocArray[n2];
                                    if (md == toMethod) {
                                        String fragment3 = String.valueOf('#') + md.containingClass().qualifiedName() + "/" + md.name();
                                        return new Html.Link(antType == null ? String.valueOf(tg.subdir) + '/' + t.name + ".html" + fragment3 : (toClass == antType.classDoc ? fragment3 : (typeGroup == tg ? String.valueOf(t.name) + ".html" + fragment3 : "../" + tg.subdir + '/' + t.name + ".html" + fragment3)), String.valueOf(md.name()) + "=\"...\"");
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                    rootDoc.printWarning(from.position(), "Linking from '" + from + "' to '" + to + "': '" + toMethod + "' is not an attribute setter nor a subelement adder/creator");
                    return new Html.Link(null, to.name());
                }
                return new Html.Link(null, to.name());
            }
        };
    }

    private static <N extends Node> Iterable<N> nl2i(final NodeList nodeList) {
        return new Iterable<N>(){

            @Override
            public Iterator<N> iterator() {
                return new Iterator<N>(){
                    int idx;

                    @Override
                    public boolean hasNext() {
                        return this.idx < nodeList.getLength();
                    }

                    @Override
                    public N next() {
                        if (this.idx >= nodeList.getLength()) {
                            throw new NoSuchElementException();
                        }
                        Node result = nodeList.item(this.idx++);
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    @Nullable
    public static MethodDoc characterDataOf(ClassDoc classDoc) {
        MethodDoc[] methodDocArray = Docs.methods(classDoc, true, true);
        int n = methodDocArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDoc md = methodDocArray[n2];
            String methodName = md.name();
            Parameter[] methodParameters = md.parameters();
            if (ADD_TEXT_METHOD_NAME.matcher(methodName).matches() && methodParameters.length == 1 && "java.lang.String".equals(methodParameters[0].type().qualifiedTypeName())) {
                return md;
            }
            ++n2;
        }
        return null;
    }

    public static List<AntAttribute> attributesOf(ClassDoc classDoc, RootDoc rootDoc) {
        ArrayList<AntAttribute> attributes = new ArrayList<AntAttribute>();
        MethodDoc[] methodDocArray = Docs.methods(classDoc, true, true);
        int n = methodDocArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                MethodDoc md = methodDocArray[n2];
                if (md.isPublic() && !"setProject".equals(md.name())) {
                    String methodName = md.name();
                    Parameter[] methodParameters = md.parameters();
                    Matcher m = SET_ATTRIBUTE_METHOD_NAME.matcher(methodName);
                    if (m.matches() && methodParameters.length == 1) {
                        String name = Notations.fromCamelCase(m.group("attributeName")).toLowerCamelCase();
                        Type type = methodParameters[0].type();
                        Iterator it = attributes.iterator();
                        while (it.hasNext()) {
                            AntAttribute a = (AntAttribute)it.next();
                            if (!a.name.equals(name) || a.type != type) continue;
                            if (md.inlineTags().length > 0 && a.methodDoc.inlineTags().length == 0) {
                                it.remove();
                                break;
                            }
                            break block5;
                        }
                        Tag groupTag = Tags.optionalTag((Doc)md, "@ant.group", (DocErrorReporter)rootDoc);
                        attributes.add(new AntAttribute(name, md, type, groupTag == null ? null : groupTag.text()));
                    }
                }
            }
            ++n2;
        }
        return attributes;
    }

    public static List<AntSubelement> subelementsOf(ClassDoc classDoc, RootDoc rootDoc) {
        ArrayList<AntSubelement> subelements = new ArrayList<AntSubelement>();
        MethodDoc[] methodDocArray = Docs.methods(classDoc, true, true);
        int n = methodDocArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Type type;
                String name;
                MethodDoc md;
                block11: {
                    Matcher m;
                    Parameter[] methodParameters;
                    String methodName;
                    block12: {
                        block10: {
                            md = methodDocArray[n2];
                            methodName = md.name();
                            methodParameters = md.parameters();
                            m = CREATE_SUBELEMENT_METHOD_NAME.matcher(methodName);
                            if (!m.matches() || methodParameters.length != 0) break block10;
                            name = Notations.fromCamelCase(m.group("subelementName")).toLowerCamelCase();
                            type = md.returnType();
                            break block11;
                        }
                        m = ADD_METHOD_NAME.matcher(methodName);
                        if (!m.matches() || methodParameters.length != 1) break block12;
                        name = null;
                        type = methodParameters[0].type();
                        break block11;
                    }
                    m = ADD_SUBELEMENT_METHOD_NAME.matcher(methodName);
                    if (!m.matches() || ADD_TEXT_METHOD_NAME.matcher(methodName).matches() || methodParameters.length != 1) break block9;
                    name = Notations.fromCamelCase(m.group("subelementName")).toLowerCamelCase();
                    type = methodParameters[0].type();
                }
                Iterator it = subelements.iterator();
                while (it.hasNext()) {
                    AntSubelement as = (AntSubelement)it.next();
                    if (!ObjectUtil.equals(as.name, name) || as.type != type) continue;
                    if (md.tags().length != 0) {
                        if (as.methodDoc.inlineTags().length != 0) continue;
                        it.remove();
                        break;
                    }
                    break block9;
                }
                Tag groupTag = Tags.optionalTag((Doc)md, "@ant.group", (DocErrorReporter)rootDoc);
                subelements.add(new AntSubelement(md, name, type, groupTag == null ? null : groupTag.text()));
            }
            ++n2;
        }
        Tag sot = Tags.optionalTag((Doc)classDoc, "@ant.subelementOrder", (DocErrorReporter)rootDoc);
        if (sot != null && "inheritedFirst".equals(sot.text())) {
            ArrayList<AntSubelement> tmp1 = new ArrayList<AntSubelement>();
            ArrayList<AntSubelement> tmp2 = new ArrayList<AntSubelement>();
            for (AntSubelement se : subelements) {
                if (se.methodDoc.containingClass() == classDoc) {
                    tmp1.add(se);
                    continue;
                }
                tmp2.add(se);
            }
            subelements.clear();
            subelements.addAll(tmp2);
            subelements.addAll(tmp1);
        }
        return subelements;
    }

    public static final class AntAttribute {
        public final String name;
        public final MethodDoc methodDoc;
        public final Type type;
        @Nullable
        public final String group;

        public AntAttribute(String name, MethodDoc methodDoc, Type type, @Nullable String group) {
            this.name = name;
            this.methodDoc = methodDoc;
            this.type = type;
            this.group = group;
        }

        public String toString() {
            return String.valueOf(this.name) + "=" + this.type;
        }
    }

    public static final class AntSubelement {
        public final MethodDoc methodDoc;
        @Nullable
        public final String name;
        public final Type type;
        @Nullable
        public final String group;

        public AntSubelement(MethodDoc methodDoc, @Nullable String name, Type type, @Nullable String group) {
            this.methodDoc = methodDoc;
            this.name = name;
            this.type = type;
            this.group = group;
        }
    }

    public static final class AntType {
        public final String name;
        public final ClassDoc classDoc;
        @Nullable
        private ClassDoc adaptTo;
        @Nullable
        public final MethodDoc characterData;
        public final List<AntAttribute> attributes;
        public final List<AntSubelement> subelements;

        public AntType(String name, ClassDoc classDoc, @Nullable ClassDoc adaptTo, @Nullable MethodDoc characterData, List<AntAttribute> attributes, List<AntSubelement> subelements) {
            this.name = name;
            this.classDoc = classDoc;
            this.adaptTo = adaptTo;
            this.characterData = characterData;
            this.attributes = attributes;
            this.subelements = subelements;
        }

        public String toString() {
            return "<" + this.name + " " + this.attributes + ">";
        }
    }

    public static final class AntTypeGroup {
        public final String subdir;
        public final String name;
        public final String heading;
        public final MessageFormat typeTitleMf;
        public final MessageFormat typeHeadingMf;
        public final List<AntType> types = new ArrayList<AntType>();

        public AntTypeGroup(String subdir, String name, String heading, String typeTitleMf, String typeHeadingMf) {
            this.subdir = subdir;
            this.name = name;
            this.heading = heading;
            this.typeTitleMf = new MessageFormat(typeTitleMf);
            this.typeHeadingMf = new MessageFormat(typeHeadingMf);
        }

        public String toString() {
            return this.subdir;
        }
    }

    private static enum Theme {
        JAVA7,
        JAVA8;

    }
}

