/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.time;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.time.Duration;
import de.unkrig.commons.util.time.PointOfTime;

public final class TimeInterval {
    @Nullable
    private PointOfTime beginning;
    @Nullable
    private Duration duration;
    @Nullable
    private PointOfTime ending;

    public TimeInterval(TimeInterval other) {
        this.beginning = other.beginning;
        this.duration = other.duration;
        this.ending = other.ending;
    }

    public TimeInterval() {
    }

    public TimeInterval setBeginning(@Nullable PointOfTime beginning) {
        this.beginning = beginning;
        this.checkConsistency();
        return this;
    }

    public TimeInterval setDuration(@Nullable Duration duration) {
        this.duration = duration;
        this.checkConsistency();
        return this;
    }

    public TimeInterval setEnding(@Nullable PointOfTime ending) {
        this.ending = ending;
        this.checkConsistency();
        return this;
    }

    @Nullable
    public PointOfTime getBeginning() {
        PointOfTime beginning = this.beginning;
        Duration duration = this.duration;
        PointOfTime ending = this.ending;
        return beginning == null && duration != null && ending != null ? new PointOfTime(ending.milliseconds() - duration.milliseconds()) : this.beginning;
    }

    @Nullable
    public Duration getDuration() {
        PointOfTime beginning = this.beginning;
        Duration duration = this.duration;
        PointOfTime ending = this.ending;
        return beginning != null && duration == null && ending != null ? new Duration(ending.milliseconds() - beginning.milliseconds()) : this.duration;
    }

    @Nullable
    public PointOfTime getEnding() {
        PointOfTime beginning = this.beginning;
        Duration duration = this.duration;
        PointOfTime ending = this.ending;
        return beginning != null && duration != null && ending == null ? new PointOfTime(beginning.milliseconds() + duration.milliseconds()) : this.ending;
    }

    private void checkConsistency() {
        PointOfTime beginning = this.beginning;
        Duration duration = this.duration;
        PointOfTime ending = this.ending;
        if (beginning != null && duration != null && ending != null && beginning.milliseconds() + duration.milliseconds() != ending.milliseconds()) {
            throw new IllegalStateException();
        }
    }
}

