/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class Printers {
    public static final AbstractPrinter DEFAULT_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void warn(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void info(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void verbose(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void debug(@Nullable String message) {
            System.out.println(message);
        }
    };
    public static final AbstractPrinter NORMAL_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void warn(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void info(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void verbose(@Nullable String message) {
        }

        @Override
        public void debug(@Nullable String message) {
        }
    };
    public static final AbstractPrinter MUTE_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
        }

        @Override
        public void warn(@Nullable String message) {
        }

        @Override
        public void info(@Nullable String message) {
        }

        @Override
        public void verbose(@Nullable String message) {
        }

        @Override
        public void debug(@Nullable String message) {
        }
    };

    private Printers() {
    }

    @Deprecated
    public static Printer get() {
        return AbstractPrinter.getContextPrinter();
    }

    public static void error(@Nullable String message) {
        Printers.get().error(message);
    }

    public static void error(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().error(pattern, arguments);
    }

    public static void error(@Nullable String message, Throwable t) {
        AbstractPrinter.getContextPrinter().error(message, t);
    }

    public static void error(String pattern, Throwable t, Object ... arguments) {
        AbstractPrinter.getContextPrinter().error(pattern, t, arguments);
    }

    public static void warn(@Nullable String message) {
        AbstractPrinter.getContextPrinter().warn(message);
    }

    public static void warn(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().warn(pattern, arguments);
    }

    public static void info(@Nullable String message) {
        AbstractPrinter.getContextPrinter().info(message);
    }

    public static void info(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().info(pattern, arguments);
    }

    public static void verbose(@Nullable String message) {
        AbstractPrinter.getContextPrinter().verbose(message);
    }

    public static void verbose(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().verbose(pattern, arguments);
    }

    public static void debug(@Nullable String message) {
        AbstractPrinter.getContextPrinter().debug(message);
    }

    public static void debug(String pattern, Object ... arguments) {
        AbstractPrinter.getContextPrinter().debug(pattern, arguments);
    }

    @Deprecated
    public static synchronized void withPrinter(Printer printer, Runnable runnable) {
        AbstractPrinter ap = printer instanceof AbstractPrinter ? (AbstractPrinter)printer : AbstractPrinter.fromPrinter(printer);
        ap.run(runnable);
    }

    @Deprecated
    public static synchronized <EX extends Throwable> void withPrinter(Printer printer, RunnableWhichThrows<EX> runnable) throws EX {
        AbstractPrinter ap = printer instanceof AbstractPrinter ? (AbstractPrinter)printer : AbstractPrinter.fromPrinter(printer);
        ap.run(runnable);
    }

    public static <EX extends Throwable> void redirectInfoToFile(@Nullable File file, RunnableWhichThrows<EX> runnable) throws IOException, EX {
        if (file == null) {
            runnable.run();
            return;
        }
        PrintWriter pw = new PrintWriter(file);
        try {
            AbstractPrinter.getContextPrinter().run(runnable);
            pw.close();
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public static <EX extends Throwable> void redirectInfo(@Nullable Writer writer, RunnableWhichThrows<EX> runnable) throws EX {
        AbstractPrinter.getContextPrinter().redirectInfo(writer).run(runnable);
    }

    public static <EX extends Throwable> void redirectInfo(@Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> infoConsumer, RunnableWhichThrows<? extends EX> runnable) throws EX {
        AbstractPrinter.getContextPrinter().redirectInfo(infoConsumer).run(runnable);
    }
}

