/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNull;
import java.util.HashMap;
import java.util.WeakHashMap;

public final class TransformerUtil {
    private static final Transformer IDENTITY;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        IDENTITY = new Transformer(){

            public Object transform(Object in) {
                return in;
            }
        };
    }

    private TransformerUtil() {
    }

    public static <O, I extends O> Transformer<I, O> identity() {
        return IDENTITY;
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> asTransformerWhichThrows(final Transformer<? super I, ? extends O> source) {
        return new TransformerWhichThrows<I, O, EX>(){

            @Override
            @NotNull
            public O transform(I in) {
                return source.transform(in);
            }
        };
    }

    public static <I, O, EX extends RuntimeException> Transformer<I, O> asTransformer(final TransformerWhichThrows<? super I, ? extends O, EX> source) {
        return new Transformer<I, O>(){

            @Override
            @NotNull
            public O transform(I in) {
                return source.transform(in);
            }
        };
    }

    public static <I, O> Transformer<I, O> combine(final I extraInput, final O extraOutput, final Transformer<? super I, O> delegate) {
        return new Transformer<I, O>(){

            @Override
            @NotNull
            public O transform(I in) {
                if (in.equals(extraInput)) {
                    return extraOutput;
                }
                return delegate.transform(in);
            }
        };
    }

    public static <I, O, EX extends Throwable> TransformerWhichThrows<I, O, EX> combine(final I extraInput, final O extraOutput, final TransformerWhichThrows<? super I, O, EX> delegate) {
        return new TransformerWhichThrows<I, O, EX>(){

            @Override
            @NotNull
            public O transform(I in) throws Throwable {
                if (in.equals(extraInput)) {
                    return extraOutput;
                }
                return delegate.transform(in);
            }
        };
    }

    public static <I, O> Transformer<I, O> addMappings(final Transformer<? super I, O> transformer, Object ... keysAndValues) {
        final HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            Object key = keysAndValues[i++];
            assert (key != null);
            Object value = keysAndValues[i++];
            assert (value != null);
            m.put(key, value);
        }
        return new Transformer<I, O>(){

            @Override
            @NotNull
            public O transform(I in) {
                Object out = m.get(in);
                if (out != null) {
                    return out;
                }
                return transformer.transform(in);
            }
        };
    }

    public static <I, O> Transformer<I, O> fromMappings(Object ... keysAndValues) {
        final HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            m.put(keysAndValues[i++], keysAndValues[i++]);
        }
        return new Transformer<I, O>(){

            @Override
            @NotNull
            public O transform(I in) {
                return m.get(in);
            }
        };
    }

    public static <I, O> Transformer<I, O> cache(final Transformer<? super I, O> delegate) {
        return new Transformer<I, O>(){
            final WeakHashMap<I, O> cache = new WeakHashMap();

            @Override
            @NotNull
            public O transform(I in) {
                Object out = this.cache.get(in);
                if (out != null) {
                    return out;
                }
                out = delegate.transform(in);
                this.cache.put(in, out);
                return out;
            }
        };
    }

    public static <I, O, EX extends Throwable> Transformer<I, O> ignoreExceptions(final Class<EX> exceptionClass, final TransformerWhichThrows<I, O, EX> delegate, final O defaultValue) {
        return new Transformer<I, O>(){

            @Override
            public O transform(I in) {
                block6: {
                    try {
                        return delegate.transform(in);
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block6;
                        throw new AssertionError();
                    }
                }
                return defaultValue;
            }
        };
    }
}

