/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public final class ConsumerUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Consumer<?> NOP = new Consumer<Object>(){

        @Override
        public void consume(Object subject) {
        }
    };

    private ConsumerUtil() {
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final ConsumerWhichThrows<? super T, EX> delegate1, final ConsumerWhichThrows<? super T, EX> delegate2) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                delegate1.consume(subject);
                delegate2.consume(subject);
            }
        };
    }

    public static <T> Consumer<T> tee(final Consumer<? super T> delegate1, final Consumer<? super T> delegate2) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                delegate1.consume(subject);
                delegate2.consume(subject);
            }
        };
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> tee(final Collection<ConsumerWhichThrows<? super T, EX>> delegates) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) throws Throwable {
                for (ConsumerWhichThrows delegate : delegates) {
                    delegate.consume(subject);
                }
            }
        };
    }

    @Deprecated
    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> asConsumerWhichThrows(final Consumer<? super T> source) {
        return new ConsumerWhichThrows<T, EX>(){

            @Override
            public void consume(T subject) {
                source.consume(subject);
            }
        };
    }

    @Deprecated
    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> widen(ConsumerWhichThrows<? super T, ? extends EX> source) {
        ConsumerWhichThrows<? super T, ? extends EX> result = source;
        return result;
    }

    public static <T, EX extends Throwable> ConsumerWhichThrows<T, EX> widen2(ConsumerWhichThrows<? super T, ? extends RuntimeException> source) {
        ConsumerWhichThrows<? super T, ? extends RuntimeException> result = source;
        return result;
    }

    public static <T, EX extends RuntimeException> Consumer<T> asConsumer(ConsumerWhichThrows<? super T, ? extends RuntimeException> source) {
        Consumer result = (Consumer)source;
        return result;
    }

    @NotNullByDefault(value=false)
    public static Writer characterConsumerWriter(final ConsumerWhichThrows<? super Character, IOException> delegate) {
        return new Writer(){

            @Override
            public void write(int c) throws IOException {
                delegate.consume(Character.valueOf((char)c));
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0) {
                    this.write(cbuf[off++]);
                    --len;
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    public static <E extends Exception> ConsumerWhichThrows<Character, E> lineAggregator(final ConsumerWhichThrows<? super String, E> delegate) {
        return new ConsumerWhichThrows<Character, E>(){
            private final StringBuilder sb = new StringBuilder();
            private boolean crPending;

            @Override
            public void consume(Character c) throws Exception {
                if (c.charValue() == '\r') {
                    delegate.consume(this.sb.toString());
                    this.sb.setLength(0);
                    this.crPending = true;
                } else if (c.charValue() == '\n') {
                    if (this.crPending) {
                        this.crPending = false;
                    } else {
                        delegate.consume(this.sb.toString());
                        this.sb.setLength(0);
                    }
                } else {
                    this.crPending = false;
                    this.sb.append(c);
                }
            }
        };
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(File file, boolean append) throws IOException {
        return ConsumerUtil.lineConsumer(new FileWriter(file, append), true);
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(File file, String charsetName, boolean append) throws IOException {
        return ConsumerUtil.lineConsumer(new FileOutputStream(file, append), charsetName, true);
    }

    private static ConsumerWhichThrows<String, IOException> lineConsumer(OutputStream stream, String charsetName, boolean closeOnFinalize) throws UnsupportedEncodingException {
        return ConsumerUtil.lineConsumer(new OutputStreamWriter(stream, charsetName), closeOnFinalize);
    }

    public static ConsumerWhichThrows<String, IOException> lineConsumer(final Writer writer, final boolean closeOnFinalize) {
        return new ConsumerWhichThrows<String, IOException>(){

            @Override
            public void consume(String line) throws IOException {
                writer.write(String.valueOf(line) + LINE_SEPARATOR);
                writer.flush();
            }

            protected void finalize() throws Throwable {
                if (closeOnFinalize) {
                    writer.close();
                }
            }
        };
    }

    public static Consumer<String> lineConsumer(final PrintStream printStream, final boolean closeOnFinalize) {
        return new Consumer<String>(){

            @Override
            public void consume(String line) {
                printStream.println(line);
            }

            protected void finalize() {
                if (closeOnFinalize) {
                    printStream.close();
                }
            }

            public String toString() {
                return printStream.toString();
            }
        };
    }

    public static <T> Producer<Consumer<T>> combine(final Consumer<? super T> target) {
        return new Producer<Consumer<T>>(){

            @Override
            public Consumer<T> produce() {
                return new Consumer<T>(){

                    @Override
                    public void consume(T subject) {
                        target.consume(subject);
                    }
                };
            }
        };
    }

    public static <T, EX extends Throwable> Producer<ConsumerWhichThrows<T, EX>> combineInOrder(final ConsumerWhichThrows<? super T, EX> target) {
        final LinkedList outstanding = new LinkedList();
        final HashMap postponed = new HashMap();
        return new Producer<ConsumerWhichThrows<T, EX>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConsumerWhichThrows<T, EX> produce() {
                ConsumerWhichThrows consumer = new ConsumerWhichThrows<T, EX>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void consume(T subject) throws Throwable {
                        Queue queue = outstanding;
                        synchronized (queue) {
                            if (outstanding.isEmpty()) {
                                throw new IllegalStateException("Can consume only one subject");
                            }
                            if (outstanding.peek() == this) {
                                outstanding.remove();
                                target.consume(subject);
                                while (!outstanding.isEmpty() && postponed.containsKey(outstanding.element())) {
                                    target.consume(postponed.get(outstanding.remove()));
                                }
                            } else {
                                if (postponed.containsKey(this)) {
                                    throw new IllegalStateException("Can consume only one subject");
                                }
                                postponed.put(this, subject);
                            }
                        }
                    }
                };
                Queue queue = outstanding;
                synchronized (queue) {
                    outstanding.add(consumer);
                }
                return consumer;
            }
        };
    }

    public static <T, EX extends Throwable> List<ConsumerWhichThrows<T, EX>> splice(final int n, final ConsumerWhichThrows<? super List<T>, EX> target) {
        final ArrayList buffers = new ArrayList(n);
        ArrayList<ConsumerWhichThrows<T, EX>> consumers = new ArrayList<ConsumerWhichThrows<T, EX>>(n);
        int i = 0;
        while (i < n) {
            consumers.add(new ConsumerWhichThrows<T, EX>(){
                final Queue<T> buffer = new LinkedList();
                {
                    list.add(this.buffer);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void consume(T subject) throws Throwable {
                    List list = buffers;
                    synchronized (list) {
                        this.buffer.add(subject);
                        for (Queue b : buffers) {
                            if (!b.isEmpty()) continue;
                            return;
                        }
                        ArrayList subjects = new ArrayList(n);
                        for (Queue b : buffers) {
                            subjects.add(b.remove());
                        }
                        target.consume(subjects);
                    }
                }
            });
            ++i;
        }
        return consumers;
    }

    public static <T> Consumer<T> addToCollection(final Collection<T> drain) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                drain.add(subject);
            }
        };
    }

    public static <EX extends Throwable> ConsumerWhichThrows<EX, EX> throwsSubject() {
        return new ConsumerWhichThrows<EX, EX>(){

            @Override
            public void consume(EX throwable) throws Throwable {
                throw throwable;
            }
        };
    }

    public static <T> Produmer<T, T> store() {
        return new Produmer<T, T>(){
            @Nullable
            private T store;

            @Override
            public void consume(T subject) {
                this.store = subject;
            }

            @Override
            @Nullable
            public T produce() {
                return this.store;
            }
        };
    }

    public static Consumer<Number> cumulate(final Consumer<? super Long> delegate, long initialCount) {
        return new Consumer<Number>(initialCount){
            long count;
            {
                this.count = l;
            }

            @Override
            public void consume(Number n) {
                delegate.consume(this.count += n.longValue());
            }
        };
    }

    public static Consumer<Long> compressExponentially(long initialLimit, final Consumer<? super Long> delegate) {
        return new Consumer<Long>(initialLimit){
            long limit;
            {
                this.limit = l;
            }

            @Override
            public void consume(Long n) {
                if (n >= this.limit) {
                    delegate.consume(n);
                    do {
                        this.limit <<= 1;
                    } while (n >= this.limit);
                }
            }
        };
    }

    public static <T> Consumer<T> compress(final Consumer<T> delegate, final Predicate<T> compressable) {
        return new Consumer<T>(){

            @Override
            public void consume(T subject) {
                if (!compressable.evaluate(subject)) {
                    delegate.consume(subject);
                }
            }
        };
    }

    public static <T> Consumer<T> compress(final Consumer<? super T> delegate, final Predicate<? super T> compressable, final T compressed) {
        return new Consumer<T>(){
            int state;

            @Override
            public void consume(T subject) {
                boolean isCompressable = compressable.evaluate(subject);
                if (isCompressable) {
                    if (this.state == 1) {
                        this.state = 2;
                    }
                } else {
                    if (this.state == 2) {
                        delegate.consume(compressed);
                    }
                    delegate.consume(subject);
                    this.state = 1;
                }
            }
        };
    }

    public static <T> Consumer<T> nop() {
        return NOP;
    }

    public static <T, EX extends Throwable> Consumer<T> ignoreExceptions(final Class<EX> exceptionClass, final ConsumerWhichThrows<T, EX> delegate) {
        return new Consumer<T>(){

            @Override
            public void consume(@Nullable T subject) {
                block7: {
                    if (!$assertionsDisabled && subject == null) {
                        throw new AssertionError();
                    }
                    try {
                        delegate.consume(subject);
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block7;
                        throw new AssertionError();
                    }
                }
            }
        };
    }

    public static interface Produmer<PT, CT>
    extends Producer<PT>,
    Consumer<CT> {
    }
}

