/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.protocol.HardReference;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadUtil {
    private static final Logger LOGGER = Logger.getLogger(ThreadUtil.class.getName());
    public static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){
        final ThreadFactory delegate = Executors.defaultThreadFactory();

        @Override
        @NotNullByDefault(value=false)
        public Thread newThread(Runnable r) {
            Thread result = this.delegate.newThread(r);
            result.setName("Daemon-" + result.getName());
            result.setDaemon(true);
            return result;
        }
    };

    private ThreadUtil() {
    }

    public static Stoppable runInBackground(Runnable runnable, @Nullable String threadName) {
        final Thread t = new Thread(runnable, threadName == null ? runnable.toString() : threadName);
        t.setDaemon(true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Starting daemon thread {0} / ''{1}''", new Object[]{t.getId(), t.getName()});
        }
        t.start();
        return new Stoppable(){

            @Override
            public void stop() {
                if (!t.isAlive()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Background runnable '" + t.getName() + "' is not running");
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Stopping background runnable '" + t.getName() + "'");
                }
                t.interrupt();
                try {
                    t.join();
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Background runnable '" + t.getName() + "' stopped");
                }
            }
        };
    }

    public static <EX extends Throwable> Stoppable runInBackground(final RunnableWhichThrows<EX> runnable, @Nullable String threadName) {
        return ThreadUtil.runInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    LOGGER.log(Level.INFO, "Exception caught from runnable", e);
                }
            }
        }, threadName);
    }

    public static <EX extends Throwable> void runInForeground(RunnableWhichThrows<EX> runnable) throws EX {
        runnable.run();
    }

    public static <EX extends Throwable> void parallel(RunnableWhichThrows<EX> runnable1, RunnableWhichThrows<EX> runnable2, Stoppable stoppable) throws EX {
        ArrayList<RunnableWhichThrows<EX>> l = new ArrayList<RunnableWhichThrows<EX>>();
        l.add(runnable1);
        l.add(runnable2);
        ThreadUtil.parallel(l, Collections.singleton(stoppable));
    }

    public static <EX extends Throwable> void parallel(Iterable<? extends RunnableWhichThrows<EX>> runnables) throws EX {
        ThreadUtil.parallel(runnables, Collections.<Stoppable>emptyList());
    }

    public static <EX extends Throwable> void parallel(Iterable<? extends RunnableWhichThrows<EX>> runnables, Iterable<Stoppable> stoppables) throws EX {
        final HardReference caughtException = new HardReference();
        ArrayList<4> l = new ArrayList<4>();
        for (final RunnableWhichThrows<EX> runnable : runnables) {
            l.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Error er) {
                        throw er;
                    }
                    catch (Throwable th) {
                        Throwable ex = th;
                        caughtException.set(ex);
                    }
                }
            });
        }
        ThreadUtil.parallel(l.toArray(new Runnable[l.size()]), stoppables);
        Throwable ex = (Throwable)caughtException.get();
        if (ex != null) {
            throw ex;
        }
    }

    public static void parallel(Runnable[] runnables, final Iterable<Stoppable> stoppables) {
        final HardReference caughtRuntimeException = new HardReference();
        final Thread[] threads = new Thread[runnables.length - 1];
        int i = 0;
        while (i < runnables.length) {
            final Runnable runnable = runnables[i];
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException re) {
                        caughtRuntimeException.set(re);
                    }
                    Thread[] threadArray = threads;
                    int n = threads.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Thread thread = threadArray[n2];
                        if (thread != null) {
                            thread.interrupt();
                        }
                        ++n2;
                    }
                    for (Stoppable stoppable : stoppables) {
                        if (stoppable == null) continue;
                        stoppable.stop();
                    }
                }
            };
            if (i < runnables.length - 1) {
                Thread t = new Thread(runnable2);
                t.setName(Thread.currentThread().getName());
                t.start();
                threads[i] = t;
            } else {
                runnable2.run();
            }
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            ++n2;
        }
        RuntimeException re = (RuntimeException)caughtRuntimeException.get();
        if (re != null) {
            throw re;
        }
    }

    public static <R extends RunnableWhichThrows<EX>, EX extends Throwable> void runInForeground(Iterable<R> runnables) throws EX {
        RunnableWhichThrows r;
        Iterator<R> it = runnables.iterator();
        ArrayList<Stoppable> stoppables = new ArrayList<Stoppable>();
        while (true) {
            r = (RunnableWhichThrows)it.next();
            if (!it.hasNext()) break;
            stoppables.add(ThreadUtil.runInBackground(r, null));
        }
        ThreadUtil.runInForeground(r);
        for (Stoppable stoppable : stoppables) {
            stoppable.stop();
        }
    }
}

