/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.protocol.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class StringUtil {
    public static final Predicate<CharSequence> IS_BLANK = new Predicate<CharSequence>(){

        @Override
        public boolean evaluate(CharSequence subject) {
            return StringUtil.isBlank(subject);
        }
    };

    private StringUtil() {
    }

    public static String join(Collection<? extends Object> elements, String glue) {
        if (elements.size() == 0) {
            return "";
        }
        if (elements.size() == 1) {
            return String.valueOf(elements.iterator().next());
        }
        Iterator<? extends Object> it = elements.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(glue).append(it.next());
        }
        return sb.toString();
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        int l2;
        int l1 = cs1.length();
        if (l1 != (l2 = cs2.length())) {
            return false;
        }
        int i = 0;
        while (i < l1) {
            if (cs1.charAt(i) != cs2.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int compareTo(CharSequence cs1, CharSequence cs2) {
        int l1 = cs1.length();
        int l2 = cs1.length();
        int n = Math.min(l1, l2);
        int i = 0;
        while (i < n) {
            int diff = cs1.charAt(i) - cs2.charAt(i);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return l1 - l2;
    }

    public static String repeat(int n, char c) {
        if (n <= 0) {
            return "";
        }
        char[] ca = new char[n];
        Arrays.fill(ca, c);
        return String.copyValueOf(ca);
    }

    public static String repeat(int n, String s) {
        if (n <= 0) {
            return "";
        }
        if (n == 1) {
            return s;
        }
        int len = s.length();
        char[] src = s.toCharArray();
        char[] dst = new char[n * len];
        int i = 0;
        while (i < n) {
            System.arraycopy(src, 0, dst, i * len, len);
            ++i;
        }
        return String.copyValueOf(dst);
    }

    public static boolean isBlank(CharSequence cs) {
        int i = cs.length() - 1;
        while (i >= 0) {
            if (cs.charAt(i) > ' ') {
                return false;
            }
            --i;
        }
        return true;
    }

    public static String firstLetterToUpperCase(String s) {
        if (s.isEmpty() || !Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static String firstLetterToLowerCase(String s) {
        if (s.isEmpty() || !Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static Iterable<Character> asIterable(final CharSequence subject) {
        return new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return StringUtil.iterator(subject);
            }
        };
    }

    public static Iterator<Character> iterator(final CharSequence subject) {
        return new Iterator<Character>(){
            int idx;

            @Override
            public void remove() {
                throw new NoSuchElementException("remove");
            }

            @Override
            public Character next() {
                if (this.idx >= subject.length()) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Character.valueOf(subject.charAt(this.idx++));
            }

            @Override
            public boolean hasNext() {
                return this.idx < subject.length();
            }
        };
    }

    public static Iterator<Character> reverseIterator(final CharSequence subject) {
        return new Iterator<Character>(){
            int idx;
            {
                this.idx = charSequence.length();
            }

            @Override
            public void remove() {
                throw new NoSuchElementException("remove");
            }

            @Override
            public Character next() {
                if (this.idx <= 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Character.valueOf(subject.charAt(--this.idx));
            }

            @Override
            public boolean hasNext() {
                return this.idx > 0;
            }
        };
    }

    public static String lessTrailingLineSeparators(String s) {
        if (s.isEmpty()) {
            return "";
        }
        int i = s.length() - 1;
        char c = s.charAt(i);
        if (c != '\r' && c != '\n') {
            return s;
        }
        --i;
        while (i >= 0) {
            c = s.charAt(i);
            if (c != '\r' && c != '\n') {
                return s.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }
}

