/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.notemplate.javadocish.templates;

import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.notemplate.javadocish.Options;
import de.unkrig.notemplate.javadocish.templates.AbstractRightFrameHtml;
import java.util.ArrayList;
import java.util.List;

public class AbstractSummaryHtml
extends AbstractRightFrameHtml {
    protected void rSummary(String windowTitle, Options options, @Nullable String[] stylesheetLinks, @Nullable String[] nav1, @Nullable String[] nav2, @Nullable String[] nav3, @Nullable String[] nav4, Runnable[] headers, @Nullable Runnable epilog, List<Section> sections) {
        super.rRightFrameHtml(windowTitle, options, stylesheetLinks, nav1, nav2, nav3, nav4, null, null, () -> {
            Runnable[] runnableArray2 = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Runnable header = runnableArray2[n2];
                if (header != null) {
                    this.l("    <div class=\"header\">");
                    header.run();
                    this.l("    </div>");
                }
                ++n2;
            }
            this.l("    <div class=\"contentContainer\">", "      <ul class=\"blockList\">");
            for (Section section : sections) {
                if (section.items.isEmpty()) continue;
                if (section.anchor != null) {
                    this.l("        <a name=\"" + section.anchor + "\">", "          <!--   -->", "        </a>");
                }
                this.l("        <li class=\"blockList\">", "          <table class=\"overviewSummary\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\" summary=\"" + section.summary + "\">", "            <caption><span>" + section.title + "</span><span class=\"tabEnd\">&nbsp;</span></caption>", "            <tr>", "              <th class=\"colFirst\" scope=\"col\">" + section.firstColumnHeading + "</th>", "              <th class=\"colLast\" scope=\"col\">Description</th>", "            </tr>", "            <tbody>");
                Producer<String> trClass = ProducerUtil.alternate("altColor", "rowColor");
                for (SectionItem item : section.items) {
                    this.l("              <tr class=\"" + (String)trClass.produce() + "\">", "                <td class=\"colFirst\"><a href=\"" + item.link + "\">" + item.name + "</a></td>");
                    if (item.summary.isEmpty()) {
                        this.l("                <td class=\"colLast\">&nbsp;</td>");
                    } else {
                        this.l("                <td class=\"colLast\">", "                  <div class=\"block\">" + item.summary + "</div>", "                </td>");
                    }
                    this.l("              </tr>");
                }
                this.l("            </tbody>", "          </table>", "        </li>");
            }
            this.l("      </ul>");
            if (epilog != null) {
                epilog.run();
            }
            this.l("    </div>");
        });
    }

    public static class Section {
        @Nullable
        public final String anchor;
        public final String title;
        @Nullable
        public final String summary;
        public final String firstColumnHeading;
        public final List<SectionItem> items = new ArrayList<SectionItem>();

        public Section(@Nullable String anchor, String title, @Nullable String summary, String firstColumnHeading) {
            this.anchor = anchor;
            this.title = title;
            this.summary = summary;
            this.firstColumnHeading = firstColumnHeading;
        }
    }

    public static class SectionItem {
        public final String link;
        @Nullable
        public final String name;
        public final String summary;

        public SectionItem(String link, @Nullable String name, String summary) {
            this.link = link;
            this.name = name;
            this.summary = summary;
        }
    }
}

