/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.handler;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import de.unkrig.commons.util.logging.handler.ProxyHandler;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class EagerHandler
extends ProxyHandler {
    public EagerHandler() throws ParseException, EvaluationException {
        this((String)null);
    }

    public EagerHandler(@Nullable String propertyNamePrefix) throws ParseException, EvaluationException {
        if (propertyNamePrefix == null) {
            propertyNamePrefix = this.getClass().getName();
        }
        this.setDelegate(LogUtil.getLoggingProperty(propertyNamePrefix + ".delegate", Handler.class));
    }

    @Override
    public void publish(LogRecord record) {
        String message;
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0 && (message = record.getMessage()).contains("{0")) {
            try {
                record.setMessage(MessageFormat.format(message, parameters));
                record.setParameters(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.publish(record);
    }
}

