/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging.formatter;

import de.unkrig.commons.lang.PrettyPrinter;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.logging.LogUtil;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

@NotNullByDefault(value=false)
public class PrettyPrintFormatter
extends Formatter {
    private Formatter delegate;

    public PrettyPrintFormatter() throws ParseException, EvaluationException {
        String propertyNamePrefix = this.getClass().getName();
        this.init(LogUtil.getLoggingProperty(propertyNamePrefix + ".delegate", Formatter.class));
    }

    public PrettyPrintFormatter(Formatter delegate) {
        this.init(delegate);
    }

    private void init(Formatter delegate) {
        this.delegate = delegate;
    }

    @Override
    public String format(LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters == null || parameters.length == 0) {
            return this.delegate.format(record);
        }
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = PrettyPrinter.toString(parameters[i]);
        }
        record.setParameters(parameters);
        return this.delegate.format(record);
    }
}

