/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

@NotNullByDefault(value=false)
public class WriterOutputStream
extends OutputStream {
    private final Writer delegate;

    public WriterOutputStream(Writer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        while (len > 0) {
            this.delegate.write(0xFF & buf[off++]);
            --len;
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.delegate.write(c);
    }
}

