/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.concurrent;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@NotNullByDefault(value=false)
public class SquadExecutor<T>
implements Executor {
    private final ExecutorService delegate;
    private final Queue<Future<T>> futures = new ConcurrentLinkedQueue<Future<T>>();

    public SquadExecutor(ExecutorService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        this.submit(command);
    }

    public Future<T> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<Object> ftask = new FutureTask<Object>(task, null);
        this.futures.add(ftask);
        this.delegate.execute(ftask);
        return ftask;
    }

    public Future<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<T> ftask = new FutureTask<T>(task, result);
        this.futures.add(ftask);
        this.delegate.execute(ftask);
        return ftask;
    }

    public Future<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        FutureTask<T> ftask = new FutureTask<T>(task);
        this.futures.add(ftask);
        this.delegate.execute(ftask);
        return ftask;
    }

    public List<Future<T>> awaitCompletion() throws InterruptedException, ExecutionException, CancellationException {
        ArrayList<Future<T>> result = new ArrayList<Future<T>>();
        Future<T> f = this.futures.poll();
        while (f != null) {
            f.get();
            result.add(f);
            f = this.futures.poll();
        }
        return result;
    }

    public List<Future<T>> awaitCompletion(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException {
        if (unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<Future<T>> result = new ArrayList<Future<T>>();
        long lastTime = System.nanoTime();
        Future<T> f = this.futures.poll();
        while (f != null) {
            if (nanos <= 0L) {
                return result;
            }
            try {
                f.get(nanos, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException toe) {
                return result;
            }
            result.add(f);
            long now = System.nanoTime();
            nanos -= now - lastTime;
            lastTime = now;
            f = this.futures.poll();
        }
        return result;
    }
}

