/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text.pattern;

import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternUtil {
    private static final Logger LOGGER = Logger.getLogger(PatternUtil.class.getName());

    private PatternUtil() {
    }

    public static void replaceAll(Reader in, Pattern pattern, String replacementString, Writer out) throws IOException {
        PatternUtil.replaceAll(in, pattern, PatternUtil.replacementStringReplacer(replacementString), out, 8192);
    }

    public static Function<Matcher, String> constantReplacer(final @Nullable String string) {
        return new Function<Matcher, String>(){

            @Override
            @Nullable
            public String call(@Nullable Matcher match) {
                return string;
            }
        };
    }

    public static Function<Matcher, String> replacementStringReplacer(final String replacementString) {
        return new Function<Matcher, String>(){

            @Override
            @Nullable
            public String call(@Nullable Matcher matcher) {
                assert (matcher != null);
                StringBuffer result = new StringBuffer();
                int idx = 0;
                while (idx < replacementString.length()) {
                    char c = replacementString.charAt(idx);
                    if (c == '\\') {
                        result.append(replacementString.charAt(++idx));
                        ++idx;
                        continue;
                    }
                    if (c == '$') {
                        String group;
                        int nextDigit;
                        int referenceNumber;
                        if ((referenceNumber = replacementString.charAt(++idx) - 48) < 0 || referenceNumber > 9) {
                            throw new IllegalArgumentException("Illegal group reference");
                        }
                        ++idx;
                        while (idx < replacementString.length() && (nextDigit = replacementString.charAt(idx) - 48) >= 0 && nextDigit <= 9) {
                            int newRefNum = referenceNumber * 10 + nextDigit;
                            if (matcher.groupCount() < newRefNum) break;
                            referenceNumber = newRefNum;
                            ++idx;
                        }
                        if ((group = matcher.group(referenceNumber)) == null) continue;
                        result.append(group);
                        continue;
                    }
                    result.append(c);
                    ++idx;
                }
                return result.toString();
            }
        };
    }

    public static Function<Matcher, String> systemPropertyReplacer() {
        return new Function<Matcher, String>(){

            @Override
            @Nullable
            public String call(@Nullable Matcher matcher) {
                assert (matcher != null);
                return System.getProperty(matcher.group(1));
            }
        };
    }

    public static int replaceSystemProperties(Reader in, Writer out) throws IOException {
        return PatternUtil.replaceAll(in, Pattern.compile("\\$\\{([^}]+)}", 8), PatternUtil.systemPropertyReplacer(), out, 4096);
    }

    public static String replaceAll(Matcher matcher, Function<Matcher, String> replacer) {
        matcher.reset();
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        while (result) {
            String replacement = (String)replacer.call(matcher);
            if (replacement != null) {
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            result = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static int replaceAll(Reader in, Pattern pattern, Function<Matcher, String> replacer, Writer out, int initialBufferCapacity) throws IOException {
        LOGGER.log(Level.FINE, "Replace all matches of ''{0}''", pattern);
        int replacementCount = 0;
        CharBuffer cb = CharBuffer.allocate(initialBufferCapacity);
        while (true) {
            if (cb.hasRemaining() && in.read(cb) != -1) {
                continue;
            }
            if (cb.position() == 0) break;
            cb.flip();
            Matcher m = pattern.matcher(cb);
            boolean found = m.find();
            while (m.hitEnd()) {
                if (cb.limit() < cb.capacity()) {
                    cb.compact();
                    if (in.read(cb) == -1) {
                        cb.flip();
                        break;
                    }
                    while (cb.hasRemaining() && in.read(cb) != -1) {
                    }
                    cb.flip();
                } else {
                    LOGGER.finest("Increasing buffer size");
                    cb = CharBuffer.allocate(cb.capacity() * 2).append(cb);
                    if (in.read(cb) == -1) {
                        cb.flip();
                        m = pattern.matcher(cb);
                        found = m.find();
                        break;
                    }
                    while (cb.hasRemaining() && in.read(cb) != -1) {
                    }
                    cb.flip();
                }
                m = pattern.matcher(cb);
                found = m.find();
            }
            if (!found) {
                out.append(cb);
                cb.clear();
                continue;
            }
            if (m.end() == 0) {
                if (cb.limit() == 0) break;
                out.append(cb.get());
                cb.compact();
                continue;
            }
            String replacement = (String)replacer.call(m);
            if (replacement == null) {
                LOGGER.log(Level.CONFIG, "Leaving match ''{0}'' unreplaced", m.group());
                out.append(cb, 0, m.end());
            } else {
                LOGGER.log(Level.CONFIG, "Replacing match ''{0}'' with ''{1}''", new Object[]{m.group(), replacement});
                out.append(cb, 0, m.start());
                out.append(replacement);
                ++replacementCount;
            }
            cb.position(m.end());
            cb.compact();
            if (cb.capacity() <= initialBufferCapacity || cb.position() > initialBufferCapacity) continue;
            LOGGER.finest("Restoring initial buffer size");
            cb.flip();
            cb = CharBuffer.allocate(initialBufferCapacity).append(cb);
        }
        LOGGER.log(Level.FINE, "Replaced {0,choice,0#no matches|1#one match|1<{0} matches} of ''{1}''", new Object[]{replacementCount, pattern});
        return replacementCount;
    }
}

