/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;

public class LevelFilteredPrinter
extends AbstractPrinter {
    private boolean printWarnings = true;
    private boolean printInfos = true;
    private boolean printVerbose;
    private boolean printDebug;
    private final Printer delegate;

    public LevelFilteredPrinter(Printer delegate) {
        this.delegate = delegate;
    }

    public void setNoWarn() {
        this.printWarnings = false;
        this.printInfos = false;
        this.printVerbose = false;
        this.printDebug = false;
    }

    public void setQuiet() {
        this.printWarnings = true;
        this.printInfos = false;
        this.printVerbose = false;
        this.printDebug = false;
    }

    public void setNormal() {
        this.printWarnings = true;
        this.printInfos = true;
        this.printVerbose = false;
        this.printDebug = false;
    }

    public void setVerbose() {
        this.printWarnings = true;
        this.printInfos = true;
        this.printVerbose = true;
        this.printDebug = false;
    }

    public void setDebug() {
        this.printWarnings = true;
        this.printInfos = true;
        this.printVerbose = true;
        this.printDebug = true;
    }

    @Override
    public void error(@Nullable String message) {
        this.delegate.error(message);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.printWarnings;
    }

    @Override
    public void warn(@Nullable String message) {
        if (this.printWarnings) {
            this.delegate.warn(message);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.printInfos;
    }

    @Override
    public void info(@Nullable String message) {
        if (this.printInfos) {
            this.delegate.info(message);
        }
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.printVerbose;
    }

    @Override
    public void verbose(@Nullable String message) {
        if (this.printVerbose) {
            this.delegate.verbose(message);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.printDebug;
    }

    @Override
    public void debug(@Nullable String message) {
        if (this.printDebug) {
            this.delegate.debug(message);
        }
    }
}

