/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.security;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class Sandbox {
    private static final Map<Class<?>, AccessControlContext> CONFINED_CLASSES;
    private static final Map<String, AccessControlContext> CONFINED_CLASS_NAMES;
    private static final Map<ClassLoader, AccessControlContext> CONFINED_CLASS_LOADERS;

    private Sandbox() {
    }

    public static void confine(Class<?> clasS, AccessControlContext accessControlContext) {
        if (CONFINED_CLASSES.containsKey(clasS)) {
            throw new SecurityException("Attempt to change the access control context for '" + clasS + "'");
        }
        CONFINED_CLASSES.put(clasS, accessControlContext);
    }

    public static void confine(Class<?> clasS, ProtectionDomain protectionDomain) {
        Sandbox.confine(clasS, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
    }

    public static void confine(Class<?> clasS, Permissions permissions) {
        Sandbox.confine(clasS, new ProtectionDomain(null, permissions));
    }

    public static void confine(String className, AccessControlContext accessControlContext) {
        if (CONFINED_CLASS_NAMES.containsKey(className)) {
            throw new SecurityException("Attempt to change the access control context for '" + className + "'");
        }
        CONFINED_CLASS_NAMES.put(className, accessControlContext);
    }

    public static void confine(String className, ProtectionDomain protectionDomain) {
        Sandbox.confine(className, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
    }

    public static void confine(String className, Permissions permissions) {
        Sandbox.confine(className, new ProtectionDomain(null, permissions));
    }

    public static void confine(ClassLoader classLoader, AccessControlContext accessControlContext) {
        if (CONFINED_CLASS_LOADERS.containsKey(classLoader)) {
            throw new SecurityException("Attempt to change the access control context for '" + classLoader + "'");
        }
        CONFINED_CLASS_LOADERS.put(classLoader, accessControlContext);
    }

    public static void confine(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        Sandbox.confine(classLoader, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
    }

    public static void confine(ClassLoader classLoader, Permissions permissions) {
        Sandbox.confine(classLoader, new ProtectionDomain(null, permissions));
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
        CONFINED_CLASSES = Collections.synchronizedMap(new WeakHashMap());
        CONFINED_CLASS_NAMES = new ConcurrentHashMap<String, AccessControlContext>();
        CONFINED_CLASS_LOADERS = Collections.synchronizedMap(new WeakHashMap());
        if (System.getSecurityManager() != null) {
            throw new ExceptionInInitializerError("There's already a security manager set");
        }
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(@Nullable Permission perm) {
                assert (perm != null);
                for (Class<?> clasS : this.getClassContext()) {
                    AccessControlContext acc = (AccessControlContext)CONFINED_CLASSES.get(clasS);
                    if (acc != null) {
                        acc.checkPermission(perm);
                    }
                    if ((acc = (AccessControlContext)CONFINED_CLASS_NAMES.get(clasS.getName())) != null) {
                        acc.checkPermission(perm);
                    }
                    if ((acc = (AccessControlContext)CONFINED_CLASS_LOADERS.get(clasS.getClassLoader())) == null) continue;
                    acc.checkPermission(perm);
                }
            }
        });
    }
}

