/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.Mappings;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.expression.EvaluationException;
import de.unkrig.commons.text.expression.Expression;
import de.unkrig.commons.text.expression.ExpressionEvaluator;
import de.unkrig.commons.text.parser.ParseException;
import de.unkrig.commons.util.collections.CollectionUtil;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogUtil {
    public static final LogManager LOG_MANAGER;
    private static final String[] LOGGING_IMPORTS;
    public static final Logger ROOT_LOGGER;
    public static final Level WARNING_PLUS_1;
    public static final Level INFO_PLUS_1;
    public static final Filter LESS_THAN_WARNING;
    public static final Filter LESS_THAN_INFO;
    public static final Filter LESS_THAN_CONFIG;
    private static final Pattern QUANTITY_FORMAT;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOG_MANAGER = LogManager.getLogManager();
        LOGGING_IMPORTS = new String[]{"java.lang", "java.io", "java.util", "java.util.logging", "de.unkrig.commons.util.logging"};
        ROOT_LOGGER = Logger.getLogger("");
        WARNING_PLUS_1 = Level.parse(Integer.toString(1 + Level.WARNING.intValue()));
        INFO_PLUS_1 = Level.parse(Integer.toString(1 + Level.INFO.intValue()));
        LESS_THAN_WARNING = LogUtil.levelLimitFilter(Level.WARNING);
        LESS_THAN_INFO = LogUtil.levelLimitFilter(Level.INFO);
        LESS_THAN_CONFIG = LogUtil.levelLimitFilter(Level.CONFIG);
        QUANTITY_FORMAT = Pattern.compile("(\\d+)([kMGTP])?");
    }

    private LogUtil() {
    }

    public static Consumer<String> logConsumer(final Logger logger, final Level level, final @Nullable String prefix) {
        return new Consumer<String>(){

            @Override
            public void consume(String message) {
                if (prefix != null) {
                    message = String.valueOf(prefix) + message;
                }
                logger.log(level, message);
            }
        };
    }

    public static Writer logWriter(Logger logger, Level level, @Nullable String prefix) {
        return ConsumerUtil.characterConsumerWriter(ConsumerUtil.lineAggregator(ConsumerUtil.widen2(LogUtil.logConsumer(logger, level, prefix))));
    }

    @NotNullByDefault(value=false)
    public static Filter levelLimitFilter(Level upperBound) {
        final int upperBoundValue = upperBound.intValue();
        return new Filter(){

            @Override
            public boolean isLoggable(LogRecord logRecord) {
                return logRecord.getLevel().intValue() < upperBoundValue;
            }
        };
    }

    public static Boolean getLoggingProperty(String propertyName, Boolean defaulT) {
        String s = LOG_MANAGER.getProperty(propertyName);
        if (s == null) {
            return defaulT;
        }
        return Boolean.parseBoolean(s.trim());
    }

    public static <T> T getLoggingProperty(String propertyName, Class<T> type) throws ParseException, EvaluationException {
        Map variables = CollectionUtil.map("propertyName", propertyName, "type", type);
        return new ExpressionEvaluator(variables.keySet()).setImports(LOGGING_IMPORTS).evaluateTo(LogUtil.requireLoggingProperty(propertyName), Mappings.fromMap(variables), type);
    }

    @Nullable
    public static <T> T getLoggingProperty(String propertyName, Class<T> type, @Nullable T defaulT) throws ParseException, EvaluationException {
        String spec = LOG_MANAGER.getProperty(propertyName);
        if (spec == null) {
            return defaulT;
        }
        Map variables = CollectionUtil.map("propertyName", propertyName, "type", type);
        return new ExpressionEvaluator(variables.keySet()).setImports(LOGGING_IMPORTS).evaluateTo(spec, Mappings.fromMap(variables), type);
    }

    public static Level getLoggingProperty(String propertyName, Level defaulT) {
        String s = LOG_MANAGER.getProperty(propertyName);
        if (s == null) {
            return defaulT;
        }
        try {
            return Level.parse(s.trim());
        }
        catch (IllegalArgumentException iae) {
            return defaulT;
        }
    }

    public static long getLoggingProperty(String propertyName, Long defaulT) {
        String s = LOG_MANAGER.getProperty(propertyName);
        if (s == null) {
            return defaulT;
        }
        Matcher m = QUANTITY_FORMAT.matcher(s = s.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("Value '" + s + "'  of logging property '" + propertyName + "' is not an integer");
        }
        long result = Long.parseLong(m.group(1));
        String metricPrefix = m.group(2);
        if (metricPrefix != null) {
            switch (metricPrefix.charAt(0)) {
                case 'k': {
                    result *= 1024L;
                    break;
                }
                case 'M': {
                    result *= 0x100000L;
                    break;
                }
                case 'G': {
                    result *= 0x40000000L;
                    break;
                }
                case 'T': {
                    result *= 0x10000000000L;
                    break;
                }
                case 'P': {
                    result *= 0x4000000000000L;
                }
            }
        }
        return result;
    }

    @Nullable
    public static String getLoggingProperty(String propertyName, @Nullable String defaulT) {
        String result = LOG_MANAGER.getProperty(propertyName);
        if (result == null) {
            return defaulT;
        }
        return result;
    }

    public static String requireLoggingProperty(String propertyName) {
        String result = LOG_MANAGER.getProperty(propertyName);
        if (result == null) {
            throw new IllegalArgumentException("Logging property '" + propertyName + "' missing");
        }
        return result;
    }

    public static Expression parseLoggingProperty(String propertyName, Predicate<? super String> isValidVariableNames) throws ParseException {
        return new ExpressionEvaluator(isValidVariableNames).setImports(LOGGING_IMPORTS).parse(LogUtil.requireLoggingProperty(propertyName));
    }
}

