/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.concurrent;

import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.ProxyConsumerWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.util.concurrent.SquadExecutor;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@NotNullByDefault(value=false)
public class ObjectSequentializer<T, EX extends Exception> {
    private final SquadExecutor<Void> squadExecutor;
    private ConsumerWhichThrows<? super T, ? extends EX> nextTarget;

    public ObjectSequentializer(ConsumerWhichThrows<? super T, ? extends EX> delegate, ExecutorService squadExecutor) {
        this.squadExecutor = new SquadExecutor(squadExecutor);
        this.nextTarget = delegate;
    }

    public synchronized void submit(final ConsumerWhichThrows<? super ConsumerWhichThrows<? super T, ? extends EX>, ? extends Exception> task) {
        final ConsumerWhichThrows<? super T, ? extends EX> previousTarget = this.nextTarget;
        final ArrayList buffer = new ArrayList();
        final ProxyConsumerWhichThrows<? super T, ? extends EX> pc = new ProxyConsumerWhichThrows<T, EX>(ConsumerUtil.addToCollection(buffer), 0);
        this.nextTarget = pc;
        this.squadExecutor.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                task.consume(previousTarget);
                ProxyConsumerWhichThrows proxyConsumerWhichThrows = pc;
                synchronized (proxyConsumerWhichThrows) {
                    for (Object t : buffer) {
                        previousTarget.consume(t);
                    }
                    pc.setDelegate(previousTarget);
                }
                return null;
            }
        });
    }

    public void awaitCompletion() throws InterruptedException, ExecutionException, CancellationException {
        this.squadExecutor.awaitCompletion();
    }

    void awaitCompletion(long timeout, TimeUnit unit) throws CancellationException, ExecutionException, InterruptedException {
        this.squadExecutor.awaitCompletion(timeout, unit);
    }
}

