/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class MapUtil {
    private MapUtil() {
    }

    @NotNullByDefault(value=false)
    public static <K, V> Map<K, V> combine(final Map<K, V> map1, final Map<K, V> map2) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public boolean containsKey(Object key) {
                return map1.containsKey(key) || map2.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return map1.containsValue(value) || map2.containsValue(value);
            }

            @Override
            public V get(Object key) {
                Object value = map1.get(key);
                return value != null || map1.containsKey(key) ? value : map2.get(key);
            }

            @Override
            public boolean isEmpty() {
                return map1.isEmpty() && map2.isEmpty();
            }

            @Override
            public V put(K key, V value) {
                return map1.put(key, value);
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                map1.putAll(map);
            }

            @Override
            public int size() {
                return map1.size() + map2.size();
            }
        };
    }

    @NotNullByDefault(value=false)
    public static <K, V> Map<K, V> augment(final Map<K, V> delegate, final K extraKey, final V extraValue) {
        return new Map<K, V>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException("clear");
            }

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                throw new UnsupportedOperationException("entrySet");
            }

            @Override
            public Set<K> keySet() {
                throw new UnsupportedOperationException("keySet");
            }

            @Override
            public V remove(Object key) {
                throw new UnsupportedOperationException("remove");
            }

            @Override
            public Collection<V> values() {
                throw new UnsupportedOperationException("values");
            }

            @Override
            public V put(K key, V value) {
                throw new UnsupportedOperationException("put");
            }

            @Override
            public void putAll(Map<? extends K, ? extends V> map) {
                throw new UnsupportedOperationException("putAll");
            }

            @Override
            public boolean containsKey(Object key) {
                return MapUtil.equal(key, extraKey) || delegate.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return MapUtil.equal(value, extraValue) || delegate.containsValue(value);
            }

            @Override
            public V get(Object key) {
                return MapUtil.equal(key, extraKey) ? extraValue : delegate.get(key);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public int size() {
                return delegate.size() + 1;
            }
        };
    }

    public static boolean equal(@Nullable Object o1, @Nullable Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <K, V> Map<K, V> fromMappings(Object ... keysAndValues) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            m.put(keysAndValues[i++], keysAndValues[i++]);
        }
        return Collections.unmodifiableMap(m);
    }
}

