/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Iterator<T> atEnd() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };
    }

    public static <T> Iterator<T> filter(final Iterator<T> delegate, final Predicate<? super T> qualifies) {
        return new Iterator<T>(){
            @Nullable
            T lookahead;

            @Override
            public boolean hasNext() {
                Object tmp;
                if (this.lookahead != null) {
                    return true;
                }
                do {
                    if (delegate.hasNext()) continue;
                    return false;
                } while (!qualifies.evaluate(tmp = delegate.next()));
                this.lookahead = tmp;
                return true;
            }

            @Override
            public T next() {
                Object tmp;
                if (this.lookahead != null) {
                    Object tmp2 = this.lookahead;
                    this.lookahead = null;
                    return tmp2;
                }
                while (!qualifies.evaluate(tmp = delegate.next())) {
                }
                return tmp;
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <I, O> Iterator<O> transform(final Iterator<? extends I> delegate, final Transformer<? super I, O> transform) {
        return new Iterator<O>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public O next() {
                return transform.transform(delegate.next());
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
    }

    public static <T> Iterator<T> repeat(final T value) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> repeat(final int n, final T value) {
        return new Iterator<T>(){
            int count;

            @Override
            public boolean hasNext() {
                return this.count < n;
            }

            @Override
            public T next() {
                if (this.count >= n) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

