/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.nullanalysis.NotNull;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.IteratorUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;

public final class IterableUtil {
    private IterableUtil() {
    }

    public static <T> Iterable<T> unmodifiableIterable(final Iterable<T> i) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator it = i.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return it.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> repeat(final T subject, final int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    final AtomicInteger index = new AtomicInteger();

                    @Override
                    public boolean hasNext() {
                        return this.index.intValue() < n;
                    }

                    @Override
                    public T next() {
                        if (this.index.getAndIncrement() >= n) {
                            throw new NoSuchElementException();
                        }
                        return subject;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }
        };
    }

    public static <E> Iterable<E> reverseList(final List<E> list) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final ListIterator li = list.listIterator(list.size());
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return li.hasPrevious();
                    }

                    @Override
                    public E next() {
                        return li.previous();
                    }

                    @Override
                    public void remove() {
                        li.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> concat(Iterable<T> element1, Iterable<T> element2) {
        ArrayList<Iterable<T>> l = new ArrayList<Iterable<T>>(2);
        l.add(element1);
        l.add(element2);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(Iterable<T> element1, Iterable<T> element2, Iterable<T> element3) {
        ArrayList<Iterable<T>> l = new ArrayList<Iterable<T>>(3);
        l.add(element1);
        l.add(element2);
        l.add(element3);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(Iterable<T> element1, Iterable<T> element2, Iterable<T> element3, Iterable<T> element4) {
        ArrayList<Iterable<T>> l = new ArrayList<Iterable<T>>(4);
        l.add(element1);
        l.add(element2);
        l.add(element3);
        l.add(element4);
        return IterableUtil.concat(l);
    }

    public static <T> Iterable<T> concat(final Iterable<Iterable<T>> elements) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(elements){
                    Iterator<Iterable<T>> outer;
                    Iterator<T> inner;
                    {
                        this.outer = iterable.iterator();
                        this.inner = IteratorUtil.atEnd();
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.inner.hasNext()) {
                            if (!this.outer.hasNext()) {
                                return false;
                            }
                            this.inner = this.outer.next().iterator();
                        }
                        return true;
                    }

                    @Override
                    public T next() throws NoSuchElementException {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.inner.next();
                    }

                    @Override
                    public void remove() {
                        this.inner.remove();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> filter(final Iterable<T> delegate, final Predicate<? super T> qualifies) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return IteratorUtil.filter(delegate.iterator(), qualifies);
            }
        };
    }

    public static <I, O> Iterable<O> transform(final Iterable<? extends I> delegate, final Transformer<I, O> transform) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return IteratorUtil.transform(delegate.iterator(), transform);
            }
        };
    }

    public static <T> Collection<T> asCollection(final Iterable<T> delegate) {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return delegate.iterator();
            }

            @Override
            public int size() {
                int result = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++result;
                    it.next();
                }
                return result;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean addAll(@Nullable Collection<? extends T> c) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterable<ElementWithContext<T>> iterableWithContext(final Iterable<T> delegate) {
        return new Iterable<ElementWithContext<T>>(){

            @Override
            public Iterator<ElementWithContext<T>> iterator() {
                return IterableUtil.iteratorWithContext(delegate);
            }
        };
    }

    public static <T> Iterator<ElementWithContext<T>> iteratorWithContext(Iterable<T> iterable) {
        class ElementWithContextIterator
        implements Iterator<ElementWithContext<T>> {
            @Nullable
            private T current;
            @Nullable
            private T next;
            private final Iterator<T> it;

            ElementWithContextIterator(Iterable iterable) {
                this.it = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.next != null || this.it.hasNext();
            }

            @Override
            public ElementWithContext<T> next() {
                final Object previous = this.current;
                if (this.next == null) {
                    Object e = this.it.next();
                    if (!$assertionsDisabled && e == null) {
                        throw new AssertionError((Object)"Delegate must produce non-null values");
                    }
                    this.current = e;
                } else {
                    this.current = this.next;
                    this.next = null;
                }
                return new ElementWithContext<T>(){

                    @Override
                    @Nullable
                    public T previous() {
                        return previous;
                    }

                    @Override
                    @NotNull
                    public T current() {
                        Object result = current;
                        if (!$assertionsDisabled && result == null) {
                            throw new AssertionError();
                        }
                        return result;
                    }

                    @Override
                    @Nullable
                    public T next() {
                        if (next != null) {
                            return next;
                        }
                        if (!it.hasNext()) {
                            return null;
                        }
                        Object e = it.next();
                        if (!$assertionsDisabled && e == null) {
                            throw new AssertionError((Object)"Delegate must produce non-null values");
                        }
                        next = e;
                        return next;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
        return new ElementWithContextIterator(iterable);
    }

    public static interface ElementWithContext<T> {
        @Nullable
        public T previous();

        public T current();

        @Nullable
        public T next();
    }
}

