/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.collections;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.collections.LinearMap;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class CollectionUtil {
    public static final SortedMap EMPTY_SORTED_MAP;
    public static final SortedSet EMPTY_SORTED_SET;
    public static final Iterator AT_END;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        EMPTY_SORTED_MAP = new EmptySortedMap();
        EMPTY_SORTED_SET = new EmptySortedSet();
        AT_END = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private CollectionUtil() {
    }

    @Nullable
    public static <T> T removeFirstFrom(Collection<T> subject) {
        Iterator<T> it = subject.iterator();
        if (!it.hasNext()) {
            return null;
        }
        T result = it.next();
        it.remove();
        return result;
    }

    public static <K, V> Map<K, V> map(Object ... keyValuePairs) {
        int n = keyValuePairs.length;
        if ((n & 1) == 1) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            return Collections.emptyMap();
        }
        if (n == 2) {
            return Collections.singletonMap(keyValuePairs[0], keyValuePairs[1]);
        }
        AbstractMap result = n <= 8 ? new LinearMap(n / 2) : new HashMap(n);
        int i = 0;
        while (i < n) {
            if (result.put(keyValuePairs[i++], keyValuePairs[i++]) == null) continue;
            throw new IllegalArgumentException("Duplicate key '" + keyValuePairs[i - 2]);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] values) {
        int n = keys.length;
        assert (n == values.length);
        if (n == 0) {
            return Collections.emptyMap();
        }
        if (n == 1) {
            return Collections.singletonMap(keys[0], values[0]);
        }
        AbstractMap result = n <= 4 ? new LinearMap(n) : new HashMap(2 * n);
        int i = 0;
        while (i < n) {
            if (result.put(keys[i], values[i]) != null) {
                throw new IllegalArgumentException("Duplicate key '" + keys[i]);
            }
            ++i;
        }
        return Collections.unmodifiableMap(result);
    }

    public static <K, V> SortedMap<K, V> emptySortedMap() {
        return EMPTY_SORTED_MAP;
    }

    public static <T> SortedSet<T> emptySortedSet() {
        return EMPTY_SORTED_SET;
    }

    public static <T> Collection<T> sorted(Collection<T> collection) {
        Object[] a = collection.toArray();
        Arrays.sort(a);
        return Arrays.asList(a);
    }

    @NotNullByDefault(value=false)
    private static class EmptySortedMap
    extends AbstractMap
    implements SortedMap,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return EMPTY_SORTED_MAP;
        }

        public SortedMap headMap(Object toKey) {
            return EMPTY_SORTED_MAP;
        }

        public SortedMap tailMap(Object fromKey) {
            return EMPTY_SORTED_MAP;
        }

        public Object firstKey() {
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Set keySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Collection values() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set entrySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SortedMap && ((SortedMap)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    @NotNullByDefault(value=false)
    private static class EmptySortedSet
    extends AbstractSet
    implements SortedSet,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptySortedSet() {
        }

        @Override
        public Iterator iterator() {
            return AT_END;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        public Comparator comparator() {
            return null;
        }

        public SortedSet subSet(Object from, Object to) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet headSet(Object toElement) {
            return EMPTY_SORTED_SET;
        }

        public SortedSet tailSet(Object fromElement) {
            return EMPTY_SORTED_SET;
        }

        public Object first() {
            throw new NoSuchElementException();
        }

        public Object last() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof SortedSet && ((SortedSet)o).size() == 0;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

