/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.Notations;
import de.unkrig.commons.text.pattern.Glob;
import de.unkrig.commons.text.pattern.Pattern2;
import de.unkrig.commons.text.pattern.PatternUtil;
import de.unkrig.commons.util.annotation.CommandLineOption;
import de.unkrig.commons.util.annotation.RegexFlags;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class CommandLineOptions {
    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private CommandLineOptions() {
    }

    public static String[] parse(String[] args, Object target) {
        int idx = 0;
        while (idx < args.length) {
            String arg = args[idx];
            if ("--".equals(arg)) {
                ++idx;
                break;
            }
            if ("-".equals(arg)) break;
            Method method = CommandLineOptions.getMethodForOption(arg, target.getClass());
            if (method != null) {
                idx = CommandLineOptions.applyCommandLineOption(arg, method, args, idx + 1, target);
                continue;
            }
            if (arg.length() >= 2 && arg.charAt(0) == '-' && arg.charAt(1) != '-') {
                ++idx;
                int i = 1;
                while (i < arg.length()) {
                    String optionName = "-" + arg.charAt(i);
                    method = CommandLineOptions.getMethodForOption(optionName, target.getClass());
                    if (method == null) {
                        throw new IllegalArgumentException("Unrecognized command line option \"" + arg + "\"; try \"--help\"");
                    }
                    idx = CommandLineOptions.applyCommandLineOption(optionName, method, args, idx, target);
                    ++i;
                }
                continue;
            }
            if (args[idx].startsWith("-")) {
                throw new IllegalArgumentException("Unrecognized command line option \"" + args[idx] + "\"; try \"--help\"");
            }
            return idx == 0 ? args : Arrays.copyOfRange(args, idx, args.length);
        }
        return new String[0];
    }

    @Nullable
    public static Method getMethodForOption(String option, Class<?> targetClass) {
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            CommandLineOption clo = m.getAnnotation(CommandLineOption.class);
            if (clo != null) {
                String[] names = clo.name();
                if (names.length == 0) {
                    String n3 = m.getName();
                    if (n3.startsWith("set")) {
                        n3 = n3.substring(3);
                    } else if (n3.startsWith("add")) {
                        n3 = n3.substring(3);
                    }
                    names = new String[]{Notations.fromCamelCase(n3).toLowerCaseHyphenated()};
                }
                String[] stringArray = names;
                int n4 = names.length;
                int n5 = 0;
                while (n5 < n4) {
                    String[] stringArray2;
                    String name = stringArray[n5];
                    if (name.startsWith("-")) {
                        String[] stringArray3 = new String[1];
                        stringArray2 = stringArray3;
                        stringArray3[0] = name;
                    } else {
                        String[] stringArray4 = new String[2];
                        stringArray4[0] = "-" + name;
                        stringArray2 = stringArray4;
                        stringArray4[1] = "--" + name;
                    }
                    String[] stringArray5 = stringArray2;
                    int n6 = stringArray2.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        String name2 = stringArray5[n7];
                        if (name2.equals(option)) {
                            return m;
                        }
                        ++n7;
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        return null;
    }

    public static int applyCommandLineOption(String optionName, Method method, String[] args, int optionArgumentIndex, @Nullable Object target) {
        Class<?>[] methodParametersTypes = method.getParameterTypes();
        Annotation[][] methodParametersAnnotations = method.getParameterAnnotations();
        assert (methodParametersTypes.length == methodParametersAnnotations.length);
        Object[] methodArgs = new Object[methodParametersTypes.length];
        if (methodParametersTypes.length >= 1 && method.isVarArgs()) {
            Class<?> componentType = methodParametersTypes[methodArgs.length - 1].getComponentType();
            if (optionArgumentIndex + methodParametersTypes.length - 1 > args.length) {
                throw new IllegalArgumentException("Command line option \"" + optionName + "\" requires at least " + (methodParametersTypes.length - 1) + "\" arguments, but only " + (args.length - optionArgumentIndex) + " are available on the command line");
            }
            int i = 0;
            while (i < methodArgs.length - 1) {
                methodArgs[i] = CommandLineOptions.fromString(args[optionArgumentIndex++], methodParametersTypes[i], methodParametersAnnotations[i]);
                ++i;
            }
            int arrayLength = args.length - optionArgumentIndex;
            Object array = Array.newInstance(componentType, arrayLength);
            int i2 = 0;
            while (i2 < arrayLength) {
                Array.set(array, i2, CommandLineOptions.fromString(args[optionArgumentIndex++], componentType, methodParametersAnnotations[methodArgs.length - 1]));
                ++i2;
            }
            methodArgs[methodArgs.length - 1] = array;
        } else {
            if (optionArgumentIndex + methodParametersTypes.length > args.length) {
                throw new IllegalArgumentException("Command line option \"" + optionName + "\" requires " + methodParametersTypes.length + "\" arguments, but only " + (args.length - optionArgumentIndex) + " are available on the command line");
            }
            int i = 0;
            while (i < methodArgs.length) {
                methodArgs[i] = CommandLineOptions.fromString(args[optionArgumentIndex++], methodParametersTypes[i], methodParametersAnnotations[i]);
                ++i;
            }
        }
        try {
            method.invoke(target, methodArgs);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return optionArgumentIndex;
    }

    private static <T> T fromString(String text, Class<T> targetType, Annotation[] annotations) {
        if (targetType == Pattern.class) {
            return (T)Pattern2.compile(text, CommandLineOptions.getRegexFlags(annotations));
        }
        if (targetType == Glob.class) {
            return (T)Glob.compile(text, CommandLineOptions.getRegexFlags(annotations));
        }
        return ObjectUtil.fromString(text, targetType);
    }

    private static int getRegexFlags(Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a.annotationType() == RegexFlags.class) {
                return ((RegexFlags)a).value();
            }
            ++n2;
        }
        return 0;
    }

    public static void printResource(Class<?> baseClass, String relativeResourceName, @Nullable Charset resourceCharset, PrintStream printStream) throws IOException {
        String resourceName = String.valueOf(baseClass.getSimpleName()) + "." + relativeResourceName;
        InputStream is = baseClass.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter(printStream);
            PatternUtil.replaceSystemProperties(resourceCharset == null ? new InputStreamReader(is) : new InputStreamReader(is, resourceCharset), w);
            ((Writer)w).flush();
        }
        finally {
            is.close();
        }
    }
}

