/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.text;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.text.AbstractPrinter;
import de.unkrig.commons.text.Printer;
import de.unkrig.commons.text.ProxyPrinter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class Printers {
    private static final Printer DEFAULT_PRINTER = new AbstractPrinter(){

        @Override
        public void error(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void warn(@Nullable String message) {
            System.err.println(message);
        }

        @Override
        public void info(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void verbose(@Nullable String message) {
            System.out.println(message);
        }

        @Override
        public void debug(@Nullable String message) {
            System.out.println(message);
        }
    };
    private static final ThreadLocal<Printer> THREAD_LOCAL_PRINTER = new InheritableThreadLocal<Printer>(){

        @Override
        protected Printer initialValue() {
            return DEFAULT_PRINTER;
        }
    };

    private Printers() {
    }

    public static Printer get() {
        return THREAD_LOCAL_PRINTER.get();
    }

    public static void error(@Nullable String message) {
        Printers.get().error(message);
    }

    public static void error(String pattern, Object ... arguments) {
        Printers.get().error(pattern, arguments);
    }

    public static void error(@Nullable String message, Throwable t) {
        Printers.get().error(message, t);
    }

    public static void error(String pattern, Throwable t, Object ... arguments) {
        Printers.get().error(pattern, t, arguments);
    }

    public static void warn(@Nullable String message) {
        Printers.get().warn(message);
    }

    public static void warn(String pattern, Object ... arguments) {
        Printers.get().warn(pattern, arguments);
    }

    public static void info(@Nullable String message) {
        Printers.get().info(message);
    }

    public static void info(String pattern, Object ... arguments) {
        Printers.get().info(pattern, arguments);
    }

    public static void verbose(@Nullable String message) {
        Printers.get().verbose(message);
    }

    public static void verbose(String pattern, Object ... arguments) {
        Printers.get().verbose(pattern, arguments);
    }

    public static void debug(@Nullable String message) {
        Printers.get().debug(message);
    }

    public static void debug(String pattern, Object ... arguments) {
        Printers.get().debug(pattern, arguments);
    }

    public static synchronized void withPrinter(Printer printer, Runnable runnable) {
        Printer oldThreadPrinter = Printers.get();
        Printers.set(printer);
        try {
            runnable.run();
        }
        finally {
            Printers.set(oldThreadPrinter);
        }
    }

    public static synchronized <EX extends Exception> void withPrinter(Printer printer, RunnableWhichThrows<EX> runnable) throws EX {
        Printer oldThreadPrinter = Printers.get();
        Printers.set(printer);
        try {
            runnable.run();
        }
        finally {
            Printers.set(oldThreadPrinter);
        }
    }

    public static <EX extends Exception> void redirectInfoToFile(@Nullable File file, RunnableWhichThrows<EX> runnable) throws IOException, EX {
        if (file == null) {
            runnable.run();
            return;
        }
        PrintWriter pw = new PrintWriter(file);
        try {
            Printers.redirectInfo(pw, runnable);
            pw.close();
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }

    public static <EX extends Exception> void redirectInfo(@Nullable Writer writer, RunnableWhichThrows<EX> runnable) throws EX {
        if (writer == null) {
            runnable.run();
            return;
        }
        final PrintWriter pw = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        Printers.withPrinter((Printer)new ProxyPrinter(Printers.get()){

            @Override
            public void info(@Nullable String message) {
                pw.println(message);
            }
        }, runnable);
    }

    public static <EX extends Exception> void redirectInfo(final @Nullable ConsumerWhichThrows<? super String, ? extends RuntimeException> infoConsumer, RunnableWhichThrows<? extends EX> runnable) throws EX {
        if (infoConsumer == null) {
            runnable.run();
            return;
        }
        Printers.withPrinter((Printer)new ProxyPrinter(Printers.get()){

            @Override
            public void info(@Nullable String message) {
                if (message != null) {
                    infoConsumer.consume(message);
                }
            }
        }, runnable);
    }

    private static void set(Printer printer) {
        THREAD_LOCAL_PRINTER.set(printer);
    }
}

