/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp.ftplett;

import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.net.ftp.ftplett.Ftplett;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Formatter;
import java.util.logging.Logger;

public class FileFtplett
implements Ftplett {
    private static final Logger LOGGER = Logger.getLogger(FileFtplett.class.getName());
    private final File rootDirectory;
    private String currentWorkingDirectory = "/";

    public FileFtplett(File rootDirectory) throws IOException {
        this.rootDirectory = rootDirectory.getCanonicalFile();
    }

    @Override
    public boolean changeWorkingDirectory(@Nullable String directoryName) throws IOException {
        if (directoryName == null) {
            this.currentWorkingDirectory = "/";
            return true;
        }
        if (!this.toFile(directoryName).isDirectory()) {
            return false;
        }
        this.currentWorkingDirectory = directoryName;
        return true;
    }

    @Override
    public String getWorkingDirectory() {
        return this.currentWorkingDirectory;
    }

    @Override
    @Nullable
    public InputStream retrieve(String fileName) throws IOException {
        File file = this.toFile(fileName);
        if (!file.isFile()) {
            return null;
        }
        return new FileInputStream(file);
    }

    @Override
    public OutputStream store(String fileName) throws IOException {
        File file = this.toFile(fileName);
        return new FileOutputStream(file);
    }

    @Override
    public boolean list(@Nullable String name, ConsumerWhichThrows<String, IOException> out) throws IOException {
        File file = this.toFile(name);
        if (file.isFile()) {
            FileFtplett.list(file, out);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File member = fileArray[n2];
                FileFtplett.list(member, out);
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean nameList(@Nullable String name, ConsumerWhichThrows<String, IOException> out) throws IOException {
        File file = this.toFile(name);
        if (file.isFile()) {
            FileFtplett.nameList(file, out);
        } else if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File member = fileArray[n2];
                FileFtplett.nameList(member, out);
                ++n2;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean delete(String resourceName) throws IOException {
        return this.toFile(resourceName).delete();
    }

    @Override
    public boolean rename(String from, String to) throws IOException {
        return this.toFile(from).renameTo(this.toFile(to));
    }

    @Override
    @Nullable
    public Date getModificationTime(String resourceName) throws IOException {
        long lm = this.toFile(resourceName).lastModified();
        return lm == 0L ? null : new Date(lm);
    }

    private static void list(File member, ConsumerWhichThrows<String, IOException> out) throws IOException {
        Formatter formatter = new Formatter();
        String line = formatter.format("%1$tm-%1$td-%1$ty %1$tI:%1$tM%1$Tp  %2$20s %3$s", new Date(member.lastModified()), member.isDirectory() ? "<DIR>" : (member.isFile() ? Long.valueOf(member.length()) : "???"), member.getName()).toString();
        formatter.close();
        LOGGER.fine("  >>> " + line);
        out.consume(line);
    }

    private static void nameList(File member, ConsumerWhichThrows<String, IOException> out) throws IOException {
        String line = member.getName();
        LOGGER.fine("  >>> " + line);
        out.consume(line);
    }

    private File toFile(@Nullable String path) throws IOException {
        File file = path == null ? new File(this.rootDirectory, this.currentWorkingDirectory) : (path.startsWith("/") || path.startsWith("\\") ? new File(this.rootDirectory, path) : new File(this.rootDirectory, String.valueOf(this.currentWorkingDirectory) + File.separatorChar + path));
        if (!FileFtplett.isDescendantOf(file = file.getCanonicalFile(), this.rootDirectory) && !file.equals(this.rootDirectory)) {
            return this.rootDirectory;
        }
        return file;
    }

    private static boolean isDescendantOf(File file1, File file2) {
        File f = file1.getParentFile();
        while (f != null) {
            if (f.equals(file2)) {
                return true;
            }
            f = f.getParentFile();
        }
        return false;
    }
}

