/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.ftp;

import de.unkrig.commons.io.HexOutputStream;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.ReverseProxy;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.logging.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataConnectionProxy {
    private static final Logger LOGGER = Logger.getLogger(DataConnectionProxy.class.getName());
    @Nullable
    private ReverseProxy reverseProxy;
    private static int firstDataConnectionPort;
    private static int lastDataConnectionPort;
    @Nullable
    private static AtomicInteger nextDataConnectionPort;

    public static void setLocalPortRange(int first, int last) {
        if (nextDataConnectionPort != null) {
            throw new IllegalStateException("'setDataConnectionLocalPortRange()' must not be invoked after the first call to 'start()'");
        }
        firstDataConnectionPort = first;
        lastDataConnectionPort = last;
    }

    public InetSocketAddress start(InetAddress bindAddress, InetSocketAddress remoteAddress) throws IOException {
        this.stop();
        AtomicInteger port = nextDataConnectionPort;
        if (port == null) {
            nextDataConnectionPort = port = new AtomicInteger(firstDataConnectionPort);
        }
        int firstTriedPort = -1;
        while (true) {
            int port2;
            int n = port.compareAndSet(lastDataConnectionPort, firstDataConnectionPort) ? firstDataConnectionPort : (port2 = firstDataConnectionPort < lastDataConnectionPort ? port.getAndIncrement() : port.getAndDecrement());
            if (firstTriedPort == -1) {
                firstTriedPort = port2;
            }
            try {
                InetSocketAddress endpoint = new InetSocketAddress(bindAddress, port2);
                ReverseProxy rp = this.reverseProxy = new ReverseProxy(endpoint, 0, remoteAddress, Proxy.NO_PROXY, 20000, new ReverseProxy.ProxyConnectionHandler(){

                    @Override
                    public void handleConnection(InputStream clientIn, OutputStream clientOut, InputStream serverIn, OutputStream serverOut, InetSocketAddress clientLocalSocketAddress, InetSocketAddress clientRemoteSocketAddress, InetSocketAddress serverLocalSocketAddress, InetSocketAddress serverRemoteSocketAddress, Stoppable stoppable) throws IOException {
                        ThreadUtil.parallel(IoUtil.copyRunnable(clientIn, IoUtil.tee(serverOut, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINER, "> ")))), IoUtil.copyRunnable(serverIn, IoUtil.tee(clientOut, new HexOutputStream(LogUtil.logWriter(LOGGER, Level.FINER, "< ")))), stoppable);
                    }
                });
                ThreadUtil.runInBackground(rp, Thread.currentThread().getName());
                return rp.getEndpointAddress();
            }
            catch (BindException be) {
                if (!be.getMessage().startsWith("Address already in use") || port2 != firstTriedPort) {
                    throw be;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, "Port {0} is in use; trying next", port2);
                continue;
            }
            break;
        }
    }

    void stop() {
        ReverseProxy rp = this.reverseProxy;
        if (rp != null) {
            rp.stop();
        }
    }
}

