/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.Transformer;
import de.unkrig.commons.lang.protocol.TransformerWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public final class ProducerUtil {
    private ProducerUtil() {
    }

    public static <T, ST> Producer<T> sparingProducer(final Producer<? extends T> delegate, final Predicate<? super ST> condition, final ST subject) {
        return new Producer<T>(){
            @Nullable
            private T product;

            @Override
            @Nullable
            public T produce() {
                if (condition.evaluate(subject)) {
                    this.product = delegate.produce();
                }
                return this.product;
            }
        };
    }

    public static Producer<Boolean> every(final long interval) {
        return new Producer<Boolean>(){
            private long expirationTime;

            @Override
            @Nullable
            public synchronized Boolean produce() {
                long now = System.currentTimeMillis();
                if (now >= this.expirationTime) {
                    this.expirationTime = now + interval;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T, EX extends Throwable> ProducerWhichThrows<T, EX> asProducerWhichThrows(Producer<? extends T> source) {
        Producer<? extends T> result = source;
        return result;
    }

    public static <T> Producer<T> asProducer(ProducerWhichThrows<? extends T, ? extends RuntimeException> source) {
        Producer result = (Producer)source;
        return result;
    }

    public static <T> Producer<T> fromElements(final T ... elements) {
        return new Producer<T>(){
            int idx;

            @Override
            @Nullable
            public T produce() {
                return this.idx == elements.length ? null : elements[this.idx++];
            }
        };
    }

    public static <T> Producer<T> fromCollection(final Collection<T> delegate) {
        return new Producer<T>(){

            @Override
            @Nullable
            public T produce() {
                Iterator it = delegate.iterator();
                if (!it.hasNext()) {
                    return null;
                }
                Object product = it.next();
                it.remove();
                return product;
            }
        };
    }

    public static <T> Producer<T> fromArray(T[] delegate) {
        return ProducerUtil.fromArray(delegate, 0, delegate.length);
    }

    public static <T> Producer<T> fromArray(final T[] delegate, int from, final int to) {
        if (from < 0 || to < from || to > delegate.length) {
            throw new IllegalArgumentException();
        }
        return new Producer<T>(from){
            int idx;
            {
                this.idx = n;
            }

            @Override
            @Nullable
            public T produce() {
                return this.idx < to ? delegate[this.idx++] : null;
            }
        };
    }

    public static <T> Producer<T> fromIterator(final Iterator<T> iterator) {
        return new Producer<T>(){

            @Override
            @Nullable
            public T produce() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    public static <T> Producer<T> fromIndexTransformer(final Transformer<? super Integer, T> indexTransformer) {
        return new Producer<T>(){
            private int index;

            @Override
            @Nullable
            public T produce() {
                return indexTransformer.transform(this.index++);
            }
        };
    }

    public static <T, EX extends Exception> ProducerWhichThrows<T, EX> fromIndexTransformer(final TransformerWhichThrows<? super Integer, T, EX> indexTransformer) {
        return new ProducerWhichThrows<T, EX>(){
            private int index;

            @Override
            @Nullable
            public T produce() throws Exception {
                return indexTransformer.transform(this.index++);
            }
        };
    }

    public static Producer<Byte> randomByteProducer(long seed) {
        return new Producer<Byte>(seed){
            final Random r;
            {
                this.r = new Random(l);
            }

            @Override
            public Byte produce() {
                return (byte)this.r.nextInt(256);
            }
        };
    }

    public static <T> Producer<T> constantProducer(final T constant) {
        return new Producer<T>(){

            @Override
            public T produce() {
                return constant;
            }
        };
    }

    public static <T> Producer<T> compress(final Producer<? extends T> delegate, final Predicate<? super T> compressable, final T compressed) {
        return new Producer<T>(){
            boolean initial = true;
            @Nullable
            T lookahead;

            @Override
            @Nullable
            public T produce() {
                if (this.initial) {
                    Object product;
                    do {
                        if ((product = delegate.produce()) != null) continue;
                        return null;
                    } while (compressable.evaluate(product));
                    this.initial = false;
                    return product;
                }
                Object tmp = this.lookahead;
                if (tmp != null) {
                    this.lookahead = null;
                    return tmp;
                }
                Object product = delegate.produce();
                if (product == null) {
                    return null;
                }
                if (!compressable.evaluate(product)) {
                    return product;
                }
                do {
                    if ((product = delegate.produce()) != null) continue;
                    return null;
                } while (compressable.evaluate(product));
                this.lookahead = product;
                return compressed;
            }
        };
    }

    public static <T> Producer<T> alternate(final T first, final T second) {
        return new Producer<T>(){
            boolean toggle;

            @Override
            @Nullable
            public T produce() {
                this.toggle = !this.toggle;
                return this.toggle ? first : second;
            }
        };
    }

    public static Producer<Integer> increasing() {
        return new Producer<Integer>(){
            int value;

            @Override
            @Nullable
            public Integer produce() {
                return this.value++;
            }
        };
    }

    public static <T> Producer<T> concat(final Producer<? extends T> delegate1, final Producer<? extends T> delegate2) {
        return new Producer<T>(){
            boolean second;

            @Override
            @Nullable
            public T produce() {
                if (this.second) {
                    return delegate2.produce();
                }
                Object product = delegate1.produce();
                if (product != null) {
                    return product;
                }
                this.second = true;
                return delegate2.produce();
            }
        };
    }
}

