/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Mapping;
import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.PredicateWhichThrows;
import java.util.Collection;
import java.util.Map;

public final class PredicateUtil {
    private static final Predicate ALWAYS = new Predicate(){

        public boolean evaluate(Object subject) {
            return true;
        }

        public String toString() {
            return "ALWAYS";
        }
    };
    private static final Predicate NEVER = new Predicate(){

        public boolean evaluate(Object subject) {
            return false;
        }

        public String toString() {
            return "NEVER";
        }
    };

    private PredicateUtil() {
    }

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    public static <T> Predicate<T> atMostEvery(final long milliseconds) {
        return new Predicate<T>(){
            long next;

            @Override
            public boolean evaluate(T subject) {
                long now = System.currentTimeMillis();
                if (now < this.next) {
                    return false;
                }
                this.next = now + milliseconds;
                return true;
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        if (p1 == NEVER || p2 == NEVER) {
            return NEVER;
        }
        if (p1 == ALWAYS) {
            return p2;
        }
        if (p2 == ALWAYS) {
            return p1;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return p1.evaluate(subject) && p2.evaluate(subject);
            }

            public String toString() {
                return p1 + " && " + p2;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        if (p1 == ALWAYS || p2 == ALWAYS) {
            return ALWAYS;
        }
        if (p1 == NEVER) {
            return p2;
        }
        if (p2 == NEVER) {
            return p1;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return p1.evaluate(subject) || p2.evaluate(subject);
            }

            public String toString() {
                return p1 + " || " + p2;
            }
        };
    }

    public static <T> Predicate<T> not(final Predicate<? super T> delegate) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return !delegate.evaluate(subject);
            }

            public String toString() {
                return "!" + delegate;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> less(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) > 0;
            }

            public String toString() {
                return "< " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> lessEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) >= 0;
            }

            public String toString() {
                return "<= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> greater(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) < 0;
            }

            public String toString() {
                return "> " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> greaterEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) <= 0;
            }

            public String toString() {
                return ">= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> equal(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) == 0;
            }

            public String toString() {
                return "== " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> notEqual(final C other) {
        return new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return other.compareTo(subject) != 0;
            }

            public String toString() {
                return "!= " + other;
            }
        };
    }

    public static <C extends Comparable<C>> Predicate<C> between(final C min, final C max) {
        return max.compareTo(min) >= 0 ? new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return min.compareTo(subject) <= 0 && max.compareTo(subject) >= 0;
            }

            public String toString() {
                return min + "-" + max;
            }
        } : new Predicate<C>(){

            @Override
            public boolean evaluate(C subject) {
                return min.compareTo(subject) >= 0 || max.compareTo(subject) <= 0;
            }

            public String toString() {
                return min + "-" + max;
            }
        };
    }

    public static <T> Predicate<T> equals(final T other) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return other.equals(subject);
            }

            public String toString() {
                return "eq " + other;
            }
        };
    }

    public static <T> Predicate<T> notEquals(final T other) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return !other.equals(subject);
            }

            public String toString() {
                return "nq " + other;
            }
        };
    }

    public static Predicate<Object> after(final long expirationTime) {
        return new Predicate<Object>(){

            @Override
            public boolean evaluate(Object subject) {
                return System.currentTimeMillis() > expirationTime;
            }
        };
    }

    public static <T extends Predicate<String>> T forString(final String format, final T delegate) {
        Predicate<String> result = new Predicate<String>(){

            @Override
            public boolean evaluate(String subject) {
                return delegate.evaluate(format.replace("*", subject));
            }
        };
        return (T)result;
    }

    public static <T, EX extends Throwable> PredicateWhichThrows<T, EX> asPredicateWhichThrows(final Predicate<? super T> source) {
        return new PredicateWhichThrows<T, EX>(){

            @Override
            public boolean evaluate(T subject) {
                return source.evaluate(subject);
            }
        };
    }

    public static <T, EX extends RuntimeException> Predicate<T> asPredicate(final PredicateWhichThrows<T, EX> source) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return source.evaluate(subject);
            }
        };
    }

    public static <T> Predicate<T> contains(final Collection<? extends T> collection) {
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return collection.contains(subject);
            }
        };
    }

    public static <K> Predicate<K> containsKey(final Map<K, ?> map) {
        return new Predicate<K>(){

            @Override
            public boolean evaluate(K subject) {
                return map.containsKey(subject);
            }
        };
    }

    public static <K> Predicate<K> containsKey(final Mapping<K, ?> mapping) {
        return new Predicate<K>(){

            @Override
            public boolean evaluate(K subject) {
                return mapping.containsKey(subject);
            }
        };
    }
}

