/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Function;
import de.unkrig.commons.lang.protocol.FunctionWhichThrows;
import de.unkrig.commons.nullanalysis.Nullable;

public final class Functions {
    private static final Function IDENTITY;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        IDENTITY = new Function(){

            @Override
            @Nullable
            public Object call(@Nullable Object argument) {
                return argument;
            }
        };
    }

    private Functions() {
    }

    public static <O, I extends O> Function<I, O> identity() {
        return IDENTITY;
    }

    public static <I, O, EX extends Throwable> FunctionWhichThrows<I, O, EX> asFunctionWhichThrows(final Function<? super I, ? extends O> source) {
        return new FunctionWhichThrows<I, O, EX>(){

            @Override
            @Nullable
            public O call(@Nullable I argument) {
                return source.call(argument);
            }
        };
    }

    public static <I, O, EX extends RuntimeException> Function<I, O> asFunction(final FunctionWhichThrows<? super I, ? extends O, EX> source) {
        return new Function<I, O>(){

            @Override
            @Nullable
            public O call(@Nullable I argument) {
                return source.call(argument);
            }
        };
    }
}

