/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.nullanalysis.Nullable;
import org.xml.sax.SAXParseException;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static <T extends Throwable> T wrap(@Nullable String prefix, T cause) {
        Throwable wrapping;
        block8: {
            Class<?> causeClass = cause.getClass();
            String causeMessage = cause.getMessage();
            String message = prefix == null ? causeMessage : (causeMessage == null ? prefix : String.valueOf(prefix) + ": " + causeMessage);
            try {
                wrapping = (Throwable)causeClass.getConstructor(String.class, Throwable.class).newInstance(message, cause);
            }
            catch (Exception e) {
                try {
                    wrapping = (Throwable)causeClass.getConstructor(String.class).newInstance(message);
                    wrapping.initCause(cause);
                }
                catch (Exception e2) {
                    try {
                        wrapping = (Throwable)causeClass.getConstructor(Object.class).newInstance(message);
                        wrapping.initCause(cause);
                    }
                    catch (Exception e3) {
                        if (cause instanceof SAXParseException) {
                            SAXParseException spe = (SAXParseException)cause;
                            wrapping = new SAXParseException(message, spe.getPublicId(), spe.getSystemId(), spe.getLineNumber(), spe.getColumnNumber());
                            wrapping.initCause(cause);
                            break block8;
                        }
                        return cause;
                    }
                }
            }
        }
        StackTraceElement[] st = wrapping.getStackTrace();
        int i = 0;
        while (true) {
            if ("wrap".equals(st[i].getMethodName())) break;
            ++i;
        }
        StackTraceElement[] st2 = new StackTraceElement[st.length - ++i];
        System.arraycopy(st, i, st2, 0, st2.length);
        wrapping.setStackTrace(st2);
        return (T)wrapping;
    }

    public static <T extends Throwable> T wrap(@Nullable String prefix, Throwable cause, Class<T> wrapperClass) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix).append(": ");
        }
        sb.append(cause.getClass().getName());
        String causeMessage = cause.getMessage();
        if (causeMessage != null) {
            sb.append(": ").append(causeMessage);
        } else {
            Throwable t = cause.getCause();
            while (t != null) {
                sb.append(": ").append(t.getClass().getName());
                String tMessage = t.getMessage();
                if (tMessage != null) {
                    sb.append(": ").append(tMessage);
                    break;
                }
                t = t.getCause();
            }
        }
        String message = sb.toString();
        try {
            return (T)((Throwable)wrapperClass.getConstructor(String.class, Throwable.class).newInstance(message, cause));
        }
        catch (Exception tMessage) {
            try {
                Throwable wrapper = (Throwable)wrapperClass.getConstructor(String.class).newInstance(message);
                wrapper.initCause(cause);
                return (T)wrapper;
            }
            catch (Exception wrapper) {
                try {
                    Throwable wrapper2 = (Throwable)wrapperClass.newInstance();
                    wrapper2.initCause(cause);
                    return (T)wrapper2;
                }
                catch (Exception exception) {
                    throw new Error("Exception class '" + wrapperClass.getName() + "' has no suitable constructor");
                }
            }
        }
    }

    public static void throwUndeclared(Exception e) {
        ExceptionUtil.throwUndeclared2(e);
    }

    private static <EX extends Exception> void throwUndeclared2(Exception e) throws EX {
        throw e;
    }

    public static <T, EX extends Throwable> T throW(EX throwable) throws EX {
        throw throwable;
    }

    public static <T> T throwAssertionError(Object object) {
        throw new AssertionError(object);
    }
}

