/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

@NotNullByDefault(value=false)
public class XMLFormatterWriter
extends FilterWriter {
    private int state;
    private int indentation;

    public XMLFormatterWriter(Writer out) {
        super(out);
    }

    @Override
    public void write(int c) throws IOException {
        switch (this.state) {
            case 0: {
                if (c != 60) break;
                this.state = 1;
                break;
            }
            case 1: {
                this.state = c == 47 ? 2 : 5;
                break;
            }
            case 2: {
                if (c != 62) break;
                this.state = 3;
                break;
            }
            case 3: {
                if (c == 32) break;
                if (c == 60) {
                    this.state = 4;
                    return;
                }
                this.state = 0;
                return;
            }
            case 4: {
                this.out.write("\r\n");
                if (c == 47 && this.indentation > 0) {
                    --this.indentation;
                }
                int i = 0;
                while (i < this.indentation) {
                    this.out.write("  ");
                    ++i;
                }
                this.out.write(60);
                this.state = c == 47 ? 2 : 5;
                break;
            }
            case 5: {
                if (c == 47) {
                    this.state = 6;
                    break;
                }
                if (c != 62) break;
                this.state = 9;
                break;
            }
            case 6: {
                this.state = c == 62 ? 7 : 5;
                break;
            }
            case 7: {
                if (c == 32) break;
                if (c == 60) {
                    this.state = 8;
                    return;
                }
                this.state = 0;
                break;
            }
            case 8: {
                this.out.write("\r\n");
                if (c == 47 && this.indentation > 0) {
                    --this.indentation;
                }
                int i = 0;
                while (i < this.indentation) {
                    this.out.write("  ");
                    ++i;
                }
                this.out.write(60);
                this.state = c == 47 ? 2 : 5;
                break;
            }
            case 9: {
                if (c == 32) break;
                if (c == 60) {
                    this.state = 10;
                    return;
                }
                this.state = 0;
                break;
            }
            case 10: {
                this.out.write("\r\n");
                if (c != 47) {
                    ++this.indentation;
                }
                int i = 0;
                while (i < this.indentation) {
                    this.out.write("  ");
                    ++i;
                }
                this.out.write(60);
                this.state = c == 47 ? 2 : 5;
            }
        }
        this.out.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(cbuf[i]);
            ++i;
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int i = off;
        while (i < off + len) {
            this.write(str.charAt(i));
            ++i;
        }
    }
}

