/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.io;

import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerUtil;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.ProducerUtil;
import de.unkrig.commons.lang.protocol.ProducerWhichThrows;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import de.unkrig.commons.nullanalysis.NotNullByDefault;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public final class IoUtil {
    private static final Logger LOGGER;
    private static final ExecutorService EXECUTOR_SERVICE;
    public static final InputStream EMPTY_INPUT_STREAM;
    public static final OutputStream NULL_OUTPUT_STREAM;
    public static final InputStream ZERO_INPUT_STREAM;
    private static final long[] THRESHOLDS;

    static {
        AssertionUtil.enableAssertionsForThisClass();
        LOGGER = Logger.getLogger(IoUtil.class.getName());
        EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(3 * Runtime.getRuntime().availableProcessors());
        EMPTY_INPUT_STREAM = new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int read(@Nullable byte[] buf, int off, int len) {
                return -1;
            }
        };
        NULL_OUTPUT_STREAM = new OutputStream(){

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
            }

            @Override
            public void write(int b) {
            }
        };
        ZERO_INPUT_STREAM = IoUtil.constantInputStream((byte)0);
        THRESHOLDS = new long[126];
        long x = 2L;
        int i = 0;
        while (i < THRESHOLDS.length) {
            IoUtil.THRESHOLDS[i++] = x;
            IoUtil.THRESHOLDS[i++] = x + (x >> 1);
            x <<= 1;
        }
    }

    private IoUtil() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap(String.valueOf(count) + " bytes copied so far", ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        try {
            long count = IoUtil.copy(inputStream, outputStream, Long.MAX_VALUE);
            if (closeInputStream) {
                inputStream.close();
            }
            if (closeOutputStream) {
                outputStream.close();
            }
            return count;
        }
        catch (IOException ioe) {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public static RunnableWhichThrows<IOException> copyRunnable(final InputStream in, final OutputStream out) {
        return new RunnableWhichThrows<IOException>(){

            @Override
            public void run() throws IOException {
                IoUtil.copy(in, out);
            }
        };
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, false, writer, false);
    }

    public static long copy(Reader reader, boolean closeReader, Writer writer, boolean closeWriter) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        try {
            while (true) {
                LOGGER.log(Level.FINEST, "About to ''read(char[{0}])''", buffer.length);
                int n = reader.read(buffer);
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", n);
                if (n == -1) break;
                LOGGER.log(Level.FINEST, "About to ''write(char[{0}])''", n);
                writer.write(buffer, 0, n);
                LOGGER.log(Level.FINEST, "'write()' returned");
            }
            writer.flush();
            if (closeReader) {
                reader.close();
            }
            if (closeWriter) {
                writer.close();
            }
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeWriter) {
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ExceptionUtil.wrap(String.valueOf(count) + " characters copied so far", ioe);
        }
    }

    public static long copy(Reader reader, OutputStream outputStream, Charset charset) throws IOException {
        return IoUtil.copy(reader, new OutputStreamWriter(outputStream, charset));
    }

    public static long copy(Readable r, Appendable a) throws IOException {
        int n;
        CharBuffer cb = CharBuffer.allocate(4096);
        long count = 0L;
        while ((n = r.read(cb)) != -1) {
            cb.flip();
            a.append(cb);
            count += (long)n;
            cb.clear();
        }
        return count;
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile, boolean append) throws IOException {
        try {
            return IoUtil.copy(inputStream, closeInputStream, new FileOutputStream(outputFile, append), true);
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static long copy(Reader reader, boolean closeReader, File outputFile, boolean append, Charset outputCharset) throws IOException {
        try {
            long count = IoUtil.copy(reader, closeReader, new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, append), outputCharset), true);
            LOGGER.log(Level.FINEST, "{0} bytes copied", count);
            return count;
        }
        catch (IOException ioe) {
            outputFile.delete();
            throw ioe;
        }
        catch (RuntimeException re) {
            outputFile.delete();
            throw re;
        }
    }

    public static long copy(File inputFile, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        FileInputStream is;
        try {
            is = new FileInputStream(inputFile);
        }
        catch (IOException ioe) {
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
        return IoUtil.copy((InputStream)is, true, outputStream, closeOutputStream);
    }

    public static long copy(InputStream inputStream, boolean closeInputStream, File outputFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outputFile);
        try {
            return IoUtil.copy(inputStream, closeInputStream, os, true);
        }
        catch (IOException ioe) {
            if (!outputFile.delete()) {
                throw new IOException("Cannot delete '" + outputFile + "'");
            }
            throw ioe;
        }
    }

    public static long copy(File inputFile, File outFile) throws IOException {
        return IoUtil.copy((InputStream)new FileInputStream(inputFile), true, outFile);
    }

    public static ConsumerWhichThrows<OutputStream, IOException> copyFrom(final InputStream is) {
        return new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream os) throws IOException {
                IoUtil.copy(is, os);
            }
        };
    }

    @NotNullByDefault(value=false)
    public static OutputStream tee(final OutputStream ... delegates) {
        return new OutputStream(){

            @Override
            public void close() throws IOException {
                IOException caughtIOException = null;
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    try {
                        delegate.close();
                    }
                    catch (IOException ioe) {
                        caughtIOException = ioe;
                    }
                    ++n2;
                }
                if (caughtIOException != null) {
                    throw caughtIOException;
                }
            }

            @Override
            public void flush() throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.flush();
                    ++n2;
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b, off, len);
                    ++n2;
                }
            }

            @Override
            public void write(int b) throws IOException {
                OutputStream[] outputStreamArray = delegates;
                int n = delegates.length;
                int n2 = 0;
                while (n2 < n) {
                    OutputStream delegate = outputStreamArray[n2];
                    delegate.write(b);
                    ++n2;
                }
            }
        };
    }

    public static InputStream wye(InputStream in, final OutputStream out) {
        return new FilterInputStream(in){

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1) {
                    out.flush();
                } else {
                    out.write(b);
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count > 0) {
                    out.write(b, off, count);
                }
                if (count == 0) {
                    out.flush();
                }
                return count;
            }

            @Override
            public int available() throws IOException {
                out.flush();
                return this.in.available();
            }
        };
    }

    public static long writeAndCount(ConsumerWhichThrows<? super OutputStream, ? extends IOException> writeContents, OutputStream os) throws IOException {
        ConsumerUtil.Produmer count = ConsumerUtil.store();
        writeContents.consume(IoUtil.tee(os, IoUtil.lengthWritten(ConsumerUtil.cumulate(count, 0L))));
        Long result = (Long)count.produce();
        return result == null ? 0L : result;
    }

    public static void parallel(WritingRunnable[] writingRunnables, Writer writer) {
        List<Callable<Void>> callables = IoUtil.toCallables(writingRunnables, writer);
        try {
            EXECUTOR_SERVICE.invokeAll(callables);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private static List<Callable<Void>> toCallables(WritingRunnable[] writingRunnables, final Writer writer) {
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(writingRunnables.length + 1);
        final ArrayList<PipedReader> readers = new ArrayList<PipedReader>(writingRunnables.length);
        callables.add(new Callable<Void>(){

            @Override
            @Nullable
            public Void call() throws Exception {
                for (Reader reader : readers) {
                    IoUtil.copy(reader, writer);
                }
                return null;
            }
        });
        WritingRunnable[] writingRunnableArray = writingRunnables;
        int n = writingRunnables.length;
        int n2 = 0;
        while (n2 < n) {
            final WritingRunnable wr = writingRunnableArray[n2];
            final PipedWriter pw = new PipedWriter();
            try {
                readers.add(new PipedReader(pw));
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Should never throw an IOException if the argument is a 'fresh' PipedWriter", ioe, AssertionError.class);
            }
            callables.add(new Callable<Void>(){

                @Override
                @Nullable
                public Void call() throws Exception {
                    try {
                        wr.run(pw);
                        return null;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, null, e);
                        throw e;
                    }
                    catch (Error e) {
                        LOGGER.log(Level.SEVERE, null, e);
                        throw e;
                    }
                    finally {
                        try {
                            pw.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            ++n2;
        }
        return callables;
    }

    public static byte[] readAll(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IoUtil.copy(is, baos);
        return baos.toByteArray();
    }

    public static String readAll(InputStream inputStream, Charset charset, boolean closeInputStream) throws IOException {
        StringWriter sw = new StringWriter();
        IoUtil.copy(new InputStreamReader(inputStream, charset), closeInputStream, sw, false);
        return sw.toString();
    }

    public static long skip(InputStream inputStream, long n) throws IOException {
        long result = 0L;
        while (result < n) {
            long skipped = inputStream.skip(n - result);
            if (skipped == 0L) {
                return result;
            }
            result += skipped;
        }
        return result;
    }

    public static long skipAll(InputStream inputStream) throws IOException {
        long result = 0L;
        long skipped;
        while ((skipped = inputStream.skip(Long.MAX_VALUE)) != 0L) {
            result += skipped;
        }
        return result;
    }

    public static OutputStream split(final ProducerWhichThrows<? extends OutputStream, ? extends IOException> delegates, final Producer<? extends Long> byteCountLimits) throws IOException {
        return new OutputStream(){
            private OutputStream delegate;
            private long delegateByteCount;
            {
                this.delegate = AssertionUtil.notNull((OutputStream)producerWhichThrows.produce(), "'delegates' produced <null>");
                this.delegateByteCount = AssertionUtil.notNull((Long)producer.produce(), "'byteCountLimits' produced <null>");
            }

            @Override
            public void write(int b) throws IOException {
                this.write(new byte[]{(byte)b}, 0, 1);
            }

            @Override
            public synchronized void write(@Nullable byte[] b, int off, int len) throws IOException {
                while ((long)len > this.delegateByteCount) {
                    this.delegate.write(b, off, (int)this.delegateByteCount);
                    this.delegate.close();
                    off = (int)((long)off + this.delegateByteCount);
                    len = (int)((long)len - this.delegateByteCount);
                    this.delegate = AssertionUtil.notNull((OutputStream)delegates.produce(), "'delegates' produced <null>");
                    this.delegateByteCount = AssertionUtil.notNull((Long)byteCountLimits.produce(), "'byteCountLimits' produced <null>");
                }
                this.delegate.write(b, off, len);
                this.delegateByteCount -= (long)len;
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
            }
        };
    }

    public static InputStream constantInputStream(final byte b) {
        return new InputStream(){

            @Override
            public int read() {
                return 0;
            }

            @Override
            public int read(@Nullable byte[] buf, int off, int len) {
                Arrays.fill(buf, off, len, b);
                return len;
            }
        };
    }

    public static InputStream unclosableInputStream(InputStream delegate) {
        return new FilterInputStream(delegate){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream unclosableOutputStream(OutputStream delegate) {
        return new FilterOutputStream(delegate){

            @Override
            public void close() {
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }
        };
    }

    public static void fill(OutputStream outputStream, byte b, long count) throws IOException {
        byte[] ba;
        if (count > 8192L) {
            ba = new byte[8192];
            if (b != 0) {
                Arrays.fill(ba, b);
            }
            do {
                outputStream.write(ba);
            } while ((count -= 8192L) > 8192L);
        }
        ba = new byte[(int)count];
        Arrays.fill(ba, b);
        outputStream.write(ba);
    }

    public static InputStream byteProducerInputStream(final ProducerWhichThrows<? extends Byte, ? extends IOException> delegate) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                Byte b = (Byte)delegate.produce();
                return b != null ? 0xFF & b : -1;
            }
        };
    }

    public static InputStream byteProducerInputStream(Producer<? extends Byte> delegate) {
        return IoUtil.byteProducerInputStream(ProducerUtil.asProducerWhichThrows(delegate));
    }

    public static InputStream randomInputStream(long seed) {
        return IoUtil.byteProducerInputStream(ProducerUtil.randomByteProducer(seed));
    }

    public static OutputStream byteConsumerOutputStream(final ConsumerWhichThrows<? super Byte, ? extends IOException> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                delegate.consume((byte)b);
            }
        };
    }

    public static String readAll(Reader reader) throws IOException {
        return IoUtil.readAll(reader, false);
    }

    public static String readAll(Reader reader, boolean closeReader) throws IOException {
        char[] buf = new char[4096];
        StringBuilder sb = new StringBuilder();
        try {
            int n;
            while ((n = reader.read(buf)) != -1) {
                sb.append(buf, 0, n);
            }
            if (closeReader) {
                reader.close();
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (closeReader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static InputStream deleteOnClose(InputStream delegate, final File file) {
        return new FilterInputStream(delegate){

            @Override
            public void close() throws IOException {
                super.close();
                file.delete();
            }
        };
    }

    public static OutputStream[] compareOutput(final int n, Runnable whenIdentical, Runnable whenNotIdentical) {
        abstract class ChecksumOutputStream
        extends OutputStream {
            private final Checksum checksum = new CRC32();
            private long count;
            protected final long[] checksums = new long[IoUtil.access$1().length];
            protected int idx;
            private boolean closed;

            ChecksumOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream is closed");
                }
                if (this.count == THRESHOLDS[this.idx]) {
                    this.pushChecksum();
                }
                this.checksum.update(b);
                ++this.count;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void write(@Nullable byte[] b, int off, int len) throws IOException {
                if (!IoUtil.$assertionsDisabled && b == null) {
                    throw new AssertionError();
                }
                if (!this.closed) ** GOTO lbl11
                throw new IOException("Stream is closed");
lbl-1000:
                // 1 sources

                {
                    part = (int)Math.min(0x7FFFFFFFL, IoUtil.access$1()[this.idx] - this.count);
                    this.checksum.update(b, off, part);
                    this.count = IoUtil.access$1()[this.idx];
                    this.pushChecksum();
                    off += part;
                    len -= part;
lbl11:
                    // 2 sources

                    ** while (this.count + (long)len > IoUtil.access$1()[this.idx])
                }
lbl12:
                // 1 sources

                this.checksum.update(b, off, len);
                this.count += (long)len;
            }

            private void pushChecksum() {
                this.checksums[this.idx] = this.checksum.getValue();
                this.checksumWasPushed(this.idx);
                ++this.idx;
            }

            abstract void checksumWasPushed(int var1);

            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.pushChecksum();
                this.closed = true;
                this.wasClosed();
            }

            abstract void wasClosed();
        }
        OutputStream[] result = new ChecksumOutputStream[n];
        int i = 0;
        while (i < n) {
            result[i] = new ChecksumOutputStream((ChecksumOutputStream[])result, whenNotIdentical, whenIdentical){
                private final /* synthetic */ ChecksumOutputStream[] val$result;
                private final /* synthetic */ Runnable val$whenNotIdentical;
                private final /* synthetic */ Runnable val$whenIdentical;
                {
                    this.val$result = checksumOutputStreamArray;
                    this.val$whenNotIdentical = runnable;
                    this.val$whenIdentical = runnable2;
                }

                @Override
                void checksumWasPushed(int idx) {
                    int i = 0;
                    while (i < n) {
                        if (this.val$result[i].idx == idx + 1 && this.val$result[i].checksums[idx] != this.checksums[idx]) {
                            this.val$whenNotIdentical.run();
                            return;
                        }
                        ++i;
                    }
                }

                @Override
                void wasClosed() {
                    int i = 0;
                    while (i < n) {
                        if (!this.val$result[i].closed) {
                            return;
                        }
                        if (this.val$result[i].idx != this.idx || this.val$result[i].checksums[this.idx - 1] != this.checksums[this.idx - 1]) {
                            this.val$whenNotIdentical.run();
                            return;
                        }
                        ++i;
                    }
                    this.val$whenIdentical.run();
                }
            };
            ++i;
        }
        return result;
    }

    public static OutputStream lengthWritten(final Consumer<? super Integer> delegate) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                delegate.consume(1);
            }

            @Override
            public void write(@Nullable byte[] b, int off, int len) {
                delegate.consume(len);
            }
        };
    }

    public static Reader asReader(final CharSequence cs) {
        return new Reader(){
            int pos;

            @Override
            public int read() {
                return this.pos >= cs.length() ? -1 : (int)cs.charAt(this.pos++);
            }

            @Override
            public int read(@Nullable char[] cbuf, int off, int len) {
                if (!$assertionsDisabled && cbuf == null) {
                    throw new AssertionError();
                }
                if (len <= 0) {
                    return 0;
                }
                if (this.pos >= cs.length()) {
                    return -1;
                }
                int end = cs.length();
                if (this.pos + len > end) {
                    len = end - this.pos;
                } else {
                    end = this.pos + len;
                }
                int i = this.pos;
                while (i < end) {
                    cbuf[off++] = cs.charAt(i++);
                }
                return len;
            }

            @Override
            public void close() {
            }
        };
    }

    public static void copyResource(ClassLoader classLoader, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = classLoader.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(Class<?> clasS, String resourceName, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        InputStream is = clasS.getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(resourceName);
        }
        IoUtil.copy(is, true, outputStream, closeOutputStream);
    }

    public static void copyResource(final ClassLoader classLoader, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(classLoader, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    public static void copyResource(final Class<?> clasS, final String resourceName, File toFile, boolean createMissingParentDirectories) throws IOException {
        IoUtil.outputFileOutputStream(toFile, new ConsumerWhichThrows<OutputStream, IOException>(){

            @Override
            public void consume(OutputStream outputStream) throws IOException {
                IoUtil.copyResource(clasS, resourceName, outputStream, false);
            }
        }, createMissingParentDirectories);
    }

    public static <EX extends Exception> void asFile(InputStream inputStream, boolean closeInputStream, @Nullable String prefix, @Nullable String suffix, @Nullable File directory, ConsumerWhichThrows<? super File, ? extends EX> delegate) throws IOException, EX {
        File temporaryFile = File.createTempFile(prefix, suffix, directory);
        try {
            temporaryFile.deleteOnExit();
            IoUtil.copy(inputStream, closeInputStream, temporaryFile);
            delegate.consume(temporaryFile);
            temporaryFile.delete();
        }
        finally {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            temporaryFile.delete();
        }
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, Charset charset, ConsumerWhichThrows<? super PrintWriter, ? extends EX> printer) throws IOException, EX {
        IoUtil.outputFilePrintWriter(file, charset, printer, false);
    }

    public static <EX extends Throwable> void outputFilePrintWriter(File file, final Charset charset, final ConsumerWhichThrows<? super PrintWriter, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        final boolean[] hasError = new boolean[1];
        IoUtil.outputFileOutputStream(file, new ConsumerWhichThrows<OutputStream, EX>(){

            @Override
            public void consume(OutputStream os) throws Throwable {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, charset));
                delegate.consume(pw);
                hasError[0] = pw.checkError();
            }
        }, createMissingParentDirectories);
        if (hasError[0]) {
            throw new IOException();
        }
    }

    public static <EX extends Throwable> void outputFileOutputStream(File file, final ConsumerWhichThrows<? super OutputStream, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        class IORuntimeException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            private final IOException ioe;

            IORuntimeException(IOException ioe) {
                this.ioe = ioe;
            }
        }
        try {
            IoUtil.outputFile(file, new ConsumerWhichThrows<File, EX>(){

                @Override
                public void consume(File file) throws Throwable {
                    try {
                        FileOutputStream os = new FileOutputStream(file);
                        try {
                            delegate.consume(os);
                        }
                        catch (RuntimeException re) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw re;
                        }
                        catch (Error e) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw e;
                        }
                        catch (Throwable t) {
                            try {
                                ((OutputStream)os).close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Throwable tmp = t;
                            throw tmp;
                        }
                        ((OutputStream)os).close();
                    }
                    catch (IOException ioe) {
                        throw new IORuntimeException(ioe);
                    }
                }
            }, createMissingParentDirectories);
        }
        catch (IORuntimeException iore) {
            throw iore.ioe;
        }
    }

    public static <EX extends Throwable> void outputFile(File file, ConsumerWhichThrows<? super File, ? extends EX> delegate, boolean createMissingParentDirectories) throws IOException, EX {
        if (createMissingParentDirectories) {
            IoUtil.createMissingParentDirectoriesFor(file);
        }
        File newFile = new File(file.getParentFile(), "." + file.getName() + ".new");
        try {
            delegate.consume(newFile);
            if (file.exists() && !file.delete()) {
                throw new IOException("Could not delete existing file \"" + file + "\"");
            }
            if (!newFile.renameTo(file)) {
                throw new IOException("Could not rename \"" + newFile + "\" to \"" + file + "\"");
            }
        }
        catch (RuntimeException re) {
            newFile.delete();
            throw re;
        }
        catch (Error e) {
            newFile.delete();
            throw e;
        }
        catch (Throwable t) {
            newFile.delete();
            Throwable tmp = t;
            throw tmp;
        }
    }

    public static void createMissingParentDirectoriesFor(File file) throws IOException {
        File parentDirectory = file.getParentFile();
        if (parentDirectory == null) {
            return;
        }
        if (!parentDirectory.isDirectory() && !parentDirectory.mkdirs()) {
            throw new IOException("Cannot create directory \"" + parentDirectory + "\"");
        }
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IoUtil.copyAvailable(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long copyAvailable(InputStream inputStream, OutputStream outputStream, long n) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (n > 0L && inputStream.available() > 0) {
            try {
                LOGGER.log(Level.FINEST, "About to ''read(byte[{0}])''", buffer.length);
                int m = inputStream.read(buffer, 0, (int)Math.min(n, (long)buffer.length));
                LOGGER.log(Level.FINEST, "''read()'' returned {0}", m);
                if (m == -1) {
                    throw new IllegalStateException("EOI despite available()");
                }
                LOGGER.log(Level.FINEST, "About to ''write(byte[{0}])''", m);
                outputStream.write(buffer, 0, m);
                LOGGER.log(Level.FINEST, "'write()' returned");
                count += (long)m;
                n -= (long)m;
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap(String.valueOf(count) + " bytes copied so far", ioe);
            }
        }
        outputStream.flush();
        LOGGER.log(Level.FINEST, "{0} bytes copied", count);
        return count;
    }

    public static InputStream onEndOfInput(InputStream delegate, final Runnable runnable) {
        return new FilterInputStream(delegate){
            boolean hadEndOfInput;

            @Override
            public int read() throws IOException {
                int b = super.read();
                if (b == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return b;
            }

            @Override
            public int read(@Nullable byte[] b, int off, int len) throws IOException {
                int count = super.read(b, off, len);
                if (count == -1 && !this.hadEndOfInput) {
                    this.hadEndOfInput = true;
                    runnable.run();
                }
                return count;
            }
        };
    }

    public static interface WritingRunnable {
        public void run(Writer var1) throws Exception;
    }
}

